/*
 * Decompiled with CFR 0.152.
 */
package org.joone.engine.learning;

import java.io.IOException;
import java.util.TreeSet;
import org.joone.engine.Fifo;
import org.joone.engine.Monitor;
import org.joone.engine.NetErrorManager;
import org.joone.engine.NeuralNetEvent;
import org.joone.engine.Pattern;
import org.joone.engine.Synapse;
import org.joone.engine.learning.TeacherSynapse;
import org.joone.io.StreamInputSynapse;
import org.joone.log.ILogger;
import org.joone.log.LoggerFactory;
import org.joone.net.NetCheck;

public class ComparisonSynapse
extends Synapse {
    private static final ILogger log = LoggerFactory.getLogger(TeacherSynapse.class);
    private StreamInputSynapse desired;
    protected transient Fifo fifo;
    protected transient boolean firstTime = true;
    private static final long serialVersionUID = -1301682557631180066L;

    @Override
    protected void backward(double[] pattern) {
    }

    @Override
    protected void forward(double[] pActual) {
        if (this.m_pattern.getCount() == 1 || this.m_pattern.getCount() == -1) {
            try {
                this.desired.gotoFirstLine();
            }
            catch (IOException ioe) {
                log.warn("IOException while forwarding the influx. Message is : " + ioe.getMessage(), ioe);
            }
        }
        if (this.m_pattern.getCount() == -1) {
            this.stopTheNet();
            return;
        }
        this.firstTime = false;
        this.outs = new double[pActual.length];
        Pattern pattDesired = this.desired.fwdGet();
        if (this.m_pattern.getCount() != pattDesired.getCount()) {
            new NetErrorManager(this.getMonitor(), "ComparisonSynapse: No matching patterns - input#" + this.m_pattern.getCount() + " desired#" + pattDesired.getCount());
            return;
        }
        double[] pTarget = pattDesired.getArray();
        if (pTarget != null) {
            this.outs = new double[this.getOutputDimension()];
            int i = 0;
            int n = 0;
            while (i < pActual.length) {
                this.outs[n] = pActual[i];
                ++i;
                ++n;
            }
            i = 0;
            while (i < pTarget.length) {
                this.outs[n] = pTarget[i];
                ++i;
                ++n;
            }
            this.pushValue(this.outs, this.m_pattern.getCount());
        }
    }

    protected void stopTheNet() {
        this.pushStop();
        this.firstTime = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Pattern fwdGet() {
        ComparisonSynapse comparisonSynapse = this;
        synchronized (comparisonSynapse) {
            while (this.getFifo().empty()) {
                try {
                    this.wait();
                }
                catch (InterruptedException ie) {
                    log.warn("wait() was interrupted. Message is : " + ie.getMessage());
                    return null;
                }
            }
            Pattern errPatt = (Pattern)this.fifo.pop();
            this.notifyAll();
            return errPatt;
        }
    }

    @Override
    public void fwdPut(Pattern pattern) {
        int step = pattern.getCount();
        if (!this.isEnabled()) {
            if (step == -1) {
                this.stopTheNet();
            }
            return;
        }
        super.fwdPut(pattern);
        this.items = 0;
    }

    public StreamInputSynapse getDesired() {
        return this.desired;
    }

    private Fifo getFifo() {
        if (this.fifo == null) {
            this.fifo = new Fifo();
        }
        return this.fifo;
    }

    @Override
    public Pattern revGet() {
        return null;
    }

    @Override
    public void revPut(Pattern pattern) {
    }

    @Override
    protected void setArrays(int rows, int cols) {
    }

    public boolean setDesired(StreamInputSynapse newDesired) {
        if (newDesired == null) {
            if (this.desired != null) {
                this.desired.setInputFull(false);
            }
            this.desired = newDesired;
        } else {
            if (newDesired.isInputFull()) {
                return false;
            }
            this.desired = newDesired;
            this.desired.setStepCounter(false);
            this.desired.setOutputDimension(this.getInputDimension());
            this.desired.setInputFull(true);
        }
        return true;
    }

    public void resetInput() {
        if (this.getDesired() != null) {
            this.getDesired().resetInput();
        }
    }

    @Override
    protected void setDimensions(int rows, int cols) {
    }

    @Override
    public void setInputDimension(int newInputDimension) {
        super.setInputDimension(newInputDimension);
        if (this.getDesired() != null) {
            this.getDesired().setOutputDimension(newInputDimension);
        }
    }

    @Override
    public TreeSet check() {
        TreeSet checks = super.check();
        if (this.desired == null) {
            checks.add(new NetCheck(0, "Desired Input has not been set.", this));
        } else {
            checks.addAll(this.desired.check());
        }
        return checks;
    }

    @Override
    public void reset() {
        super.reset();
        if (this.getDesired() != null) {
            this.getDesired().reset();
        }
    }

    @Override
    public void setMonitor(Monitor newMonitor) {
        super.setMonitor(newMonitor);
        if (this.getMonitor() != null) {
            this.getMonitor().setSupervised(true);
        }
    }

    public void netStoppedError(NeuralNetEvent e, String error) {
        this.pushStop();
        this.firstTime = true;
        this.reset();
    }

    private void pushStop() {
        double[] arr = new double[this.getOutputDimension()];
        this.pushValue(arr, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pushValue(double[] arr, int count) {
        Pattern patt = new Pattern(arr);
        patt.setCount(count);
        ComparisonSynapse comparisonSynapse = this;
        synchronized (comparisonSynapse) {
            this.getFifo().push(patt);
            this.notify();
        }
    }

    @Override
    public int getOutputDimension() {
        return this.getInputDimension() * 2;
    }

    @Override
    public void init() {
        super.init();
        if (this.getDesired() != null) {
            this.getDesired().init();
        }
    }
}

