/*
 * Decompiled with CFR 0.152.
 */
package org.joone.edit;

import CH.ifa.draw.figures.TextFigure;
import CH.ifa.draw.framework.ConnectionFigure;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureChangeEvent;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.standard.CompositeFigure;
import CH.ifa.draw.standard.DeleteCommand;
import CH.ifa.draw.standard.NullHandle;
import CH.ifa.draw.standard.RelativeLocator;
import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.joone.edit.GenericFigure;
import org.joone.edit.PropertySheet;
import org.joone.edit.UpdatableFigure;
import org.joone.edit.Wrapper;
import org.joone.edit.inspection.InspectionFrame;
import org.joone.inspection.Inspectable;
import org.joone.log.ILogger;
import org.joone.log.LoggerFactory;

public abstract class ConcreteGenericFigure
extends CompositeFigure
implements GenericFigure,
UpdatableFigure {
    public static final ILogger log = LoggerFactory.getLogger(ConcreteGenericFigure.class);
    protected static final int BORDER = 3;
    protected Rectangle fDisplayBox;
    protected Hashtable params;
    protected static int numLayers = 0;
    private static final long serialVersionUID = -6051314440171003005L;

    @Override
    protected void basicMoveBy(int x, int y) {
        this.fDisplayBox.translate(x, y);
        super.basicMoveBy(x, y);
    }

    @Override
    public Rectangle displayBox() {
        return new Rectangle(this.fDisplayBox.x, this.fDisplayBox.y, this.fDisplayBox.width, this.fDisplayBox.height);
    }

    @Override
    public void basicDisplayBox(Point origin, Point corner) {
        this.fDisplayBox = new Rectangle(origin);
        this.fDisplayBox.add(corner);
        this.layout();
    }

    private void drawBorder(Graphics g) {
        super.draw(g);
        Rectangle r = this.displayBox();
        Figure f = this.figureAt(0);
        Rectangle rf = f.displayBox();
        g.setColor(Color.gray);
        g.drawLine(r.x, r.y + rf.height + 2, r.x + r.width, r.y + rf.height + 2);
        g.setColor(Color.white);
        g.drawLine(r.x, r.y + rf.height + 3, r.x + r.width, r.y + rf.height + 3);
        g.setColor(Color.white);
        g.drawLine(r.x, r.y, r.x, r.y + r.height);
        g.drawLine(r.x, r.y, r.x + r.width, r.y);
        g.setColor(Color.gray);
        g.drawLine(r.x + r.width, r.y, r.x + r.width, r.y + r.height);
        g.drawLine(r.x, r.y + r.height, r.x + r.width, r.y + r.height);
    }

    @Override
    public void draw(Graphics g) {
        this.drawBorder(g);
        super.draw(g);
    }

    @Override
    public Vector handles() {
        Vector<NullHandle> handles = new Vector<NullHandle>();
        handles.addElement(new NullHandle(this, RelativeLocator.northWest()));
        handles.addElement(new NullHandle(this, RelativeLocator.northEast()));
        handles.addElement(new NullHandle(this, RelativeLocator.southWest()));
        handles.addElement(new NullHandle(this, RelativeLocator.southEast()));
        return this.addHandles(handles);
    }

    protected abstract Vector addHandles(Vector var1);

    public void initialize() {
        this.fDisplayBox = new Rectangle(0, 0, 0, 0);
        Font fb = new Font("Helvetica", 1, 12);
        TextFigure type = new TextFigure();
        type.setFont(fb);
        type.setText((String)this.getParam("type"));
        type.setAttribute("TextColor", Color.white);
        type.setReadOnly(true);
        this.add(type);
        this.initContent();
    }

    protected abstract void initContent();

    private void layout() {
        Point partOrigin = new Point(this.fDisplayBox.x, this.fDisplayBox.y);
        partOrigin.translate(3, 3);
        Dimension extent = new Dimension(0, 0);
        FigureEnumeration k = this.figures();
        while (k.hasMoreElements()) {
            Figure f = k.nextFigure();
            Dimension partExtent = f.size();
            Point corner = new Point(partOrigin.x + partExtent.width, partOrigin.y + partExtent.height);
            f.basicDisplayBox(partOrigin, corner);
            extent.width = Math.max(extent.width, partExtent.width);
            extent.height += partExtent.height;
            partOrigin.y += partExtent.height;
        }
        this.fDisplayBox.width = extent.width + 6;
        this.fDisplayBox.height = extent.height + 6;
    }

    private boolean needsLayout() {
        Dimension extent = new Dimension(0, 0);
        FigureEnumeration k = this.figures();
        while (k.hasMoreElements()) {
            Figure f = k.nextFigure();
            extent.width = Math.max(extent.width, f.size().width);
        }
        int newExtent = extent.width + 6;
        return newExtent != this.fDisplayBox.width;
    }

    public void update(FigureChangeEvent e) {
        if (this.needsLayout()) {
            this.layout();
            this.changed();
        }
    }

    @Override
    public void update() {
        FigureEnumeration k = this.figures();
        while (k.hasMoreElements()) {
            Figure f = k.nextFigure();
            if (!(f instanceof UpdatableFigure)) continue;
            UpdatableFigure uf = (UpdatableFigure)((Object)f);
            uf.update();
        }
        this.layout();
        this.changed();
    }

    @Override
    public void figureChanged(FigureChangeEvent e) {
        this.update(e);
    }

    @Override
    public void figureRemoved(FigureChangeEvent e) {
        this.update(e);
    }

    public void notifyPostConn() {
    }

    @Override
    public void write(StorableOutput dw) {
        super.write(dw);
        dw.writeInt(this.fDisplayBox.x);
        dw.writeInt(this.fDisplayBox.y);
        dw.writeInt(this.fDisplayBox.width);
        dw.writeInt(this.fDisplayBox.height);
    }

    @Override
    public void read(StorableInput dr) throws IOException {
        super.read(dr);
        this.fDisplayBox = new Rectangle(dr.readInt(), dr.readInt(), dr.readInt(), dr.readInt());
        this.layout();
    }

    @Override
    public Insets connectionInsets() {
        Rectangle r = this.fDisplayBox;
        int cx = r.width / 2;
        int cy = r.height / 2;
        return new Insets(cy, cx, cy, cx);
    }

    protected Object createLayer() {
        try {
            Class<?> cLayer = Class.forName((String)this.getParam("class"));
            Object ly = cLayer.newInstance();
            return ly;
        }
        catch (ClassNotFoundException cnfe) {
            String msg = "ClassNotFoundException  was thrown. Message is : " + cnfe.getMessage();
            log.warn(msg, cnfe);
        }
        catch (InstantiationException ie) {
            String msg = "InstantiationException was thrown. Message is : " + ie.getMessage();
            log.warn(msg, ie);
        }
        catch (IllegalAccessException iae) {
            String msg = "IllegalAccessException was thrown. Message is : " + iae.getMessage();
            log.warn(msg, iae);
        }
        return null;
    }

    @Override
    public Object getParam(Object key) {
        return this.params.get(key);
    }

    @Override
    public void setParam(Object key, Object newParam) {
        this.params.put(key, newParam);
    }

    @Override
    public void setParams(Hashtable newParams) {
        this.params = newParams;
    }

    @Override
    public abstract Wrapper getWrapper();

    @Override
    public boolean canConnect(GenericFigure start, ConnectionFigure conn) {
        return false;
    }

    public abstract Object getLayer();

    public JPopupMenu getPopupMenu(final PropertySheet ps, final DrawingView view) {
        JPopupMenu jpm = new JPopupMenu();
        JMenuItem jmi = new JMenuItem("Properties");
        jmi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ps != null) {
                    Wrapper wrap = ConcreteGenericFigure.this.getWrapper();
                    ps.setTarget(wrap);
                    ps.pack();
                    if (ps.getSize().width < 250) {
                        ps.setSize(new Dimension(250, ps.getSize().height));
                    }
                    ps.show();
                }
            }
        });
        jpm.add(jmi);
        jmi = new JMenuItem("Delete");
        jmi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new DeleteCommand("Delete", view).execute();
            }
        });
        jpm.add(jmi);
        if (this.getWrapper().getBean() instanceof Inspectable) {
            jmi = new JMenuItem("Inspect");
            jmi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Inspectable inspectable = (Inspectable)ConcreteGenericFigure.this.getWrapper().getBean();
                    InspectionFrame iFrame = new InspectionFrame(inspectable);
                    iFrame.show();
                }
            });
            jpm.add(jmi);
        }
        return jpm;
    }
}

