/*
 * Decompiled with CFR 0.152.
 */
package org.joone.edit;

import java.awt.Component;
import java.awt.Dimension;
import java.io.IOException;
import java.io.ObjectInputStream;
import org.joone.edit.AbstractChartSynapse;
import org.joone.edit.ChartingHandle;
import org.joone.edit.DrawingRegion;
import org.joone.edit.SharedBuffer;
import org.joone.engine.NetErrorManager;
import org.joone.engine.Pattern;

public class ChartOutputSynapse
extends AbstractChartSynapse {
    private static final long serialVersionUID = 7501332794591309201L;
    private transient DrawingRegion myDrawingRegion;
    private transient SharedBuffer grafBuffer;

    private void initDrawingRegion(int mainTrainingCycles) {
        this.iFrame.getContentPane().removeAll();
        this.myDrawingRegion = new DrawingRegion(new Dimension(550, 350), this.getMaxYaxis(), mainTrainingCycles);
        this.iFrame.getContentPane().add((Component)this.myDrawingRegion, "Center");
        this.iFrame.setSize(560, 360);
        this.iFrame.pack();
    }

    @Override
    public void setMaxYaxis(double maxYaxis) {
        super.setMaxYaxis(maxYaxis);
        if (this.myDrawingRegion != null) {
            this.myDrawingRegion.setMaxYvalue(maxYaxis);
        }
    }

    @Override
    public void setMaxXaxis(int maxXaxis) {
        super.setMaxXaxis(maxXaxis);
        if (this.myDrawingRegion != null) {
            this.myDrawingRegion.setMaxXvalue(maxXaxis);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.getTitle() == null) {
            this.setTitle("Chart");
            this.setName("Chart");
            this.setMaxXaxis(10000);
            this.setMaxYaxis(1.0);
            this.setResizable(true);
            this.setSerie(1);
            super.initComponents();
        }
        this.myDrawingRegion = null;
    }

    @Override
    public void fwdPut(Pattern pattern, ChartingHandle handle) {
        if (this.isEnabled()) {
            SharedBuffer buffer = this.getDrawingRegion().getBuffer(handle);
            this.fwdPut(pattern, handle.getSerie(), buffer);
        }
    }

    @Override
    public void fwdPut(Pattern pattern) {
        if (this.isEnabled()) {
            if (this.getSerie() > pattern.getArray().length) {
                new NetErrorManager(this.getMonitor(), "ChartOutputSynapse: '" + this.getName() + "' - Serie greater than the pattern's length");
                return;
            }
            this.grafBuffer = this.getDrawingRegion().getBuffer();
            this.fwdPut(pattern, this.getSerie(), this.grafBuffer);
        }
    }

    private void fwdPut(Pattern pattern, int numSerie, SharedBuffer buffer) {
        if (pattern.getCount() > -1) {
            double[] array = pattern.getArray();
            double cycle = pattern.getCount();
            buffer.put(array[numSerie - 1], cycle);
        }
    }

    private DrawingRegion getDrawingRegion() {
        if (this.myDrawingRegion == null) {
            this.initDrawingRegion(this.maxXaxis);
        }
        return this.myDrawingRegion;
    }

    @Override
    public void removeHandle(ChartingHandle handle) {
        if (this.myDrawingRegion != null) {
            this.myDrawingRegion.removeHandle(handle);
        }
    }
}

