/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.standard.AbstractTool;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;

public class SelectAreaTracker
extends AbstractTool {
    private Rectangle fSelectGroup;

    public SelectAreaTracker(DrawingView view) {
        super(view);
    }

    @Override
    public void mouseDown(MouseEvent e, int x, int y) {
        super.mouseDown(e, e.getX(), e.getY());
        this.rubberBand(this.fAnchorX, this.fAnchorY, this.fAnchorX, this.fAnchorY);
    }

    @Override
    public void mouseDrag(MouseEvent e, int x, int y) {
        super.mouseDrag(e, x, y);
        this.eraseRubberBand();
        this.rubberBand(this.fAnchorX, this.fAnchorY, x, y);
    }

    @Override
    public void mouseUp(MouseEvent e, int x, int y) {
        super.mouseUp(e, x, y);
        this.eraseRubberBand();
        this.selectGroup(e.isShiftDown());
    }

    private void rubberBand(int x1, int y1, int x2, int y2) {
        this.fSelectGroup = new Rectangle(new Point(x1, y1));
        this.fSelectGroup.add(new Point(x2, y2));
        this.drawXORRect(this.fSelectGroup);
    }

    private void eraseRubberBand() {
        this.drawXORRect(this.fSelectGroup);
    }

    private void drawXORRect(Rectangle r) {
        Graphics g = this.view().getGraphics();
        g.setXORMode(this.view().getBackground());
        g.setColor(Color.black);
        g.drawRect(r.x, r.y, r.width, r.height);
    }

    private void selectGroup(boolean toggle) {
        FigureEnumeration k = this.drawing().figuresReverse();
        while (k.hasMoreElements()) {
            Figure figure = k.nextFigure();
            Rectangle r2 = figure.displayBox();
            if (!this.fSelectGroup.contains(r2.x, r2.y) || !this.fSelectGroup.contains(r2.x + r2.width, r2.y + r2.height)) continue;
            if (toggle) {
                this.view().toggleSelection(figure);
                continue;
            }
            this.view().addToSelection(figure);
        }
    }
}

