/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.HJDError;
import CH.ifa.draw.standard.AbstractTool;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;

public class CreationTool
extends AbstractTool {
    private Point fAnchorPoint;
    private Figure fCreatedFigure;
    private Figure fPrototype;

    public CreationTool(DrawingView view, Figure prototype) {
        super(view);
        this.fPrototype = prototype;
    }

    protected CreationTool(DrawingView view) {
        super(view);
        this.fPrototype = null;
    }

    @Override
    public void activate() {
        this.view().setCursor(Cursor.getPredefinedCursor(1));
    }

    @Override
    public void mouseDown(MouseEvent e, int x, int y) {
        this.fAnchorPoint = new Point(x, y);
        this.fCreatedFigure = this.createFigure();
        this.fCreatedFigure.displayBox(this.fAnchorPoint, this.fAnchorPoint);
        this.view().add(this.fCreatedFigure);
    }

    protected Figure createFigure() {
        if (this.fPrototype == null) {
            throw new HJDError("No protoype defined");
        }
        return (Figure)this.fPrototype.clone();
    }

    @Override
    public void mouseDrag(MouseEvent e, int x, int y) {
        this.fCreatedFigure.displayBox(this.fAnchorPoint, new Point(x, y));
    }

    @Override
    public void mouseUp(MouseEvent e, int x, int y) {
        if (this.fCreatedFigure.isEmpty()) {
            this.drawing().remove(this.fCreatedFigure);
        }
        this.fCreatedFigure = null;
        this.editor().toolDone();
    }

    protected Figure createdFigure() {
        return this.fCreatedFigure;
    }
}

