/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.Handle;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;

public abstract class AbstractHandle
implements Handle {
    public static final int HANDLESIZE = 8;
    private Figure fOwner;

    public AbstractHandle(Figure owner) {
        this.fOwner = owner;
    }

    @Override
    public abstract Point locate();

    @Override
    public void invokeStart(int x, int y, Drawing drawing) {
    }

    @Override
    public void invokeStart(int x, int y, DrawingView view) {
        this.invokeStart(x, y, view.drawing());
    }

    @Override
    public void invokeStep(int dx, int dy, Drawing drawing) {
    }

    @Override
    public void invokeStep(int x, int y, int anchorX, int anchorY, DrawingView view) {
        this.invokeStep(x - anchorX, y - anchorY, view.drawing());
    }

    @Override
    public void invokeEnd(int x, int y, int anchorX, int anchorY, DrawingView view) {
        this.invokeEnd(x - anchorX, y - anchorY, view.drawing());
    }

    @Override
    public void invokeEnd(int dx, int dy, Drawing drawing) {
    }

    @Override
    public Figure owner() {
        return this.fOwner;
    }

    @Override
    public Rectangle displayBox() {
        Point p = this.locate();
        return new Rectangle(p.x - 4, p.y - 4, 8, 8);
    }

    @Override
    public boolean containsPoint(int x, int y) {
        return this.displayBox().contains(x, y);
    }

    @Override
    public void draw(Graphics g) {
        Rectangle r = this.displayBox();
        g.setColor(Color.white);
        g.fillRect(r.x, r.y, r.width, r.height);
        g.setColor(Color.black);
        g.drawRect(r.x, r.y, r.width, r.height);
    }
}

