/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.framework.Connector;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureChangeEvent;
import CH.ifa.draw.framework.FigureChangeListener;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.framework.Locator;
import CH.ifa.draw.standard.ChopBoxConnector;
import CH.ifa.draw.standard.FigureChangeEventMulticaster;
import CH.ifa.draw.standard.FigureEnumerator;
import CH.ifa.draw.standard.RelativeLocator;
import CH.ifa.draw.util.Geom;
import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Vector;

public abstract class AbstractFigure
implements Figure {
    private transient FigureChangeListener fListener;
    private static final long serialVersionUID = -10857585979273442L;
    private int abstractFigureSerializedDataVersion = 1;

    protected AbstractFigure() {
    }

    @Override
    public void moveBy(int dx, int dy) {
        this.willChange();
        this.basicMoveBy(dx, dy);
        this.changed();
    }

    protected abstract void basicMoveBy(int var1, int var2);

    @Override
    public void displayBox(Point origin, Point corner) {
        this.willChange();
        this.basicDisplayBox(origin, corner);
        this.changed();
    }

    @Override
    public abstract void basicDisplayBox(Point var1, Point var2);

    @Override
    public abstract Rectangle displayBox();

    @Override
    public abstract Vector handles();

    @Override
    public FigureEnumeration figures() {
        Vector<AbstractFigure> figures = new Vector<AbstractFigure>(1);
        figures.addElement(this);
        return new FigureEnumerator(figures);
    }

    @Override
    public Dimension size() {
        return new Dimension(this.displayBox().width, this.displayBox().height);
    }

    @Override
    public boolean isEmpty() {
        return this.size().width < 3 || this.size().height < 3;
    }

    @Override
    public Figure findFigureInside(int x, int y) {
        if (this.containsPoint(x, y)) {
            return this;
        }
        return null;
    }

    @Override
    public boolean containsPoint(int x, int y) {
        return this.displayBox().contains(x, y);
    }

    @Override
    public void displayBox(Rectangle r) {
        this.displayBox(new Point(r.x, r.y), new Point(r.x + r.width, r.y + r.height));
    }

    @Override
    public boolean includes(Figure figure) {
        return figure == this;
    }

    @Override
    public FigureEnumeration decompose() {
        Vector<AbstractFigure> figures = new Vector<AbstractFigure>(1);
        figures.addElement(this);
        return new FigureEnumerator(figures);
    }

    @Override
    public void addToContainer(FigureChangeListener c) {
        this.addFigureChangeListener(c);
        this.invalidate();
    }

    @Override
    public void removeFromContainer(FigureChangeListener c) {
        this.invalidate();
        this.removeFigureChangeListener(c);
        this.changed();
    }

    @Override
    public void addFigureChangeListener(FigureChangeListener l) {
        this.fListener = FigureChangeEventMulticaster.add(this.fListener, l);
    }

    @Override
    public void removeFigureChangeListener(FigureChangeListener l) {
        this.fListener = FigureChangeEventMulticaster.remove(this.fListener, l);
    }

    @Override
    public FigureChangeListener listener() {
        return this.fListener;
    }

    @Override
    public void release() {
        if (this.fListener != null) {
            this.fListener.figureRemoved(new FigureChangeEvent(this));
        }
    }

    @Override
    public void invalidate() {
        if (this.fListener != null) {
            Rectangle r = this.displayBox();
            r.grow(8, 8);
            this.fListener.figureInvalidated(new FigureChangeEvent(this, r));
        }
    }

    @Override
    public void willChange() {
        this.invalidate();
    }

    @Override
    public void changed() {
        this.invalidate();
        if (this.fListener != null) {
            this.fListener.figureChanged(new FigureChangeEvent(this));
        }
    }

    @Override
    public Point center() {
        return Geom.center(this.displayBox());
    }

    @Override
    public boolean canConnect() {
        return true;
    }

    @Override
    public Insets connectionInsets() {
        return new Insets(0, 0, 0, 0);
    }

    @Override
    public Connector connectorAt(int x, int y) {
        return new ChopBoxConnector(this);
    }

    @Override
    public void connectorVisibility(boolean isVisible) {
    }

    @Override
    public Locator connectedTextLocator(Figure text) {
        return RelativeLocator.center();
    }

    @Override
    public Object getAttribute(String name) {
        return null;
    }

    @Override
    public void setAttribute(String name, Object value) {
    }

    @Override
    public Object clone() {
        Object clone = null;
        ByteArrayOutputStream output = new ByteArrayOutputStream(200);
        try {
            ObjectOutputStream writer = new ObjectOutputStream(output);
            writer.writeObject(this);
            writer.close();
        }
        catch (IOException e) {
            System.out.println("Class not found: " + e);
        }
        ByteArrayInputStream input = new ByteArrayInputStream(output.toByteArray());
        try {
            ObjectInputStream reader = new ObjectInputStream(input);
            clone = reader.readObject();
        }
        catch (IOException e) {
            System.out.println(e.toString());
        }
        catch (ClassNotFoundException e) {
            System.out.println("Class not found: " + e);
        }
        return clone;
    }

    @Override
    public void write(StorableOutput dw) {
    }

    @Override
    public void read(StorableInput dr) throws IOException {
    }
}

