/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.contrib;

import CH.ifa.draw.application.DrawApplication;
import CH.ifa.draw.standard.StandardDrawingView;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;

public class SplitPaneDrawApplication
extends DrawApplication {
    private JComponent leftComponent;
    private JComponent rightComponent;

    public SplitPaneDrawApplication() {
        super("JHotDraw");
    }

    public SplitPaneDrawApplication(String title) {
        super(title);
    }

    @Override
    protected JComponent createContents(StandardDrawingView view) {
        this.createLeftComponent(view);
        this.createRightComponent(view);
        if (this.getLeftComponent() == null && this.getRightComponent() == null) {
            return super.createContents(view);
        }
        if (this.getLeftComponent() == null) {
            return this.getRightComponent();
        }
        if (this.getRightComponent() == null) {
            return this.getLeftComponent();
        }
        return this.createSplitPane(view);
    }

    protected JSplitPane createSplitPane(StandardDrawingView view) {
        JSplitPane dividedContents = new JSplitPane(1, this.getLeftComponent(), this.getRightComponent());
        dividedContents.setAlignmentX(0.0f);
        dividedContents.setOneTouchExpandable(true);
        return dividedContents;
    }

    protected void createLeftComponent(StandardDrawingView view) {
        this.setLeftComponent(new JScrollPane(new JList()));
    }

    protected final void setLeftComponent(JComponent newLeftComponent) {
        this.leftComponent = newLeftComponent;
    }

    public JComponent getLeftComponent() {
        return this.leftComponent;
    }

    protected void createRightComponent(StandardDrawingView view) {
        this.setRightComponent(super.createContents(view));
    }

    protected final void setRightComponent(JComponent newRightComponent) {
        this.rightComponent = newRightComponent;
    }

    public JComponent getRightComponent() {
        return this.rightComponent;
    }
}

