/*
 * Decompiled with CFR 0.152.
 */
package joptima.functions;

import joptima.Parameter;
import joptima.functions.ConstrainableFunction;

public class Quadratic
extends ConstrainableFunction {
    public double m_a;
    public double m_b;
    public double m_c;
    private String m_name = "Quadratic";

    @Override
    public Parameter[] getParameters() {
        Parameter[] parameters = new Parameter[this.countUnconstrained()];
        try {
            int cursor = 0;
            if (!this.m_constrained[0]) {
                parameters[cursor++] = new Parameter(this, "a");
            }
            if (!this.m_constrained[1]) {
                parameters[cursor++] = new Parameter(this, "b");
            }
            if (!this.m_constrained[2]) {
                parameters[cursor++] = new Parameter(this, "c");
            }
        }
        catch (NoSuchFieldException nsfe) {
            nsfe.printStackTrace();
        }
        return parameters;
    }

    @Override
    public void constrain(String parametername) {
        if ("a".equals(parametername)) {
            this.m_constrained[0] = true;
        }
        if ("b".equals(parametername)) {
            this.m_constrained[1] = true;
        }
        if ("c".equals(parametername)) {
            this.m_constrained[2] = true;
        }
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public void setName(String newname) {
        this.m_name = newname;
    }

    public Quadratic() {
        this(1.0, 0.0, 0.0);
    }

    public Quadratic(double a, double b, double c) {
        this.m_a = a;
        this.m_b = b;
        this.m_c = c;
        this.m_constrained = new boolean[3];
    }

    @Override
    public double calculate(double x) {
        return this.m_a * x * x + this.m_b * x + this.m_c;
    }

    public double getA() {
        return this.m_a;
    }

    public void setA(double a) {
        this.m_a = a;
    }

    public double getB() {
        return this.m_b;
    }

    public void setB(double b) {
        this.m_b = b;
    }

    public double getC() {
        return this.m_c;
    }

    public void setC(double c) {
        this.m_c = c;
    }
}

