/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.rsl.jpop;

import edu.stanford.rsl.jpop.BlockThread;
import edu.stanford.rsl.jpop.FunctionController;
import edu.stanford.rsl.jpop.FunctionOptimizer;
import edu.stanford.rsl.jpop.GradientOptimizableFunction;
import edu.stanford.rsl.jpop.HessianOptimizableFunction;
import edu.stanford.rsl.jpop.OptimizableFunction;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class ParallelFunctionController
extends FunctionController {
    protected boolean debug = true;

    @Override
    public double evaluate(OptimizableFunction function, double[] x) {
        BlockThread[] blocks = this.initializeBlocks(x, function, FunctionOptimizer.OptimizationMode.Function);
        try {
            this.runParallel(blocks);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        double[] results = new double[blocks.length];
        for (int i = 0; i < blocks.length; ++i) {
            results[i] = (Double)blocks[i].getResult();
        }
        return this.assembler.assembleEvaluationBlocks(results);
    }

    @Override
    public double[] gradient(GradientOptimizableFunction function, double[] x) {
        BlockThread[] blocks = this.initializeBlocks(x, function, FunctionOptimizer.OptimizationMode.Gradient);
        try {
            this.runParallel(blocks);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        double[][] results = new double[blocks.length][];
        for (int i = 0; i < blocks.length; ++i) {
            results[i] = (double[])blocks[i].getResult();
        }
        return this.assembler.assembleGradientBlocks(results);
    }

    @Override
    public double[][] hessian(HessianOptimizableFunction function, double[] x) {
        BlockThread[] blocks = this.initializeBlocks(x, function, FunctionOptimizer.OptimizationMode.Hessian);
        try {
            this.runParallel(blocks);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        double[][][] results = new double[blocks.length][][];
        for (int i = 0; i < blocks.length; ++i) {
            results[i] = (double[][])blocks[i].getResult();
        }
        return this.assembler.assembleHessianBlocks(results);
    }

    protected BlockThread[] initializeBlocks(double[] x, OptimizableFunction function, FunctionOptimizer.OptimizationMode mode) {
        int threads = function.getNumberOfProcessingBlocks();
        BlockThread[] blocks = new BlockThread[function.getNumberOfProcessingBlocks()];
        for (int i = 0; i < threads; ++i) {
            blocks[i] = new BlockThread();
            blocks[i].setX(x);
            blocks[i].setBlock(i);
            blocks[i].setFunction(function);
            blocks[i].setMode(mode);
        }
        return blocks;
    }

    protected void runParallel(BlockThread[] threads) throws InterruptedException {
        ExecutorService e = Executors.newFixedThreadPool(threads.length);
        CountDownLatch latch = new CountDownLatch(threads.length);
        for (int i = 0; i < threads.length; ++i) {
            if (this.debug) {
                System.out.println("Running " + i + " of " + threads.length);
            }
            threads[i].setLatch(latch);
            e.submit(threads[i]);
        }
        latch.await();
        e.shutdownNow();
    }
}

