/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.rsl.jpop;

import edu.stanford.rsl.jpop.FunctionOptimizer;
import edu.stanford.rsl.jpop.GradientOptimizableFunction;
import edu.stanford.rsl.jpop.HessianOptimizableFunction;
import edu.stanford.rsl.jpop.OptimizableFunction;
import java.util.Arrays;
import java.util.concurrent.CountDownLatch;

public class BlockThread
extends Thread {
    private FunctionOptimizer.OptimizationMode mode;
    private double[] x;
    private int block;
    private OptimizableFunction function;
    private Object result;
    private CountDownLatch latch;

    public FunctionOptimizer.OptimizationMode getMode() {
        return this.mode;
    }

    public void setMode(FunctionOptimizer.OptimizationMode mode) {
        this.mode = mode;
    }

    public double[] getX() {
        return this.x;
    }

    public void setX(double[] x) {
        this.x = Arrays.copyOf(x, x.length);
    }

    public int getBlock() {
        return this.block;
    }

    public void setBlock(int block) {
        this.block = block;
    }

    public OptimizableFunction getFunction() {
        return this.function;
    }

    public void setFunction(OptimizableFunction function) {
        this.function = function;
    }

    public Object getResult() {
        return this.result;
    }

    public void setLatch(CountDownLatch latch) {
        this.latch = latch;
    }

    public CountDownLatch getLatch() {
        return this.latch;
    }

    @Override
    public void run() {
        if (this.mode == FunctionOptimizer.OptimizationMode.Function) {
            this.result = new Double(this.function.evaluate(this.x, this.block));
        } else if (this.mode == FunctionOptimizer.OptimizationMode.Gradient) {
            this.result = ((GradientOptimizableFunction)this.function).gradient(this.x, this.block);
        } else if (this.mode == FunctionOptimizer.OptimizationMode.Hessian) {
            this.result = ((HessianOptimizableFunction)this.function).hessian(this.x, this.block);
        }
        this.latch.countDown();
    }
}

