/*
 * Decompiled with CFR 0.152.
 */
package com.joptimizer.util;

import com.joptimizer.util.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.MatrixUtils;
import org.apache.commons.math3.linear.RealMatrix;

public class CholeskyFactorization {
    double[][] Q;
    double[][] L;
    double[][] LT;
    List<Double> eigenvalues;
    private Log log = LogFactory.getLog((String)this.getClass().getName());

    public CholeskyFactorization(double[][] Q) throws Exception {
        this.Q = Q;
        this.factorize();
    }

    private void factorize() throws Exception {
        if (!MatrixUtils.isSymmetric((RealMatrix)new Array2DRowRealMatrix(this.Q), (double)Utils.getDoubleMachineEpsilon())) {
            throw new Exception("Matrix is not symmetric");
        }
        int N = this.Q.length;
        double[][] L = new double[N][N];
        this.eigenvalues = new ArrayList<Double>();
        for (int i = 0; i < N; ++i) {
            for (int j = 0; j <= i; ++j) {
                double sum = 0.0;
                for (int k = 0; k < j; ++k) {
                    sum += L[i][k] * L[j][k];
                }
                if (i == j) {
                    double d = Math.sqrt(this.Q[i][i] - sum);
                    if (Double.isNaN(d) || d * d < Utils.getDoubleMachineEpsilon()) {
                        this.log.warn((Object)("Not positive eigenvalues: " + d * d));
                        throw new Exception("not positive definite matrix");
                    }
                    L[i][i] = d;
                    this.eigenvalues.add(this.eigenvalues.size(), d * d);
                    continue;
                }
                L[i][j] = 1.0 / L[j][j] * (this.Q[i][j] - sum);
            }
        }
        this.L = L;
    }

    public double[][] getInverse() {
        double[][] lTData = this.getLT();
        int dim = lTData.length;
        double[] diag = new double[dim];
        Arrays.fill(diag, 1.0);
        double[][] x = MatrixUtils.createRealDiagonalMatrix((double[])diag).getData();
        for (int j = 0; j < dim; ++j) {
            double[] lTJ = lTData[j];
            double lTJJ = lTJ[j];
            double[] xJ = x[j];
            int k = 0;
            while (k < dim) {
                int n = k++;
                xJ[n] = xJ[n] / lTJJ;
            }
            for (int i = j + 1; i < dim; ++i) {
                double[] xI = x[i];
                double lTJI = lTJ[i];
                for (int k2 = 0; k2 < dim; ++k2) {
                    int n = k2;
                    xI[n] = xI[n] - xJ[k2] * lTJI;
                }
            }
        }
        double[][] LInvTData = new double[dim][dim];
        for (int i = 0; i < dim; ++i) {
            double[] LInvTDatai = LInvTData[i];
            for (int j = i; j < dim; ++j) {
                LInvTDatai[j] = x[j][i];
            }
        }
        double[][] QInvData = new double[dim][dim];
        for (int row = 0; row < dim; ++row) {
            double[] LInvTDataRow = LInvTData[row];
            double[] QInvDataRow = QInvData[row];
            for (int col = row; col < dim; ++col) {
                double[] LInvTDataCol = LInvTData[col];
                double sum = 0.0;
                for (int i = col; i < dim; ++i) {
                    sum += LInvTDataRow[i] * LInvTDataCol[i];
                }
                QInvDataRow[col] = sum;
                QInvData[col][row] = sum;
            }
        }
        return QInvData;
    }

    public double[][] getL() {
        return this.L;
    }

    public double[][] getLT() {
        if (this.LT == null) {
            this.LT = new Array2DRowRealMatrix(this.L).transpose().getData();
        }
        return this.LT;
    }

    public List<Double> getEigenvalues() {
        return this.eigenvalues;
    }
}

