/*
 * Decompiled with CFR 0.152.
 */
package com.joptimizer.solvers;

import cern.colt.matrix.DoubleFactory2D;
import cern.colt.matrix.DoubleMatrix2D;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.commons.math3.linear.CholeskyDecomposition;
import org.apache.commons.math3.linear.MatrixUtils;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.RealVector;

public abstract class KKTSolver {
    protected RealMatrix H;
    protected RealMatrix A;
    protected RealMatrix AT;
    protected RealVector g;
    protected RealVector h;
    protected double toleranceKKT;
    protected boolean checkKKTSolutionAccuracy;
    private DoubleFactory2D F2 = DoubleFactory2D.dense;
    private Log log = LogFactory.getLog((String)this.getClass().getName());

    public abstract double[][] solve() throws Exception;

    public void setHMatrix(double[][] HMatrix) {
        this.H = new Array2DRowRealMatrix(HMatrix, false);
    }

    public void setAMatrix(double[][] AMatrix) {
        if (AMatrix != null && AMatrix.length > 0) {
            this.A = new Array2DRowRealMatrix(AMatrix, false);
        }
    }

    public void setATMatrix(double[][] ATMatrix) {
        if (ATMatrix != null && ATMatrix.length > 0) {
            this.AT = new Array2DRowRealMatrix(ATMatrix, false);
        }
    }

    public void setGVector(double[] gVector) {
        this.g = new ArrayRealVector(gVector);
    }

    public void setHVector(double[] hVector) {
        if (hVector != null && hVector.length > 0) {
            this.h = new ArrayRealVector(hVector);
        }
    }

    public void setToleranceKKT(double tolerance) {
        this.toleranceKKT = tolerance;
    }

    public void setCheckKKTSolutionAccuracy(boolean b) {
        this.checkKKTSolutionAccuracy = b;
    }

    protected double[][] solveFullKKT(KKTSolver kktSolver) throws Exception {
        this.log.debug((Object)"solveFullKKT");
        RealMatrix HATA = this.H.add(this.AT.multiply(this.A));
        try {
            CholeskyDecomposition cFact = new CholeskyDecomposition(HATA);
            cFact.getSolver().getInverse();
        }
        catch (Exception e) {
            throw new Exception("singular KKT system");
        }
        kktSolver.setHMatrix(HATA.getData());
        kktSolver.setAMatrix(this.A.getData());
        kktSolver.setATMatrix(this.AT.getData());
        kktSolver.setGVector(this.g.toArray());
        if (this.h != null) {
            RealVector ATQh = this.AT.operate(MatrixUtils.createRealIdentityMatrix((int)this.A.getRowDimension()).operate(this.h));
            RealVector gATQh = this.g.add(ATQh);
            kktSolver.setGVector(gATQh.toArray());
            kktSolver.setHVector(this.h.toArray());
        }
        return kktSolver.solve();
    }

    protected boolean checkKKTSolutionAccuracy(RealVector v, RealVector w) {
        double norm;
        DoubleMatrix2D M = this.F2.make(this.H.getData());
        if (this.A != null) {
            if (this.h != null) {
                DoubleMatrix2D[][] parts = new DoubleMatrix2D[][]{{this.F2.make(this.H.getData()), this.F2.make(this.AT.getData())}, {this.F2.make(this.A.getData()), null}};
                M = this.F2.compose(parts);
                Array2DRowRealMatrix KKT = new Array2DRowRealMatrix(M.toArray());
                RealVector X = v.append(w);
                RealVector Y = this.g.append(this.h);
                norm = KKT.operate(X).add(Y).getNorm();
            } else {
                norm = this.H.operate(v).add(this.AT.operate(w)).add(this.g).getNorm();
            }
        } else {
            norm = this.H.operate(v).add(this.g).getNorm();
        }
        this.log.debug((Object)("KKT solution error: " + norm));
        return norm < this.toleranceKKT;
    }
}

