/*
 * Decompiled with CFR 0.152.
 */
package com.joptimizer.solvers;

import com.joptimizer.solvers.KKTSolver;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.commons.math3.linear.RealVector;

public class DiagonalKKTSolver
extends KKTSolver {
    private Log log = LogFactory.getLog((String)this.getClass().getName());

    @Override
    public double[][] solve() throws Exception {
        ArrayRealVector v = null;
        RealVector w = null;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("H: " + ArrayUtils.toString((Object)this.H.getData())));
            this.log.debug((Object)("g: " + ArrayUtils.toString((Object)this.g.toArray())));
        }
        v = new ArrayRealVector(this.g.getDimension());
        for (int i = 0; i < v.getDimension(); ++i) {
            v.setEntry(i, -this.g.getEntry(i) / this.H.getEntry(i, i));
        }
        if (this.checkKKTSolutionAccuracy && !this.checkKKTSolutionAccuracy((RealVector)v, w)) {
            this.log.error((Object)"KKT solution failed");
            throw new Exception("KKT solution failed");
        }
        double[][] ret = new double[][]{v.toArray(), w != null ? w.toArray() : null};
        return ret;
    }
}

