/*
 * Decompiled with CFR 0.152.
 */
package com.joptimizer.optimizers;

import cern.colt.matrix.DoubleFactory1D;
import cern.colt.matrix.DoubleFactory2D;
import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.linalg.Algebra;
import com.joptimizer.functions.ConvexMultivariateRealFunction;
import com.joptimizer.functions.LinearMultivariateRealFunction;
import com.joptimizer.functions.PDQuadraticMultivariateRealFunction;
import com.joptimizer.optimizers.OptimizationRequest;
import com.joptimizer.optimizers.OptimizationResponse;
import com.joptimizer.optimizers.PrimalDualMethod;
import com.joptimizer.util.Utils;
import java.util.Arrays;
import junit.framework.TestCase;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PrimalDualMethodHeavyTest
extends TestCase {
    private int dim = 10;
    private long seed = 7654321L;
    private Algebra ALG = Algebra.DEFAULT;
    private DoubleFactory1D F1 = DoubleFactory1D.dense;
    private DoubleFactory2D F2 = DoubleFactory2D.dense;
    private Log log = LogFactory.getLog((String)((Object)((Object)this)).getClass().getName());

    public void testOptimize() throws Exception {
        this.log.debug((Object)"testOptimize");
        DoubleMatrix2D P = Utils.randomValuesPositiveMatrix(this.dim, this.dim, -0.5, 0.5, this.seed);
        DoubleMatrix1D q = Utils.randomValuesMatrix(1, this.dim, -0.5, 0.5, this.seed).viewRow(0);
        PDQuadraticMultivariateRealFunction objectiveFunction = new PDQuadraticMultivariateRealFunction(P.toArray(), q.toArray(), 0.0);
        double[][] AEMatrix = new double[1][this.dim];
        Arrays.fill(AEMatrix[0], 1.0);
        double[] BEVector = new double[]{1.0};
        double[][] AIMatrix = new double[this.dim][this.dim];
        for (int i = 0; i < this.dim; ++i) {
            AIMatrix[i][i] = -1.0;
        }
        ConvexMultivariateRealFunction[] inequalities = new ConvexMultivariateRealFunction[this.dim];
        for (int i = 0; i < this.dim; ++i) {
            inequalities[i] = new LinearMultivariateRealFunction(AIMatrix[i], 0.0);
        }
        OptimizationRequest or = new OptimizationRequest();
        or.setF0(objectiveFunction);
        double[] ip = new double[this.dim];
        Arrays.fill(ip, 1.0 / (double)this.dim);
        or.setInitialPoint(ip);
        or.setA(AEMatrix);
        or.setB(BEVector);
        or.setFi(inequalities);
        PrimalDualMethod opt = new PrimalDualMethod();
        opt.setOptimizationRequest(or);
        int returnCode = opt.optimize();
        if (returnCode == 2) {
            PrimalDualMethodHeavyTest.fail();
        }
        OptimizationResponse response = opt.getOptimizationResponse();
        double[] sol = response.getSolution();
        double value = objectiveFunction.value(sol);
        this.log.debug((Object)("sol   : " + ArrayUtils.toString((Object)sol)));
        this.log.debug((Object)("value : " + value));
    }
}

