/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.svg.io;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.awt.Color;
import java.awt.Font;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URI;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.StyledDocument;
import net.n3.nanoxml.IXMLElement;
import net.n3.nanoxml.XMLElement;
import net.n3.nanoxml.XMLWriter;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.io.OutputFormat;
import org.jhotdraw.geom.BezierPath;
import org.jhotdraw.gui.datatransfer.InputStreamTransferable;
import org.jhotdraw.gui.filechooser.ExtensionFileFilter;
import org.jhotdraw.io.Base64;
import org.jhotdraw.samples.svg.Gradient;
import org.jhotdraw.samples.svg.LinearGradient;
import org.jhotdraw.samples.svg.RadialGradient;
import org.jhotdraw.samples.svg.SVGAttributeKeys;
import org.jhotdraw.samples.svg.figures.SVGBezierFigure;
import org.jhotdraw.samples.svg.figures.SVGEllipseFigure;
import org.jhotdraw.samples.svg.figures.SVGGroupFigure;
import org.jhotdraw.samples.svg.figures.SVGImageFigure;
import org.jhotdraw.samples.svg.figures.SVGPathFigure;
import org.jhotdraw.samples.svg.figures.SVGRectFigure;
import org.jhotdraw.samples.svg.figures.SVGTextAreaFigure;
import org.jhotdraw.samples.svg.figures.SVGTextFigure;

public class SVGOutputFormat
implements OutputFormat {
    private int nextId;
    private HashMap<IXMLElement, String> identifiedElements;
    private IXMLElement defs;
    private IXMLElement document;
    private HashMap<Gradient, String> gradientToIDMap;
    private boolean isPrettyPrint;
    private static final HashMap<Integer, String> strokeLinejoinMap = new HashMap();
    private static final HashMap<Integer, String> strokeLinecapMap;
    private static final boolean isFloatPrecision = true;

    @Override
    public FileFilter getFileFilter() {
        return new ExtensionFileFilter("Scalable Vector Graphics (SVG)", "svg");
    }

    @Override
    public JComponent getOutputFormatAccessory() {
        return null;
    }

    public void setPrettyPrint(boolean newValue) {
        this.isPrettyPrint = newValue;
    }

    public boolean isPrettyPrint() {
        return this.isPrettyPrint;
    }

    protected void writeElement(IXMLElement parent, Figure f) throws IOException {
        if (f.get(SVGAttributeKeys.LINK) != null && f.get(SVGAttributeKeys.LINK).trim().length() > 0) {
            IXMLElement aElement = parent.createElement("a");
            aElement.setAttribute("xlink:href", f.get(SVGAttributeKeys.LINK));
            if (f.get(SVGAttributeKeys.LINK_TARGET) != null && f.get(SVGAttributeKeys.LINK).trim().length() > 0) {
                aElement.setAttribute("target", f.get(SVGAttributeKeys.LINK_TARGET));
            }
            parent.addChild(aElement);
            parent = aElement;
        }
        if (f instanceof SVGEllipseFigure) {
            SVGEllipseFigure ellipse = (SVGEllipseFigure)f;
            if (ellipse.getWidth() == ellipse.getHeight()) {
                this.writeCircleElement(parent, ellipse);
            } else {
                this.writeEllipseElement(parent, ellipse);
            }
        } else if (f instanceof SVGGroupFigure) {
            this.writeGElement(parent, (SVGGroupFigure)f);
        } else if (f instanceof SVGImageFigure) {
            this.writeImageElement(parent, (SVGImageFigure)f);
        } else if (f instanceof SVGPathFigure) {
            SVGPathFigure path = (SVGPathFigure)f;
            if (path.getChildCount() == 1) {
                SVGBezierFigure bezier = path.getChild(0);
                boolean isLinear = true;
                int n = bezier.getNodeCount();
                for (int i = 0; i < n; ++i) {
                    if (bezier.getNode(i).getMask() == 0) continue;
                    isLinear = false;
                    break;
                }
                if (isLinear) {
                    if (bezier.isClosed()) {
                        this.writePolygonElement(parent, path);
                    } else if (bezier.getNodeCount() == 2) {
                        this.writeLineElement(parent, path);
                    } else {
                        this.writePolylineElement(parent, path);
                    }
                } else {
                    this.writePathElement(parent, path);
                }
            } else {
                this.writePathElement(parent, path);
            }
        } else if (f instanceof SVGRectFigure) {
            this.writeRectElement(parent, (SVGRectFigure)f);
        } else if (f instanceof SVGTextFigure) {
            this.writeTextElement(parent, (SVGTextFigure)f);
        } else if (f instanceof SVGTextAreaFigure) {
            this.writeTextAreaElement(parent, (SVGTextAreaFigure)f);
        } else {
            System.out.println("Unable to write: " + f);
        }
    }

    protected void writeCircleElement(IXMLElement parent, SVGEllipseFigure f) throws IOException {
        parent.addChild(this.createCircle(this.document, f.getX() + f.getWidth() / 2.0, f.getY() + f.getHeight() / 2.0, f.getWidth() / 2.0, f.getAttributes()));
    }

    protected IXMLElement createCircle(IXMLElement doc, double cx, double cy, double r, Map<AttributeKey, Object> attributes) throws IOException {
        IXMLElement elem = doc.createElement("circle");
        this.writeAttribute(elem, "cx", cx, 0.0);
        this.writeAttribute(elem, "cy", cy, 0.0);
        this.writeAttribute(elem, "r", r, 0.0);
        this.writeShapeAttributes(elem, attributes);
        this.writeOpacityAttribute(elem, attributes);
        this.writeTransformAttribute(elem, attributes);
        return elem;
    }

    protected IXMLElement createG(IXMLElement doc, Map<AttributeKey, Object> attributes) throws IOException {
        IXMLElement elem = doc.createElement("g");
        this.writeOpacityAttribute(elem, attributes);
        return elem;
    }

    protected IXMLElement createLinearGradient(IXMLElement doc, double x1, double y1, double x2, double y2, double[] stopOffsets, Color[] stopColors, double[] stopOpacities, boolean isRelativeToFigureBounds, AffineTransform transform) throws IOException {
        IXMLElement elem = doc.createElement("linearGradient");
        this.writeAttribute(elem, "x1", SVGOutputFormat.toNumber(x1), "0");
        this.writeAttribute(elem, "y1", SVGOutputFormat.toNumber(y1), "0");
        this.writeAttribute(elem, "x2", SVGOutputFormat.toNumber(x2), "1");
        this.writeAttribute(elem, "y2", SVGOutputFormat.toNumber(y2), "0");
        this.writeAttribute(elem, "gradientUnits", isRelativeToFigureBounds ? "objectBoundingBox" : "userSpaceOnUse", "objectBoundingBox");
        this.writeAttribute(elem, "gradientTransform", SVGOutputFormat.toTransform(transform), "none");
        for (int i = 0; i < stopOffsets.length; ++i) {
            XMLElement stop = new XMLElement("stop");
            this.writeAttribute((IXMLElement)stop, "offset", SVGOutputFormat.toNumber(stopOffsets[i]), null);
            this.writeAttribute((IXMLElement)stop, "stop-color", SVGOutputFormat.toColor(stopColors[i]), null);
            this.writeAttribute((IXMLElement)stop, "stop-opacity", SVGOutputFormat.toNumber(stopOpacities[i]), "1");
            elem.addChild(stop);
        }
        return elem;
    }

    protected IXMLElement createRadialGradient(IXMLElement doc, double cx, double cy, double fx, double fy, double r, double[] stopOffsets, Color[] stopColors, double[] stopOpacities, boolean isRelativeToFigureBounds, AffineTransform transform) throws IOException {
        IXMLElement elem = doc.createElement("radialGradient");
        this.writeAttribute(elem, "cx", SVGOutputFormat.toNumber(cx), "0.5");
        this.writeAttribute(elem, "cy", SVGOutputFormat.toNumber(cy), "0.5");
        this.writeAttribute(elem, "fx", SVGOutputFormat.toNumber(fx), SVGOutputFormat.toNumber(cx));
        this.writeAttribute(elem, "fy", SVGOutputFormat.toNumber(fy), SVGOutputFormat.toNumber(cy));
        this.writeAttribute(elem, "r", SVGOutputFormat.toNumber(r), "0.5");
        this.writeAttribute(elem, "gradientUnits", isRelativeToFigureBounds ? "objectBoundingBox" : "userSpaceOnUse", "objectBoundingBox");
        this.writeAttribute(elem, "gradientTransform", SVGOutputFormat.toTransform(transform), "none");
        for (int i = 0; i < stopOffsets.length; ++i) {
            XMLElement stop = new XMLElement("stop");
            this.writeAttribute((IXMLElement)stop, "offset", SVGOutputFormat.toNumber(stopOffsets[i]), null);
            this.writeAttribute((IXMLElement)stop, "stop-color", SVGOutputFormat.toColor(stopColors[i]), null);
            this.writeAttribute((IXMLElement)stop, "stop-opacity", SVGOutputFormat.toNumber(stopOpacities[i]), "1");
            elem.addChild(stop);
        }
        return elem;
    }

    protected void writeEllipseElement(IXMLElement parent, SVGEllipseFigure f) throws IOException {
        parent.addChild(this.createEllipse(this.document, f.getX() + f.getWidth() / 2.0, f.getY() + f.getHeight() / 2.0, f.getWidth() / 2.0, f.getHeight() / 2.0, f.getAttributes()));
    }

    protected IXMLElement createEllipse(IXMLElement doc, double cx, double cy, double rx, double ry, Map<AttributeKey, Object> attributes) throws IOException {
        IXMLElement elem = doc.createElement("ellipse");
        this.writeAttribute(elem, "cx", cx, 0.0);
        this.writeAttribute(elem, "cy", cy, 0.0);
        this.writeAttribute(elem, "rx", rx, 0.0);
        this.writeAttribute(elem, "ry", ry, 0.0);
        this.writeShapeAttributes(elem, attributes);
        this.writeOpacityAttribute(elem, attributes);
        this.writeTransformAttribute(elem, attributes);
        return elem;
    }

    protected void writeGElement(IXMLElement parent, SVGGroupFigure f) throws IOException {
        IXMLElement elem = this.createG(this.document, f.getAttributes());
        for (Figure child : f.getChildren()) {
            this.writeElement(elem, child);
        }
        parent.addChild(elem);
    }

    protected void writeImageElement(IXMLElement parent, SVGImageFigure f) throws IOException {
        parent.addChild(this.createImage(this.document, f.getX(), f.getY(), f.getWidth(), f.getHeight(), f.getImageData(), f.getAttributes()));
    }

    protected IXMLElement createImage(IXMLElement doc, double x, double y, double w, double h, byte[] imageData, Map<AttributeKey, Object> attributes) throws IOException {
        IXMLElement elem = doc.createElement("image");
        this.writeAttribute(elem, "x", x, 0.0);
        this.writeAttribute(elem, "y", y, 0.0);
        this.writeAttribute(elem, "width", w, 0.0);
        this.writeAttribute(elem, "height", h, 0.0);
        this.writeAttribute(elem, "xlink:href", "data:image;base64," + Base64.encodeBytes(imageData), "");
        this.writeOpacityAttribute(elem, attributes);
        this.writeTransformAttribute(elem, attributes);
        return elem;
    }

    protected void writePathElement(IXMLElement parent, SVGPathFigure f) throws IOException {
        BezierPath[] beziers = new BezierPath[f.getChildCount()];
        for (int i = 0; i < beziers.length; ++i) {
            beziers[i] = f.getChild(i).getBezierPath();
        }
        parent.addChild(this.createPath(this.document, beziers, f.getAttributes()));
    }

    protected IXMLElement createPath(IXMLElement doc, BezierPath[] beziers, Map<AttributeKey, Object> attributes) throws IOException {
        IXMLElement elem = doc.createElement("path");
        this.writeShapeAttributes(elem, attributes);
        this.writeOpacityAttribute(elem, attributes);
        this.writeTransformAttribute(elem, attributes);
        this.writeAttribute(elem, "d", SVGOutputFormat.toPath(beziers), null);
        return elem;
    }

    protected void writePolygonElement(IXMLElement parent, SVGPathFigure f) throws IOException {
        LinkedList<Point2D.Double> points = new LinkedList<Point2D.Double>();
        int n = f.getChildCount();
        for (int i = 0; i < n; ++i) {
            BezierPath bezier = f.getChild(i).getBezierPath();
            for (BezierPath.Node node : bezier) {
                points.add(new Point2D.Double(node.x[0], node.y[0]));
            }
        }
        parent.addChild(this.createPolygon(this.document, points.toArray(new Point2D.Double[points.size()]), f.getAttributes()));
    }

    protected IXMLElement createPolygon(IXMLElement doc, Point2D.Double[] points, Map<AttributeKey, Object> attributes) throws IOException {
        IXMLElement elem = doc.createElement("polygon");
        this.writeAttribute(elem, "points", SVGOutputFormat.toPoints(points), null);
        this.writeShapeAttributes(elem, attributes);
        this.writeOpacityAttribute(elem, attributes);
        this.writeTransformAttribute(elem, attributes);
        return elem;
    }

    protected void writePolylineElement(IXMLElement parent, SVGPathFigure f) throws IOException {
        LinkedList<Point2D.Double> points = new LinkedList<Point2D.Double>();
        int n = f.getChildCount();
        for (int i = 0; i < n; ++i) {
            BezierPath bezier = f.getChild(i).getBezierPath();
            for (BezierPath.Node node : bezier) {
                points.add(new Point2D.Double(node.x[0], node.y[0]));
            }
        }
        parent.addChild(this.createPolyline(this.document, points.toArray(new Point2D.Double[points.size()]), f.getAttributes()));
    }

    protected IXMLElement createPolyline(IXMLElement doc, Point2D.Double[] points, Map<AttributeKey, Object> attributes) throws IOException {
        IXMLElement elem = doc.createElement("polyline");
        this.writeAttribute(elem, "points", SVGOutputFormat.toPoints(points), null);
        this.writeShapeAttributes(elem, attributes);
        this.writeOpacityAttribute(elem, attributes);
        this.writeTransformAttribute(elem, attributes);
        return elem;
    }

    protected void writeLineElement(IXMLElement parent, SVGPathFigure f) throws IOException {
        SVGBezierFigure bezier = f.getChild(0);
        parent.addChild(this.createLine(this.document, bezier.getNode((int)0).x[0], bezier.getNode((int)0).y[0], bezier.getNode((int)1).x[0], bezier.getNode((int)1).y[0], f.getAttributes()));
    }

    protected IXMLElement createLine(IXMLElement doc, double x1, double y1, double x2, double y2, Map<AttributeKey, Object> attributes) throws IOException {
        IXMLElement elem = doc.createElement("line");
        this.writeAttribute(elem, "x1", x1, 0.0);
        this.writeAttribute(elem, "y1", y1, 0.0);
        this.writeAttribute(elem, "x2", x2, 0.0);
        this.writeAttribute(elem, "y2", y2, 0.0);
        this.writeShapeAttributes(elem, attributes);
        this.writeOpacityAttribute(elem, attributes);
        this.writeTransformAttribute(elem, attributes);
        return elem;
    }

    protected void writeRectElement(IXMLElement parent, SVGRectFigure f) throws IOException {
        parent.addChild(this.createRect(this.document, f.getX(), f.getY(), f.getWidth(), f.getHeight(), f.getArcWidth(), f.getArcHeight(), f.getAttributes()));
    }

    protected IXMLElement createRect(IXMLElement doc, double x, double y, double width, double height, double rx, double ry, Map<AttributeKey, Object> attributes) throws IOException {
        IXMLElement elem = doc.createElement("rect");
        this.writeAttribute(elem, "x", x, 0.0);
        this.writeAttribute(elem, "y", y, 0.0);
        this.writeAttribute(elem, "width", width, 0.0);
        this.writeAttribute(elem, "height", height, 0.0);
        this.writeAttribute(elem, "rx", rx, 0.0);
        this.writeAttribute(elem, "ry", ry, 0.0);
        this.writeShapeAttributes(elem, attributes);
        this.writeOpacityAttribute(elem, attributes);
        this.writeTransformAttribute(elem, attributes);
        return elem;
    }

    protected void writeTextElement(IXMLElement parent, SVGTextFigure f) throws IOException {
        DefaultStyledDocument styledDoc = new DefaultStyledDocument();
        try {
            styledDoc.insertString(0, f.getText(), null);
        }
        catch (BadLocationException e) {
            InternalError error = new InternalError(e.getMessage());
            error.initCause(e);
            throw error;
        }
        parent.addChild(this.createText(this.document, f.getCoordinates(), f.getRotates(), styledDoc, f.getAttributes()));
    }

    protected IXMLElement createText(IXMLElement doc, Point2D.Double[] coordinates, double[] rotate, StyledDocument text, Map<AttributeKey, Object> attributes) throws IOException {
        String str;
        IXMLElement elem = doc.createElement("text");
        StringBuilder bufX = new StringBuilder();
        StringBuilder bufY = new StringBuilder();
        for (int i = 0; i < coordinates.length; ++i) {
            if (i != 0) {
                bufX.append(',');
                bufY.append(',');
            }
            bufX.append(SVGOutputFormat.toNumber(coordinates[i].getX()));
            bufY.append(SVGOutputFormat.toNumber(coordinates[i].getY()));
        }
        StringBuilder bufR = new StringBuilder();
        if (rotate != null) {
            for (int i = 0; i < rotate.length; ++i) {
                if (i != 0) {
                    bufR.append(',');
                }
                bufR.append(SVGOutputFormat.toNumber(rotate[i]));
            }
        }
        this.writeAttribute(elem, "x", bufX.toString(), "0");
        this.writeAttribute(elem, "y", bufY.toString(), "0");
        this.writeAttribute(elem, "rotate", bufR.toString(), "");
        try {
            str = text.getText(0, text.getLength());
        }
        catch (BadLocationException e) {
            InternalError error = new InternalError(e.getMessage());
            error.initCause(e);
            throw error;
        }
        elem.setContent(str);
        this.writeShapeAttributes(elem, attributes);
        this.writeOpacityAttribute(elem, attributes);
        this.writeTransformAttribute(elem, attributes);
        this.writeFontAttributes(elem, attributes);
        return elem;
    }

    protected void writeTextAreaElement(IXMLElement parent, SVGTextAreaFigure f) throws IOException {
        DefaultStyledDocument styledDoc = new DefaultStyledDocument();
        try {
            styledDoc.insertString(0, f.getText(), null);
        }
        catch (BadLocationException e) {
            InternalError error = new InternalError(e.getMessage());
            error.initCause(e);
            throw error;
        }
        Rectangle2D.Double bounds = f.getBounds();
        parent.addChild(this.createTextArea(this.document, bounds.x, bounds.y, bounds.width, bounds.height, styledDoc, f.getAttributes()));
    }

    protected IXMLElement createTextArea(IXMLElement doc, double x, double y, double w, double h, StyledDocument text, Map<AttributeKey, Object> attributes) throws IOException {
        String str;
        IXMLElement elem = doc.createElement("textArea");
        this.writeAttribute(elem, "x", SVGOutputFormat.toNumber(x), "0");
        this.writeAttribute(elem, "y", SVGOutputFormat.toNumber(y), "0");
        this.writeAttribute(elem, "width", SVGOutputFormat.toNumber(w), "0");
        this.writeAttribute(elem, "height", SVGOutputFormat.toNumber(h), "0");
        try {
            str = text.getText(0, text.getLength());
        }
        catch (BadLocationException e) {
            InternalError error = new InternalError(e.getMessage());
            error.initCause(e);
            throw error;
        }
        String[] lines = str.split("\n");
        for (int i = 0; i < lines.length; ++i) {
            if (i != 0) {
                elem.addChild(doc.createElement("tbreak"));
            }
            IXMLElement contentElement = doc.createElement(null);
            contentElement.setContent(lines[i]);
            elem.addChild(contentElement);
        }
        this.writeShapeAttributes(elem, attributes);
        this.writeTransformAttribute(elem, attributes);
        this.writeOpacityAttribute(elem, attributes);
        this.writeFontAttributes(elem, attributes);
        return elem;
    }

    protected void writeShapeAttributes(IXMLElement elem, Map<AttributeKey, Object> m) throws IOException {
        RadialGradient rg;
        IXMLElement gradientElem;
        LinearGradient lg;
        String id;
        Gradient gradient = SVGAttributeKeys.FILL_GRADIENT.get(m);
        if (gradient != null) {
            if (this.gradientToIDMap.containsKey(gradient)) {
                id = this.gradientToIDMap.get(gradient);
            } else {
                if (gradient instanceof LinearGradient) {
                    lg = (LinearGradient)gradient;
                    gradientElem = this.createLinearGradient(this.document, lg.getX1(), lg.getY1(), lg.getX2(), lg.getY2(), lg.getStopOffsets(), lg.getStopColors(), lg.getStopOpacities(), lg.isRelativeToFigureBounds(), lg.getTransform());
                } else {
                    rg = (RadialGradient)gradient;
                    gradientElem = this.createRadialGradient(this.document, rg.getCX(), rg.getCY(), rg.getFX(), rg.getFY(), rg.getR(), rg.getStopOffsets(), rg.getStopColors(), rg.getStopOpacities(), rg.isRelativeToFigureBounds(), rg.getTransform());
                }
                id = this.getId(gradientElem);
                gradientElem.setAttribute("id", "xml", id);
                this.defs.addChild(gradientElem);
                this.gradientToIDMap.put(gradient, id);
            }
            this.writeAttribute(elem, "fill", "url(#" + id + ")", "#000");
        } else {
            this.writeAttribute(elem, "fill", SVGOutputFormat.toColor((Color)SVGAttributeKeys.FILL_COLOR.get(m)), "#000");
        }
        this.writeAttribute(elem, "fill-opacity", SVGAttributeKeys.FILL_OPACITY.get(m), 1.0);
        if (SVGAttributeKeys.WINDING_RULE.get(m) != AttributeKeys.WindingRule.NON_ZERO) {
            this.writeAttribute(elem, "fill-rule", "evenodd", "nonzero");
        }
        if ((gradient = SVGAttributeKeys.STROKE_GRADIENT.get(m)) != null) {
            if (this.gradientToIDMap.containsKey(gradient)) {
                id = this.gradientToIDMap.get(gradient);
            } else {
                if (gradient instanceof LinearGradient) {
                    lg = (LinearGradient)gradient;
                    gradientElem = this.createLinearGradient(this.document, lg.getX1(), lg.getY1(), lg.getX2(), lg.getY2(), lg.getStopOffsets(), lg.getStopColors(), lg.getStopOpacities(), lg.isRelativeToFigureBounds(), lg.getTransform());
                } else {
                    rg = (RadialGradient)gradient;
                    gradientElem = this.createRadialGradient(this.document, rg.getCX(), rg.getCY(), rg.getFX(), rg.getFY(), rg.getR(), rg.getStopOffsets(), rg.getStopColors(), rg.getStopOpacities(), rg.isRelativeToFigureBounds(), rg.getTransform());
                }
                id = this.getId(gradientElem);
                gradientElem.setAttribute("id", "xml", id);
                this.defs.addChild(gradientElem);
                this.gradientToIDMap.put(gradient, id);
            }
            this.writeAttribute(elem, "stroke", "url(#" + id + ")", "none");
        } else {
            this.writeAttribute(elem, "stroke", SVGOutputFormat.toColor((Color)SVGAttributeKeys.STROKE_COLOR.get(m)), "none");
        }
        double[] dashes = (double[])SVGAttributeKeys.STROKE_DASHES.get(m);
        if (dashes != null) {
            StringBuilder buf = new StringBuilder();
            for (int i = 0; i < dashes.length; ++i) {
                if (i != 0) {
                    buf.append(',');
                }
                buf.append(SVGOutputFormat.toNumber(dashes[i]));
            }
            this.writeAttribute(elem, "stroke-dasharray", buf.toString(), null);
        }
        this.writeAttribute(elem, "stroke-dashoffset", (Double)SVGAttributeKeys.STROKE_DASH_PHASE.get(m), 0.0);
        this.writeAttribute(elem, "stroke-linecap", strokeLinecapMap.get(SVGAttributeKeys.STROKE_CAP.get(m)), "butt");
        this.writeAttribute(elem, "stroke-linejoin", strokeLinejoinMap.get(SVGAttributeKeys.STROKE_JOIN.get(m)), "miter");
        this.writeAttribute(elem, "stroke-miterlimit", (Double)SVGAttributeKeys.STROKE_MITER_LIMIT.get(m), 4.0);
        this.writeAttribute(elem, "stroke-opacity", SVGAttributeKeys.STROKE_OPACITY.get(m), 1.0);
        this.writeAttribute(elem, "stroke-width", (Double)SVGAttributeKeys.STROKE_WIDTH.get(m), 1.0);
    }

    protected void writeOpacityAttribute(IXMLElement elem, Map<AttributeKey, Object> m) throws IOException {
        this.writeAttribute(elem, "opacity", SVGAttributeKeys.OPACITY.get(m), 1.0);
    }

    protected void writeTransformAttribute(IXMLElement elem, Map<AttributeKey, Object> a) throws IOException {
        AffineTransform t = (AffineTransform)SVGAttributeKeys.TRANSFORM.get(a);
        if (t != null) {
            this.writeAttribute(elem, "transform", SVGOutputFormat.toTransform(t), "none");
        }
    }

    private void writeFontAttributes(IXMLElement elem, Map<AttributeKey, Object> a) throws IOException {
        this.writeAttribute(elem, "font-family", ((Font)SVGAttributeKeys.FONT_FACE.get(a)).getFontName(), "Dialog");
        this.writeAttribute(elem, "font-size", (Double)SVGAttributeKeys.FONT_SIZE.get(a), 0.0);
        this.writeAttribute(elem, "font-style", (Boolean)SVGAttributeKeys.FONT_ITALIC.get(a) != false ? "italic" : "normal", "normal");
        this.writeAttribute(elem, "font-variant", "normal", "normal");
        this.writeAttribute(elem, "font-weight", (Boolean)SVGAttributeKeys.FONT_BOLD.get(a) != false ? "bold" : "normal", "normal");
        this.writeAttribute(elem, "text-decoration", (Boolean)SVGAttributeKeys.FONT_UNDERLINE.get(a) != false ? "underline" : "none", "none");
    }

    private void writeViewportAttributes(IXMLElement elem, Map<AttributeKey, Object> a) throws IOException {
        if (SVGAttributeKeys.VIEWPORT_WIDTH.get(a) != null && SVGAttributeKeys.VIEWPORT_HEIGHT.get(a) != null) {
            this.writeAttribute(elem, "width", SVGOutputFormat.toNumber(SVGAttributeKeys.VIEWPORT_WIDTH.get(a)), null);
            this.writeAttribute(elem, "height", SVGOutputFormat.toNumber(SVGAttributeKeys.VIEWPORT_HEIGHT.get(a)), null);
        }
        this.writeAttribute(elem, "viewport-fill", SVGOutputFormat.toColor(SVGAttributeKeys.VIEWPORT_FILL.get(a)), "none");
        this.writeAttribute(elem, "viewport-fill-opacity", SVGAttributeKeys.VIEWPORT_FILL_OPACITY.get(a), 1.0);
    }

    protected void writeAttribute(IXMLElement elem, String name, String value, @Nullable String defaultValue) {
        this.writeAttribute(elem, name, "http://www.w3.org/2000/svg", value, defaultValue);
    }

    protected void writeAttribute(IXMLElement elem, String name, String namespace, String value, @Nullable String defaultValue) {
        if (!value.equals(defaultValue)) {
            elem.setAttribute(name, value);
        }
    }

    protected void writeAttribute(IXMLElement elem, String name, double value, double defaultValue) {
        this.writeAttribute(elem, name, "http://www.w3.org/2000/svg", value, defaultValue);
    }

    protected void writeAttribute(IXMLElement elem, String name, String namespace, double value, double defaultValue) {
        if (value != defaultValue) {
            elem.setAttribute(name, SVGOutputFormat.toNumber(value));
        }
    }

    public static String toPath(BezierPath[] paths) {
        StringBuilder buf = new StringBuilder();
        for (int j = 0; j < paths.length; ++j) {
            BezierPath.Node current;
            BezierPath path = paths[j];
            if (path.size() == 0) continue;
            if (path.size() == 1) {
                BezierPath.Node current2 = (BezierPath.Node)path.get(0);
                buf.append("M ");
                buf.append(SVGOutputFormat.toNumber(current2.x[0]));
                buf.append(' ');
                buf.append(SVGOutputFormat.toNumber(current2.y[0]));
                buf.append(SVGOutputFormat.toNumber(current2.x[0]));
                buf.append(' ');
                buf.append(SVGOutputFormat.toNumber(current2.y[0] + 1.0));
                continue;
            }
            BezierPath.Node previous = current = (BezierPath.Node)path.get(0);
            buf.append("M ");
            buf.append(SVGOutputFormat.toNumber(current.x[0]));
            buf.append(' ');
            buf.append(SVGOutputFormat.toNumber(current.y[0]));
            int nextCommand = 76;
            int n = path.size();
            for (int i = 1; i < n; ++i) {
                previous = current;
                current = (BezierPath.Node)path.get(i);
                if ((previous.mask & 2) == 0) {
                    if ((current.mask & 1) == 0) {
                        if (nextCommand != 76) {
                            buf.append(" L ");
                            nextCommand = 76;
                        } else {
                            buf.append(' ');
                        }
                        buf.append(SVGOutputFormat.toNumber(current.x[0]));
                        buf.append(' ');
                        buf.append(SVGOutputFormat.toNumber(current.y[0]));
                        continue;
                    }
                    if (nextCommand != 81) {
                        buf.append(" Q ");
                        nextCommand = 81;
                    } else {
                        buf.append(' ');
                    }
                    buf.append(SVGOutputFormat.toNumber(current.x[1]));
                    buf.append(' ');
                    buf.append(SVGOutputFormat.toNumber(current.y[1]));
                    buf.append(' ');
                    buf.append(SVGOutputFormat.toNumber(current.x[0]));
                    buf.append(' ');
                    buf.append(SVGOutputFormat.toNumber(current.y[0]));
                    continue;
                }
                if ((current.mask & 1) == 0) {
                    if (nextCommand != 81) {
                        buf.append(" Q ");
                        nextCommand = 81;
                    } else {
                        buf.append(' ');
                    }
                    buf.append(SVGOutputFormat.toNumber(previous.x[2]));
                    buf.append(' ');
                    buf.append(SVGOutputFormat.toNumber(previous.y[2]));
                    buf.append(' ');
                    buf.append(SVGOutputFormat.toNumber(current.x[0]));
                    buf.append(' ');
                    buf.append(SVGOutputFormat.toNumber(current.y[0]));
                    continue;
                }
                if (nextCommand != 67) {
                    buf.append(" C ");
                    nextCommand = 67;
                } else {
                    buf.append(' ');
                }
                buf.append(SVGOutputFormat.toNumber(previous.x[2]));
                buf.append(' ');
                buf.append(SVGOutputFormat.toNumber(previous.y[2]));
                buf.append(' ');
                buf.append(SVGOutputFormat.toNumber(current.x[1]));
                buf.append(' ');
                buf.append(SVGOutputFormat.toNumber(current.y[1]));
                buf.append(' ');
                buf.append(SVGOutputFormat.toNumber(current.x[0]));
                buf.append(' ');
                buf.append(SVGOutputFormat.toNumber(current.y[0]));
            }
            if (!path.isClosed()) continue;
            if (path.size() > 1) {
                previous = (BezierPath.Node)path.get(path.size() - 1);
                current = (BezierPath.Node)path.get(0);
                if ((previous.mask & 2) == 0) {
                    if ((current.mask & 1) == 0) {
                        if (nextCommand != 76) {
                            buf.append(" L ");
                            nextCommand = 76;
                        } else {
                            buf.append(' ');
                        }
                        buf.append(SVGOutputFormat.toNumber(current.x[0]));
                        buf.append(' ');
                        buf.append(SVGOutputFormat.toNumber(current.y[0]));
                    } else {
                        if (nextCommand != 81) {
                            buf.append(" Q ");
                            nextCommand = 81;
                        } else {
                            buf.append(' ');
                        }
                        buf.append(SVGOutputFormat.toNumber(current.x[1]));
                        buf.append(' ');
                        buf.append(SVGOutputFormat.toNumber(current.y[1]));
                        buf.append(' ');
                        buf.append(SVGOutputFormat.toNumber(current.x[0]));
                        buf.append(' ');
                        buf.append(SVGOutputFormat.toNumber(current.y[0]));
                    }
                } else if ((current.mask & 1) == 0) {
                    if (nextCommand != 81) {
                        buf.append(" Q ");
                        nextCommand = 81;
                    } else {
                        buf.append(' ');
                    }
                    buf.append(SVGOutputFormat.toNumber(previous.x[2]));
                    buf.append(' ');
                    buf.append(SVGOutputFormat.toNumber(previous.y[2]));
                    buf.append(' ');
                    buf.append(SVGOutputFormat.toNumber(current.x[0]));
                    buf.append(' ');
                    buf.append(SVGOutputFormat.toNumber(current.y[0]));
                } else {
                    if (nextCommand != 67) {
                        buf.append(" C ");
                        nextCommand = 67;
                    } else {
                        buf.append(' ');
                    }
                    buf.append(SVGOutputFormat.toNumber(previous.x[2]));
                    buf.append(' ');
                    buf.append(SVGOutputFormat.toNumber(previous.y[2]));
                    buf.append(' ');
                    buf.append(SVGOutputFormat.toNumber(current.x[1]));
                    buf.append(' ');
                    buf.append(SVGOutputFormat.toNumber(current.y[1]));
                    buf.append(' ');
                    buf.append(SVGOutputFormat.toNumber(current.x[0]));
                    buf.append(' ');
                    buf.append(SVGOutputFormat.toNumber(current.y[0]));
                }
            }
            buf.append(" Z");
            nextCommand = 0;
        }
        return buf.toString();
    }

    public static String toNumber(double number) {
        String str = Float.toString((float)number);
        if (str.endsWith(".0")) {
            str = str.substring(0, str.length() - 2);
        }
        return str;
    }

    public static String toPoints(Point2D.Double[] points) throws IOException {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < points.length; ++i) {
            if (i != 0) {
                buf.append(", ");
            }
            buf.append(SVGOutputFormat.toNumber(points[i].x));
            buf.append(',');
            buf.append(SVGOutputFormat.toNumber(points[i].y));
        }
        return buf.toString();
    }

    public static String toTransform(AffineTransform t) throws IOException {
        StringBuilder buf = new StringBuilder();
        switch (t.getType()) {
            case 0: {
                buf.append("none");
                break;
            }
            case 1: {
                buf.append("translate(");
                buf.append(SVGOutputFormat.toNumber(t.getTranslateX()));
                if (t.getTranslateY() != 0.0) {
                    buf.append(' ');
                    buf.append(SVGOutputFormat.toNumber(t.getTranslateY()));
                }
                buf.append(')');
                break;
            }
            case 2: {
                buf.append("scale(");
                buf.append(SVGOutputFormat.toNumber(t.getScaleX()));
                buf.append(')');
                break;
            }
            case 4: 
            case 6: {
                buf.append("scale(");
                buf.append(SVGOutputFormat.toNumber(t.getScaleX()));
                buf.append(' ');
                buf.append(SVGOutputFormat.toNumber(t.getScaleY()));
                buf.append(')');
                break;
            }
            default: {
                buf.append("matrix(");
                double[] matrix = new double[6];
                t.getMatrix(matrix);
                for (int i = 0; i < matrix.length; ++i) {
                    if (i != 0) {
                        buf.append(' ');
                    }
                    buf.append(SVGOutputFormat.toNumber(matrix[i]));
                }
                buf.append(')');
            }
        }
        return buf.toString();
    }

    public static String toColor(Color color) {
        if (color == null) {
            return "none";
        }
        String value = "000000" + Integer.toHexString(color.getRGB());
        value = "#" + value.substring(value.length() - 6);
        if (value.charAt(1) == value.charAt(2) && value.charAt(3) == value.charAt(4) && value.charAt(5) == value.charAt(6)) {
            value = "#" + value.charAt(1) + value.charAt(3) + value.charAt(5);
        }
        return value;
    }

    @Override
    public String getFileExtension() {
        return "svg";
    }

    @Override
    public void write(URI uri, Drawing drawing) throws IOException {
        this.write(new File(uri), drawing);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(File file, Drawing drawing) throws IOException {
        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));){
            this.write(out, drawing);
        }
    }

    @Override
    public void write(OutputStream out, Drawing drawing) throws IOException {
        this.write(out, drawing, drawing.getChildren());
    }

    public void write(OutputStream out, Drawing drawing, List<Figure> figures) throws IOException {
        this.document = new XMLElement("svg", "http://www.w3.org/2000/svg");
        this.document.setAttribute("xmlns:xlink", "http://www.w3.org/1999/xlink");
        this.document.setAttribute("version", "1.2");
        this.document.setAttribute("baseProfile", "tiny");
        this.writeViewportAttributes(this.document, drawing.getAttributes());
        this.initStorageContext(this.document);
        this.defs = new XMLElement("defs");
        this.document.addChild(this.defs);
        for (Figure f : figures) {
            this.writeElement(this.document, f);
        }
        PrintWriter writer = new PrintWriter(new OutputStreamWriter(out, "UTF-8"));
        writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        XMLWriter xmlWriter = new XMLWriter(writer);
        xmlWriter.write(this.document, this.isPrettyPrint);
        writer.flush();
        this.document.dispose();
    }

    private void initStorageContext(IXMLElement root) {
        this.identifiedElements = new HashMap();
        this.gradientToIDMap = new HashMap();
    }

    public String getId(IXMLElement element) {
        if (this.identifiedElements.containsKey(element)) {
            return this.identifiedElements.get(element);
        }
        String id = Integer.toString(this.nextId++, 36);
        this.identifiedElements.put(element, id);
        return id;
    }

    @Override
    public Transferable createTransferable(Drawing drawing, List<Figure> figures, double scaleFactor) throws IOException {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        this.write(buf, drawing, figures);
        return new InputStreamTransferable(new DataFlavor("image/svg+xml", "Image SVG"), buf.toByteArray());
    }

    static {
        strokeLinejoinMap.put(0, "miter");
        strokeLinejoinMap.put(1, "round");
        strokeLinejoinMap.put(2, "bevel");
        strokeLinecapMap = new HashMap();
        strokeLinecapMap.put(0, "butt");
        strokeLinecapMap.put(1, "round");
        strokeLinecapMap.put(2, "square");
    }
}

