/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.svg;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.CompositeFigure;
import org.jhotdraw.draw.DefaultDrawing;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.ImageHolderFigure;
import org.jhotdraw.draw.tool.CreationTool;
import org.jhotdraw.gui.Worker;
import org.jhotdraw.samples.svg.io.SVGInputFormat;
import org.jhotdraw.samples.svg.io.SVGZInputFormat;

public class SVGCreateFromFileTool
extends CreationTool {
    @Nullable
    protected FileDialog fileDialog;
    @Nullable
    protected JFileChooser fileChooser;
    protected Thread workerThread;
    protected CompositeFigure groupPrototype;
    protected ImageHolderFigure imagePrototype;
    protected boolean useFileDialog;

    public SVGCreateFromFileTool(ImageHolderFigure imagePrototype, CompositeFigure groupPrototype) {
        super(imagePrototype);
        this.groupPrototype = groupPrototype;
        this.imagePrototype = imagePrototype;
    }

    public SVGCreateFromFileTool(ImageHolderFigure imagePrototype, CompositeFigure groupPrototype, Map<AttributeKey, Object> attributes) {
        super(imagePrototype, attributes);
        this.groupPrototype = groupPrototype;
        this.imagePrototype = imagePrototype;
    }

    public void setUseFileDialog(boolean newValue) {
        this.useFileDialog = newValue;
        if (this.useFileDialog) {
            this.fileChooser = null;
        } else {
            this.fileDialog = null;
        }
    }

    public boolean isUseFileDialog() {
        return this.useFileDialog;
    }

    @Override
    public void activate(DrawingEditor editor) {
        File file;
        super.activate(editor);
        if (this.workerThread != null) {
            try {
                this.workerThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.useFileDialog) {
            this.getFileDialog().setVisible(true);
            file = this.getFileDialog().getFile() != null ? new File(this.getFileDialog().getDirectory(), this.getFileDialog().getFile()) : null;
        } else {
            file = this.getFileChooser().showOpenDialog(this.getView().getComponent()) == 0 ? this.getFileChooser().getSelectedFile() : null;
        }
        if (file != null) {
            Worker<Drawing> worker;
            if (file.getName().toLowerCase().endsWith(".svg") || file.getName().toLowerCase().endsWith(".svgz")) {
                this.prototype = this.groupPrototype.clone();
                worker = new Worker<Drawing>(){

                    @Override
                    public Drawing construct() throws IOException {
                        DefaultDrawing drawing = new DefaultDrawing();
                        SVGInputFormat in = file.getName().toLowerCase().endsWith(".svg") ? new SVGInputFormat() : new SVGZInputFormat();
                        in.read(file.toURI(), (Drawing)drawing);
                        return drawing;
                    }

                    @Override
                    protected void done(Drawing drawing) {
                        if (SVGCreateFromFileTool.this.createdFigure == null) {
                            CompositeFigure parent = (CompositeFigure)SVGCreateFromFileTool.this.prototype;
                            for (Figure f : drawing.getChildren()) {
                                parent.basicAdd(f);
                            }
                        } else {
                            CompositeFigure parent = (CompositeFigure)SVGCreateFromFileTool.this.createdFigure;
                            parent.willChange();
                            for (Figure f : drawing.getChildren()) {
                                parent.add(f);
                            }
                            parent.changed();
                        }
                    }

                    @Override
                    protected void failed(Throwable t) {
                        JOptionPane.showMessageDialog(SVGCreateFromFileTool.this.getView().getComponent(), t.getMessage(), null, 0);
                        SVGCreateFromFileTool.this.getDrawing().remove(SVGCreateFromFileTool.this.createdFigure);
                        SVGCreateFromFileTool.this.fireToolDone();
                    }

                    @Override
                    protected void finished() {
                    }
                };
            } else {
                this.prototype = this.imagePrototype;
                final ImageHolderFigure loaderFigure = (ImageHolderFigure)this.prototype.clone();
                worker = new Worker(){

                    protected Object construct() throws IOException {
                        loaderFigure.loadImage(file);
                        return null;
                    }

                    protected void done(Object value) {
                        try {
                            if (SVGCreateFromFileTool.this.createdFigure == null) {
                                ((ImageHolderFigure)SVGCreateFromFileTool.this.prototype).setImage(loaderFigure.getImageData(), loaderFigure.getBufferedImage());
                            } else {
                                ((ImageHolderFigure)SVGCreateFromFileTool.this.createdFigure).setImage(loaderFigure.getImageData(), loaderFigure.getBufferedImage());
                            }
                        }
                        catch (IOException ex) {
                            JOptionPane.showMessageDialog(SVGCreateFromFileTool.this.getView().getComponent(), ex.getMessage(), null, 0);
                        }
                    }

                    @Override
                    protected void failed(Throwable t) {
                        JOptionPane.showMessageDialog(SVGCreateFromFileTool.this.getView().getComponent(), t.getMessage(), null, 0);
                        SVGCreateFromFileTool.this.getDrawing().remove(SVGCreateFromFileTool.this.createdFigure);
                        SVGCreateFromFileTool.this.fireToolDone();
                    }
                };
            }
            this.workerThread = new Thread(worker);
            this.workerThread.start();
        } else if (this.isToolDoneAfterCreation()) {
            this.fireToolDone();
        }
    }

    @Override
    protected Figure createFigure() {
        if (this.prototype instanceof CompositeFigure) {
            return this.prototype.clone();
        }
        return super.createFigure();
    }

    private JFileChooser getFileChooser() {
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser();
        }
        return this.fileChooser;
    }

    private FileDialog getFileDialog() {
        if (this.fileDialog == null) {
            this.fileDialog = new FileDialog(new Frame());
        }
        return this.fileDialog;
    }
}

