/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.app.action.file;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.jhotdraw.app.Application;
import org.jhotdraw.app.View;
import org.jhotdraw.app.action.AbstractSaveUnsavedChangesAction;
import org.jhotdraw.gui.JSheet;
import org.jhotdraw.gui.Worker;
import org.jhotdraw.gui.event.SheetEvent;
import org.jhotdraw.gui.event.SheetListener;
import org.jhotdraw.net.URIUtil;
import org.jhotdraw.util.ResourceBundleUtil;

public class LoadRecentFileAction
extends AbstractSaveUnsavedChangesAction {
    public static final String ID = "file.loadRecent";
    private URI uri;

    public LoadRecentFileAction(Application app, @Nullable View view, URI uri) {
        super(app, view);
        this.uri = uri;
        this.putValue("Name", URIUtil.getName(uri));
    }

    @Override
    public boolean isEnabled() {
        return this.getApplication().isEnabled() && (this.getActiveView() == null || this.getActiveView().isEnabled()) && this.enabled;
    }

    @Override
    public void doIt(View v) {
        Application app = this.getApplication();
        if (v == null) {
            View emptyView = app.getActiveView();
            if (emptyView == null || emptyView.getURI() != null || emptyView.hasUnsavedChanges()) {
                emptyView = null;
            }
            if (emptyView == null) {
                v = app.createView();
                app.add(v);
                app.show(v);
            } else {
                v = emptyView;
            }
        }
        final View view = v;
        app.setEnabled(true);
        int multipleOpenId = 1;
        for (View aView : app.views()) {
            if (aView == view || aView.getURI() == null || !aView.getURI().equals(this.uri)) continue;
            multipleOpenId = Math.max(multipleOpenId, aView.getMultipleOpenId() + 1);
        }
        view.setMultipleOpenId(multipleOpenId);
        view.execute(new Worker(){

            protected Object construct() throws IOException {
                boolean exists = true;
                try {
                    File f = new File(LoadRecentFileAction.this.uri);
                    exists = f.exists();
                }
                catch (IllegalArgumentException f) {
                    // empty catch block
                }
                if (exists) {
                    view.read(LoadRecentFileAction.this.uri, null);
                    return null;
                }
                ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.app.Labels");
                throw new IOException(labels.getFormatted("file.load.fileDoesNotExist.message", URIUtil.getName(LoadRecentFileAction.this.uri)));
            }

            protected void done(Object value) {
                Application app = LoadRecentFileAction.this.getApplication();
                view.setURI(LoadRecentFileAction.this.uri);
                view.setEnabled(true);
                Frame w = (Frame)SwingUtilities.getWindowAncestor(view.getComponent());
                if (w != null) {
                    w.setExtendedState(w.getExtendedState() & 0xFFFFFFFE);
                    w.toFront();
                }
                view.getComponent().requestFocus();
                if (app != null) {
                    app.setEnabled(true);
                }
            }

            @Override
            protected void failed(Throwable error) {
                error.printStackTrace();
                ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.app.Labels");
                JSheet.showMessageSheet(view.getComponent(), "<html>" + UIManager.getString("OptionPane.css") + "<b>" + labels.getFormatted("file.load.couldntLoad.message", URIUtil.getName(LoadRecentFileAction.this.uri)) + "</b><p>" + error, 0, new SheetListener(){

                    @Override
                    public void optionSelected(SheetEvent evt) {
                    }
                });
            }
        });
    }
}

