/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.table;

import java.io.File;
import java.io.IOException;
import org.tmatesoft.sqljet.core.SqlJetErrorCode;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.SqlJetTransactionMode;
import org.tmatesoft.sqljet.core.internal.ISqlJetFileSystem;
import org.tmatesoft.sqljet.core.internal.table.SqlJetPragmasHandler;
import org.tmatesoft.sqljet.core.internal.table.SqlJetTable;
import org.tmatesoft.sqljet.core.schema.ISqlJetIndexDef;
import org.tmatesoft.sqljet.core.schema.ISqlJetSchema;
import org.tmatesoft.sqljet.core.schema.ISqlJetTableDef;
import org.tmatesoft.sqljet.core.schema.ISqlJetTriggerDef;
import org.tmatesoft.sqljet.core.schema.ISqlJetViewDef;
import org.tmatesoft.sqljet.core.schema.ISqlJetVirtualTableDef;
import org.tmatesoft.sqljet.core.table.ISqlJetRunnableWithLock;
import org.tmatesoft.sqljet.core.table.ISqlJetTable;
import org.tmatesoft.sqljet.core.table.ISqlJetTransaction;
import org.tmatesoft.sqljet.core.table.engine.ISqlJetEngineSynchronized;
import org.tmatesoft.sqljet.core.table.engine.ISqlJetEngineTransaction;
import org.tmatesoft.sqljet.core.table.engine.SqlJetEngine;

public class SqlJetDb
extends SqlJetEngine {
    public static final File IN_MEMORY = new File(":memory:");
    private SqlJetDb temporaryDb;

    public SqlJetDb(File file, boolean writable) {
        super(file, writable);
    }

    public SqlJetDb(File file, boolean writable, ISqlJetFileSystem fs) {
        super(file, writable, fs);
    }

    public SqlJetDb(File file, boolean writable, String fsName) throws SqlJetException {
        super(file, writable, fsName);
    }

    public static SqlJetDb open(File file, boolean write) throws SqlJetException {
        SqlJetDb db = new SqlJetDb(file, write);
        db.open();
        return db;
    }

    public static SqlJetDb open(File file, boolean write, ISqlJetFileSystem fs) throws SqlJetException {
        SqlJetDb db = new SqlJetDb(file, write, fs);
        db.open();
        return db;
    }

    public static SqlJetDb open(File file, boolean write, String fsName) throws SqlJetException {
        SqlJetDb db = new SqlJetDb(file, write, fsName);
        db.open();
        return db;
    }

    public Object runWithLock(final ISqlJetRunnableWithLock op) throws SqlJetException {
        return this.runSynchronized(new ISqlJetEngineSynchronized(){

            @Override
            public Object runSynchronized(SqlJetEngine db) throws SqlJetException {
                return op.runWithLock(SqlJetDb.this);
            }
        });
    }

    public ISqlJetSchema getSchema() throws SqlJetException {
        return this.getSchemaInternal();
    }

    public ISqlJetTable getTable(final String tableName) throws SqlJetException {
        this.checkOpen();
        this.refreshSchema();
        return (SqlJetTable)this.runWithLock(new ISqlJetRunnableWithLock(){

            @Override
            public Object runWithLock(SqlJetDb db) throws SqlJetException {
                return new SqlJetTable(db, SqlJetDb.this.btree, tableName, SqlJetDb.this.writable);
            }
        });
    }

    public Object runWriteTransaction(ISqlJetTransaction op) throws SqlJetException {
        this.checkOpen();
        if (this.writable) {
            return this.runTransaction(op, SqlJetTransactionMode.WRITE);
        }
        throw new SqlJetException(SqlJetErrorCode.MISUSE, "Can't start write transaction on read-only database");
    }

    public Object runReadTransaction(ISqlJetTransaction op) throws SqlJetException {
        this.checkOpen();
        return this.runTransaction(op, SqlJetTransactionMode.READ_ONLY);
    }

    public Object runTransaction(final ISqlJetTransaction op, SqlJetTransactionMode mode) throws SqlJetException {
        return this.runEngineTransaction(new ISqlJetEngineTransaction(){

            @Override
            public Object run(SqlJetEngine engine) throws SqlJetException {
                return op.run(SqlJetDb.this);
            }
        }, mode);
    }

    public Object pragma(final String sql) throws SqlJetException {
        this.checkOpen();
        this.refreshSchema();
        return this.runWithLock(new ISqlJetRunnableWithLock(){

            @Override
            public Object runWithLock(SqlJetDb db) throws SqlJetException {
                return new SqlJetPragmasHandler(SqlJetDb.this.getOptions()).pragma(sql);
            }
        });
    }

    public ISqlJetTableDef createTable(final String sql) throws SqlJetException {
        this.checkOpen();
        return (ISqlJetTableDef)this.runWriteTransaction(new ISqlJetTransaction(){

            @Override
            public Object run(SqlJetDb db) throws SqlJetException {
                return SqlJetDb.this.getSchemaInternal().createTable(sql);
            }
        });
    }

    public ISqlJetIndexDef createIndex(final String sql) throws SqlJetException {
        this.checkOpen();
        return (ISqlJetIndexDef)this.runWriteTransaction(new ISqlJetTransaction(){

            @Override
            public Object run(SqlJetDb db) throws SqlJetException {
                return SqlJetDb.this.getSchemaInternal().createIndex(sql);
            }
        });
    }

    public void dropTable(final String tableName) throws SqlJetException {
        this.checkOpen();
        this.runWriteTransaction(new ISqlJetTransaction(){

            @Override
            public Object run(SqlJetDb db) throws SqlJetException {
                SqlJetDb.this.getSchemaInternal().dropTable(tableName);
                return null;
            }
        });
    }

    public void dropIndex(final String indexName) throws SqlJetException {
        this.checkOpen();
        this.runWriteTransaction(new ISqlJetTransaction(){

            @Override
            public Object run(SqlJetDb db) throws SqlJetException {
                SqlJetDb.this.getSchemaInternal().dropIndex(indexName);
                return null;
            }
        });
    }

    public void dropView(final String viewName) throws SqlJetException {
        this.checkOpen();
        this.runWriteTransaction(new ISqlJetTransaction(){

            @Override
            public Object run(SqlJetDb db) throws SqlJetException {
                SqlJetDb.this.getSchemaInternal().dropView(viewName);
                return null;
            }
        });
    }

    public void dropTrigger(final String triggerName) throws SqlJetException {
        this.checkOpen();
        this.runWriteTransaction(new ISqlJetTransaction(){

            @Override
            public Object run(SqlJetDb db) throws SqlJetException {
                SqlJetDb.this.getSchemaInternal().dropTrigger(triggerName);
                return null;
            }
        });
    }

    public ISqlJetTableDef alterTable(final String sql) throws SqlJetException {
        this.checkOpen();
        return (ISqlJetTableDef)this.runWriteTransaction(new ISqlJetTransaction(){

            @Override
            public Object run(SqlJetDb db) throws SqlJetException {
                return SqlJetDb.this.getSchemaInternal().alterTable(sql);
            }
        });
    }

    public ISqlJetVirtualTableDef createVirtualTable(final String sql) throws SqlJetException {
        this.checkOpen();
        return (ISqlJetVirtualTableDef)this.runWriteTransaction(new ISqlJetTransaction(){

            @Override
            public Object run(SqlJetDb db) throws SqlJetException {
                return SqlJetDb.this.getSchemaInternal().createVirtualTable(sql, 0);
            }
        });
    }

    public ISqlJetViewDef createView(final String sql) throws SqlJetException {
        this.checkOpen();
        return (ISqlJetViewDef)this.runWriteTransaction(new ISqlJetTransaction(){

            @Override
            public Object run(SqlJetDb db) throws SqlJetException {
                return SqlJetDb.this.getSchemaInternal().createView(sql);
            }
        });
    }

    public ISqlJetTriggerDef createTrigger(final String sql) throws SqlJetException {
        this.checkOpen();
        return (ISqlJetTriggerDef)this.runWriteTransaction(new ISqlJetTransaction(){

            @Override
            public Object run(SqlJetDb db) throws SqlJetException {
                return SqlJetDb.this.getSchemaInternal().createTrigger(sql);
            }
        });
    }

    public SqlJetDb getTemporaryDatabase() throws SqlJetException {
        return this.getTemporaryDatabase(false);
    }

    public SqlJetDb getTemporaryDatabase(final boolean inMemory) throws SqlJetException {
        this.checkOpen();
        return (SqlJetDb)this.runWithLock(new ISqlJetRunnableWithLock(){

            @Override
            public Object runWithLock(SqlJetDb db) throws SqlJetException {
                if (SqlJetDb.this.temporaryDb == null || !SqlJetDb.this.temporaryDb.isOpen()) {
                    SqlJetDb.this.closeTemporaryDatabase();
                    File tmpDbFile = SqlJetDb.this.getTemporaryDatabaseFile(inMemory);
                    if (tmpDbFile != null) {
                        SqlJetDb.this.temporaryDb = SqlJetDb.open(tmpDbFile, true);
                    }
                }
                return SqlJetDb.this.temporaryDb;
            }
        });
    }

    @Override
    protected void closeResources() throws SqlJetException {
        this.closeTemporaryDatabase();
    }

    private void closeTemporaryDatabase() throws SqlJetException {
        if (this.temporaryDb != null) {
            this.temporaryDb.close();
            File tmpDbFile = this.temporaryDb.getFile();
            if (tmpDbFile != null && !IN_MEMORY.equals(tmpDbFile)) {
                this.getFileSystem().delete(tmpDbFile, false);
            }
        }
        this.temporaryDb = null;
    }

    private File getTemporaryDatabaseFile(boolean inMemory) throws SqlJetException {
        if (inMemory) {
            return IN_MEMORY;
        }
        File tmpDbFile = null;
        try {
            tmpDbFile = this.getFileSystem().getTempFile();
        }
        catch (IOException e) {
            throw new SqlJetException(SqlJetErrorCode.CANTOPEN, (Throwable)e);
        }
        if (tmpDbFile == null) {
            throw new SqlJetException(SqlJetErrorCode.CANTOPEN);
        }
        return tmpDbFile;
    }
}

