/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.fs;

import java.util.Set;
import org.tmatesoft.sqljet.core.internal.ISqlJetFile;
import org.tmatesoft.sqljet.core.internal.ISqlJetMemoryPointer;
import org.tmatesoft.sqljet.core.internal.SqlJetDeviceCharacteristics;
import org.tmatesoft.sqljet.core.internal.SqlJetFileOpenPermission;
import org.tmatesoft.sqljet.core.internal.SqlJetFileType;
import org.tmatesoft.sqljet.core.internal.SqlJetLockType;
import org.tmatesoft.sqljet.core.internal.SqlJetSyncFlags;
import org.tmatesoft.sqljet.core.internal.SqlJetUtility;

public class SqlJetMemJournal
implements ISqlJetFile {
    private static final int JOURNAL_CHUNKSIZE = 1024;
    FileChunk pFirst;
    FilePoint endpoint = new FilePoint();
    FilePoint readpoint = new FilePoint();
    private static final Set<SqlJetDeviceCharacteristics> empty = SqlJetUtility.noneOf(SqlJetDeviceCharacteristics.class);

    @Override
    public boolean isMemJournal() {
        return true;
    }

    private static int MIN(int x, int y) {
        return x < y ? x : y;
    }

    @Override
    public int read(ISqlJetMemoryPointer buffer, int amount, long offset) {
        int iSpace;
        FileChunk pChunk;
        SqlJetMemJournal p = this;
        int iAmt = amount;
        long iOfst = offset;
        int zOut = 0;
        int nRead = iAmt;
        assert (iOfst + (long)iAmt <= p.endpoint.iOffset);
        if (p.readpoint.iOffset != iOfst || iOfst == 0L) {
            long iOff = 0L;
            pChunk = p.pFirst;
            while (pChunk != null && iOff + 1024L <= iOfst) {
                iOff += 1024L;
                pChunk = pChunk.pNext;
            }
        } else {
            pChunk = p.readpoint.pChunk;
        }
        int iChunkOffset = (int)(iOfst % 1024L);
        do {
            iSpace = 1024 - iChunkOffset;
            int nCopy = SqlJetMemJournal.MIN(nRead, 1024 - iChunkOffset);
            SqlJetUtility.memcpy(buffer, zOut, pChunk.zChunk, iChunkOffset, nCopy);
            zOut += nCopy;
            iChunkOffset = 0;
        } while ((nRead -= iSpace) >= 0 && (pChunk = pChunk.pNext) != null && nRead > 0);
        p.readpoint.iOffset = iOfst + (long)iAmt;
        p.readpoint.pChunk = pChunk;
        return iAmt - nRead;
    }

    @Override
    public void write(ISqlJetMemoryPointer buffer, int amount, long offset) {
        SqlJetMemJournal p = this;
        int iAmt = amount;
        long iOfst = offset;
        int nWrite = iAmt;
        int zWrite = 0;
        assert (iOfst == p.endpoint.iOffset);
        while (nWrite > 0) {
            FileChunk pChunk = p.endpoint.pChunk;
            int iChunkOffset = (int)(p.endpoint.iOffset % 1024L);
            int iSpace = SqlJetMemJournal.MIN(nWrite, 1024 - iChunkOffset);
            if (iChunkOffset == 0) {
                FileChunk pNew = new FileChunk();
                pNew.pNext = null;
                if (pChunk != null) {
                    assert (p.pFirst != null);
                    pChunk.pNext = pNew;
                } else {
                    assert (p.pFirst == null);
                    p.pFirst = pNew;
                }
                p.endpoint.pChunk = pNew;
            }
            SqlJetUtility.memcpy(p.endpoint.pChunk.zChunk, iChunkOffset, buffer, zWrite, iSpace);
            zWrite += iSpace;
            nWrite -= iSpace;
            p.endpoint.iOffset += (long)iSpace;
        }
    }

    @Override
    public void truncate(long size) {
        SqlJetMemJournal p = this;
        assert (size == 0L);
        FileChunk pChunk = p.pFirst;
        while (pChunk != null) {
            pChunk = pChunk.pNext;
        }
    }

    @Override
    public void close() {
        this.truncate(0L);
    }

    @Override
    public void sync(Set<SqlJetSyncFlags> syncFlags) {
    }

    @Override
    public long fileSize() {
        SqlJetMemJournal p = this;
        return p.endpoint.iOffset;
    }

    @Override
    public boolean checkReservedLock() {
        return false;
    }

    @Override
    public Set<SqlJetDeviceCharacteristics> deviceCharacteristics() {
        return empty;
    }

    @Override
    public SqlJetFileType getFileType() {
        return null;
    }

    @Override
    public SqlJetLockType getLockType() {
        return null;
    }

    @Override
    public Set<SqlJetFileOpenPermission> getPermissions() {
        return null;
    }

    @Override
    public boolean lock(SqlJetLockType lockType) {
        return false;
    }

    @Override
    public int sectorSize() {
        return 0;
    }

    @Override
    public boolean unlock(SqlJetLockType lockType) {
        return false;
    }

    private static class FilePoint {
        long iOffset;
        FileChunk pChunk;

        private FilePoint() {
        }
    }

    private static class FileChunk {
        FileChunk pNext;
        ISqlJetMemoryPointer zChunk = SqlJetUtility.allocatePtr(1024);

        private FileChunk() {
        }
    }
}

