/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.db;

import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.tmatesoft.sqljet.core.ISqlJetMutex;
import org.tmatesoft.sqljet.core.internal.ISqlJetBackend;
import org.tmatesoft.sqljet.core.internal.ISqlJetConfig;
import org.tmatesoft.sqljet.core.internal.ISqlJetDbHandle;
import org.tmatesoft.sqljet.core.internal.ISqlJetFileSystem;
import org.tmatesoft.sqljet.core.internal.SqlJetDbFlags;
import org.tmatesoft.sqljet.core.internal.SqlJetUtility;
import org.tmatesoft.sqljet.core.internal.db.SqlJetConfig;
import org.tmatesoft.sqljet.core.internal.fs.SqlJetFileSystemsManager;
import org.tmatesoft.sqljet.core.internal.mutex.SqlJetEmptyMutex;
import org.tmatesoft.sqljet.core.internal.mutex.SqlJetMutex;
import org.tmatesoft.sqljet.core.table.ISqlJetBusyHandler;
import org.tmatesoft.sqljet.core.table.ISqlJetOptions;

public class SqlJetDbHandle
implements ISqlJetDbHandle {
    private Set<SqlJetDbFlags> flags = SqlJetUtility.noneOf(SqlJetDbFlags.class);
    private ISqlJetConfig config = new SqlJetConfig();
    private ISqlJetFileSystem fileSystem = SqlJetFileSystemsManager.getManager().find(null);
    private ISqlJetMutex mutex = new SqlJetEmptyMutex();
    private List<ISqlJetBackend> backends = new LinkedList<ISqlJetBackend>();
    private ISqlJetOptions options;
    private ISqlJetBusyHandler busyHandler;

    public SqlJetDbHandle() {
        if (this.config.isSynchronizedThreading()) {
            this.mutex = new SqlJetMutex();
        }
    }

    public SqlJetDbHandle(ISqlJetFileSystem fs) {
        this();
        this.fileSystem = fs;
    }

    @Override
    public List<ISqlJetBackend> getBackends() {
        return this.backends;
    }

    @Override
    public ISqlJetBusyHandler getBusyHandler() {
        return this.busyHandler;
    }

    @Override
    public void setBusyHandler(ISqlJetBusyHandler busyHandler) {
        this.busyHandler = busyHandler;
    }

    @Override
    public ISqlJetConfig getConfig() {
        return this.config;
    }

    @Override
    public ISqlJetFileSystem getFileSystem() {
        return this.fileSystem;
    }

    @Override
    public Set<SqlJetDbFlags> getFlags() {
        return this.flags;
    }

    @Override
    public ISqlJetMutex getMutex() {
        return this.mutex;
    }

    @Override
    public int getSavepointNum() {
        return 0;
    }

    @Override
    public void setConfig(ISqlJetConfig config) {
    }

    @Override
    public ISqlJetOptions getOptions() {
        return this.options;
    }

    @Override
    public void setOptions(ISqlJetOptions options) {
        this.options = options;
    }
}

