/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.browser.core.schema;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.tmatesoft.sqljet.browser.core.schema.SchemaTreeNode;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.schema.ISqlJetColumnDef;
import org.tmatesoft.sqljet.core.schema.ISqlJetIndexDef;
import org.tmatesoft.sqljet.core.schema.ISqlJetSchema;
import org.tmatesoft.sqljet.core.schema.ISqlJetTableDef;

public class SchemaTreeModel
implements TreeModel {
    private Object myRoot;
    private Collection<TreeModelListener> myListeners = new HashSet<TreeModelListener>();

    public static SchemaTreeModel createInstance(ISqlJetSchema schema) throws SqlJetException {
        SchemaTreeNode root = new SchemaTreeNode();
        if (schema == null) {
            return new SchemaTreeModel(root);
        }
        try {
            Set<String> tableNames = schema.getTableNames();
            for (String tableName : tableNames) {
                ISqlJetTableDef table = schema.getTable(tableName);
                SchemaTreeNode node = new SchemaTreeNode(table);
                List<ISqlJetColumnDef> columns = table.getColumns();
                for (ISqlJetColumnDef column : columns) {
                    node.addChild(new SchemaTreeNode(table, column));
                }
                root.addChild(node);
            }
            Set<String> indexNames = schema.getIndexNames();
            for (String indexName : indexNames) {
                ISqlJetIndexDef index = schema.getIndex(indexName);
                root.addChild(new SchemaTreeNode(index));
            }
        }
        catch (SqlJetException e) {
            root = new SchemaTreeNode();
            throw e;
        }
        return new SchemaTreeModel(root);
    }

    private SchemaTreeModel(SchemaTreeNode root) {
        this.myRoot = root;
    }

    @Override
    public int getChildCount(Object parent) {
        return ((SchemaTreeNode)parent).getChildCount();
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        return ((SchemaTreeNode)parent).getIndexOfChild((SchemaTreeNode)child);
    }

    @Override
    public Object getChild(Object parent, int index) {
        return ((SchemaTreeNode)parent).getChildAt(index);
    }

    @Override
    public Object getRoot() {
        return this.myRoot;
    }

    @Override
    public boolean isLeaf(Object node) {
        return ((SchemaTreeNode)node).isLeaf();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTreeModelListener(TreeModelListener l) {
        Collection<TreeModelListener> collection = this.myListeners;
        synchronized (collection) {
            this.myListeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        Collection<TreeModelListener> collection = this.myListeners;
        synchronized (collection) {
            this.myListeners.remove(l);
        }
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
    }
}

