/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.map;

import cern.colt.function.DoubleIntProcedure;
import cern.colt.function.DoubleProcedure;
import cern.colt.list.ByteArrayList;
import cern.colt.list.DoubleArrayList;
import cern.colt.list.IntArrayList;
import cern.colt.map.AbstractDoubleIntMap;
import cern.colt.map.HashFunctions;

public class OpenDoubleIntHashMap
extends AbstractDoubleIntMap {
    protected double[] table;
    protected int[] values;
    protected byte[] state;
    protected int freeEntries;
    protected static final byte FREE = 0;
    protected static final byte FULL = 1;
    protected static final byte REMOVED = 2;

    public OpenDoubleIntHashMap() {
        this(277);
    }

    public OpenDoubleIntHashMap(int n) {
        this(n, 0.2, 0.5);
    }

    public OpenDoubleIntHashMap(int n, double d, double d2) {
        this.setUp(n, d, d2);
    }

    @Override
    public void clear() {
        new ByteArrayList(this.state).fillFromToWith(0, this.state.length - 1, (byte)0);
        this.distinct = 0;
        this.freeEntries = this.table.length;
        this.trimToSize();
    }

    @Override
    public Object clone() {
        OpenDoubleIntHashMap openDoubleIntHashMap = (OpenDoubleIntHashMap)super.clone();
        openDoubleIntHashMap.table = (double[])openDoubleIntHashMap.table.clone();
        openDoubleIntHashMap.values = (int[])openDoubleIntHashMap.values.clone();
        openDoubleIntHashMap.state = (byte[])openDoubleIntHashMap.state.clone();
        return openDoubleIntHashMap;
    }

    @Override
    public boolean containsKey(double d) {
        return this.indexOfKey(d) >= 0;
    }

    @Override
    public boolean containsValue(int n) {
        return this.indexOfValue(n) >= 0;
    }

    @Override
    public void ensureCapacity(int n) {
        if (this.table.length < n) {
            int n2 = this.nextPrime(n);
            this.rehash(n2);
        }
    }

    @Override
    public boolean forEachKey(DoubleProcedure doubleProcedure) {
        int n = this.table.length;
        while (n-- > 0) {
            if (this.state[n] != 1 || doubleProcedure.apply(this.table[n])) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean forEachPair(DoubleIntProcedure doubleIntProcedure) {
        int n = this.table.length;
        while (n-- > 0) {
            if (this.state[n] != 1 || doubleIntProcedure.apply(this.table[n], this.values[n])) continue;
            return false;
        }
        return true;
    }

    @Override
    public int get(double d) {
        int n = this.indexOfKey(d);
        if (n < 0) {
            return 0;
        }
        return this.values[n];
    }

    protected int indexOfInsertion(double d) {
        double[] dArray = this.table;
        byte[] byArray = this.state;
        int n = dArray.length;
        int n2 = HashFunctions.hash(d) & Integer.MAX_VALUE;
        int n3 = n2 % n;
        int n4 = n2 % (n - 2);
        if (n4 == 0) {
            n4 = 1;
        }
        while (byArray[n3] == 1 && dArray[n3] != d) {
            if ((n3 -= n4) >= 0) continue;
            n3 += n;
        }
        if (byArray[n3] == 2) {
            int n5 = n3;
            while (byArray[n3] != 0 && (byArray[n3] == 2 || dArray[n3] != d)) {
                if ((n3 -= n4) >= 0) continue;
                n3 += n;
            }
            if (byArray[n3] == 0) {
                n3 = n5;
            }
        }
        if (byArray[n3] == 1) {
            return -n3 - 1;
        }
        return n3;
    }

    protected int indexOfKey(double d) {
        double[] dArray = this.table;
        byte[] byArray = this.state;
        int n = dArray.length;
        int n2 = HashFunctions.hash(d) & Integer.MAX_VALUE;
        int n3 = n2 % n;
        int n4 = n2 % (n - 2);
        if (n4 == 0) {
            n4 = 1;
        }
        while (byArray[n3] != 0 && (byArray[n3] == 2 || dArray[n3] != d)) {
            if ((n3 -= n4) >= 0) continue;
            n3 += n;
        }
        if (byArray[n3] == 0) {
            return -1;
        }
        return n3;
    }

    protected int indexOfValue(int n) {
        int[] nArray = this.values;
        byte[] byArray = this.state;
        int n2 = byArray.length;
        while (--n2 >= 0) {
            if (byArray[n2] != 1 || nArray[n2] != n) continue;
            return n2;
        }
        return -1;
    }

    @Override
    public double keyOf(int n) {
        int n2 = this.indexOfValue(n);
        if (n2 < 0) {
            return Double.NaN;
        }
        return this.table[n2];
    }

    @Override
    public void keys(DoubleArrayList doubleArrayList) {
        doubleArrayList.setSize(this.distinct);
        double[] dArray = doubleArrayList.elements();
        double[] dArray2 = this.table;
        byte[] byArray = this.state;
        int n = 0;
        int n2 = dArray2.length;
        while (n2-- > 0) {
            if (byArray[n2] != 1) continue;
            dArray[n++] = dArray2[n2];
        }
    }

    @Override
    public void pairsMatching(DoubleIntProcedure doubleIntProcedure, DoubleArrayList doubleArrayList, IntArrayList intArrayList) {
        doubleArrayList.clear();
        intArrayList.clear();
        int n = this.table.length;
        while (n-- > 0) {
            if (this.state[n] != 1 || !doubleIntProcedure.apply(this.table[n], this.values[n])) continue;
            doubleArrayList.add(this.table[n]);
            intArrayList.add(this.values[n]);
        }
    }

    @Override
    public boolean put(double d, int n) {
        int n2 = this.indexOfInsertion(d);
        if (n2 < 0) {
            n2 = -n2 - 1;
            this.values[n2] = n;
            return false;
        }
        if (this.distinct > this.highWaterMark) {
            int n3 = this.chooseGrowCapacity(this.distinct + 1, this.minLoadFactor, this.maxLoadFactor);
            this.rehash(n3);
            return this.put(d, n);
        }
        this.table[n2] = d;
        this.values[n2] = n;
        if (this.state[n2] == 0) {
            --this.freeEntries;
        }
        this.state[n2] = 1;
        ++this.distinct;
        if (this.freeEntries < 1) {
            int n4 = this.chooseGrowCapacity(this.distinct + 1, this.minLoadFactor, this.maxLoadFactor);
            this.rehash(n4);
        }
        return true;
    }

    protected void rehash(int n) {
        int n2 = this.table.length;
        double[] dArray = this.table;
        int[] nArray = this.values;
        byte[] byArray = this.state;
        double[] dArray2 = new double[n];
        int[] nArray2 = new int[n];
        byte[] byArray2 = new byte[n];
        this.lowWaterMark = this.chooseLowWaterMark(n, this.minLoadFactor);
        this.highWaterMark = this.chooseHighWaterMark(n, this.maxLoadFactor);
        this.table = dArray2;
        this.values = nArray2;
        this.state = byArray2;
        this.freeEntries = n - this.distinct;
        int n3 = n2;
        while (n3-- > 0) {
            if (byArray[n3] != 1) continue;
            double d = dArray[n3];
            int n4 = this.indexOfInsertion(d);
            dArray2[n4] = d;
            nArray2[n4] = nArray[n3];
            byArray2[n4] = 1;
        }
    }

    @Override
    public boolean removeKey(double d) {
        int n = this.indexOfKey(d);
        if (n < 0) {
            return false;
        }
        this.state[n] = 2;
        --this.distinct;
        if (this.distinct < this.lowWaterMark) {
            int n2 = this.chooseShrinkCapacity(this.distinct, this.minLoadFactor, this.maxLoadFactor);
            this.rehash(n2);
        }
        return true;
    }

    @Override
    protected void setUp(int n, double d, double d2) {
        int n2 = n;
        super.setUp(n2, d, d2);
        n2 = this.nextPrime(n2);
        if (n2 == 0) {
            n2 = 1;
        }
        this.table = new double[n2];
        this.values = new int[n2];
        this.state = new byte[n2];
        this.minLoadFactor = d;
        this.maxLoadFactor = n2 == Integer.MAX_VALUE ? 1.0 : d2;
        this.distinct = 0;
        this.freeEntries = n2;
        this.lowWaterMark = 0;
        this.highWaterMark = this.chooseHighWaterMark(n2, this.maxLoadFactor);
    }

    @Override
    public void trimToSize() {
        int n = this.nextPrime((int)(1.0 + 1.2 * (double)this.size()));
        if (this.table.length > n) {
            this.rehash(n);
        }
    }

    @Override
    public void values(IntArrayList intArrayList) {
        intArrayList.setSize(this.distinct);
        int[] nArray = intArrayList.elements();
        int[] nArray2 = this.values;
        byte[] byArray = this.state;
        int n = 0;
        int n2 = byArray.length;
        while (n2-- > 0) {
            if (byArray[n2] != 1) continue;
            nArray[n++] = nArray2[n2];
        }
    }
}

