/*
 * Decompiled with CFR 0.152.
 */
package joptima.functions;

import joptima.Parameter;
import joptima.functions.ConstrainableFunction;

public class Linear
extends ConstrainableFunction {
    public double m_a;
    public double m_b;
    private String m_name = "Linear";

    @Override
    public Parameter[] getParameters() {
        Parameter[] parameters = new Parameter[this.countUnconstrained()];
        try {
            int cursor = 0;
            if (!this.m_constrained[0]) {
                parameters[cursor++] = new Parameter(this, "a");
            }
            if (!this.m_constrained[1]) {
                parameters[cursor++] = new Parameter(this, "b");
            }
        }
        catch (NoSuchFieldException nsfe) {
            nsfe.printStackTrace();
        }
        return parameters;
    }

    @Override
    public void constrain(String parametername) {
        if ("a".equals(parametername)) {
            this.m_constrained[0] = true;
        }
        if ("b".equals(parametername)) {
            this.m_constrained[1] = true;
        }
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public void setName(String newname) {
        this.m_name = newname;
    }

    public Linear() {
        this(1.0, 0.0);
    }

    public Linear(double a, double b) {
        this.m_a = a;
        this.m_b = b;
        this.m_constrained = new boolean[2];
    }

    @Override
    public double calculate(double x) {
        return this.m_a * x + this.m_b;
    }

    public double getA() {
        return this.m_a;
    }

    public void setA(double a) {
        this.m_a = a;
    }

    public double getB() {
        return this.m_b;
    }

    public void setB(double b) {
        this.m_b = b;
    }
}

