/*
 * Decompiled with CFR 0.152.
 */
package joptima.functions;

import joptima.Parameter;
import joptima.functions.ConstrainableFunction;

public class Cosine
extends ConstrainableFunction {
    public double m_amplitude;
    public double m_frequency;
    public double m_xoffset;
    private String m_name = "Cosine";

    @Override
    public Parameter[] getParameters() {
        Parameter[] parameters = new Parameter[this.countUnconstrained()];
        try {
            int cursor = 0;
            if (!this.m_constrained[0]) {
                parameters[cursor++] = new Parameter(this, "amplitude");
            }
            if (!this.m_constrained[1]) {
                parameters[cursor++] = new Parameter(this, "frequency");
            }
            if (!this.m_constrained[2]) {
                parameters[cursor++] = new Parameter(this, "xoffset");
            }
        }
        catch (NoSuchFieldException nsfe) {
            nsfe.printStackTrace();
        }
        return parameters;
    }

    @Override
    public void constrain(String parametername) {
        if ("amplitude".equals(parametername)) {
            this.m_constrained[0] = true;
        }
        if ("frequency".equals(parametername)) {
            this.m_constrained[1] = true;
        }
        if ("xoffset".equals(parametername)) {
            this.m_constrained[2] = true;
        }
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public void setName(String newname) {
        this.m_name = newname;
    }

    public Cosine() {
        this(1.0, 1.0, 0.0);
    }

    public Cosine(double amplitude, double frequency, double xoffset) {
        this.m_amplitude = amplitude;
        this.m_frequency = frequency;
        this.m_xoffset = xoffset;
        this.m_constrained = new boolean[3];
    }

    @Override
    public double calculate(double x) {
        return this.m_amplitude * Math.cos(Math.PI * 2 * this.m_frequency * (x - this.m_xoffset));
    }

    public void setAngularFrequency(double omega) {
        this.m_frequency = omega / Math.PI / 2.0;
    }

    public double getAngularFrequency() {
        return Math.PI * 2 * this.m_frequency;
    }

    public double getAmplitude() {
        return this.m_amplitude;
    }

    public void setAmplitude(double amplitude) {
        this.m_amplitude = amplitude;
    }

    public double getFrequency() {
        return this.m_frequency;
    }

    public void setFrequency(double frequency) {
        this.m_frequency = frequency;
    }

    public double getXoffset() {
        return this.m_xoffset;
    }

    public void setXoffset(double xoffset) {
        this.m_xoffset = xoffset;
    }
}

