/*
 * Decompiled with CFR 0.152.
 */
package joptima;

import java.util.Iterator;
import joptima.Fitter;
import joptima.Function;
import joptima.Function2D;
import joptima.functions.Sum2D;

public class ChiSquaredFitter2D
extends Fitter {
    private double[] xpoint;
    private double[] ypoint;
    private double[] zpoint;
    private double[] zerror = null;

    public ChiSquaredFitter2D() {
    }

    public ChiSquaredFitter2D(double[] x, double[] y, double[] z) {
        this.setData(x, y, z);
    }

    public ChiSquaredFitter2D(double[] x, double[] y, double[] z, double[] errors) {
        this.setData(x, y, z, errors);
    }

    public ChiSquaredFitter2D(double[] x, double[] y, double[] z, Function f) {
        this(x, y, z);
        this.addFunction(f);
    }

    public ChiSquaredFitter2D(double[] x, double[] y, double[] z, double[] errors, Function f) {
        this(x, y, z, errors);
        this.addFunction(f);
    }

    @Override
    public void addFunction(Function f) {
        throw new UnsupportedOperationException("Adding a 1D function to a 2D fitter is ambiguous.  Use addFunction1Dx() or addFunction1Dy() instead.");
    }

    public void addFunction(Function2D f) {
        this.m_functions.add(f);
        this.m_nparameters += f.getParameters().length;
    }

    public void addFunction1Dx(Function f) {
        this.m_functions.add(new Sum2D(f, null));
        this.m_nparameters += f.getParameters().length;
    }

    public void addFunction1Dy(Function f) {
        this.m_functions.add(new Sum2D(null, f));
        this.m_nparameters += f.getParameters().length;
    }

    public void setData(double[] x, double[] y, double[] z) {
        this.xpoint = x;
        this.ypoint = y;
        this.ypoint = z;
        this.zerror = null;
    }

    public void setData(double[] x, double[] y, double[] z, double[] errors) {
        this.xpoint = x;
        this.ypoint = y;
        this.zpoint = z;
        this.zerror = errors;
    }

    @Override
    public double calculate() {
        double value = 0.0;
        for (int point = 0; point < this.xpoint.length; ++point) {
            Iterator it = this.m_functions.iterator();
            double fvalue = 0.0;
            while (it.hasNext()) {
                Function2D f = (Function2D)it.next();
                fvalue += f.calculate(this.xpoint[point], this.ypoint[point]);
            }
            double chisq = this.zpoint[point] - fvalue;
            chisq *= chisq;
            if (null != this.zerror) {
                chisq /= this.zerror[point] * this.zerror[point];
            }
            value += chisq;
        }
        return value;
    }
}

