/*
 * Decompiled with CFR 0.152.
 */
package com.joptimizer.optimizers;

import cern.colt.matrix.DoubleFactory1D;
import cern.colt.matrix.DoubleFactory2D;
import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.linalg.Algebra;
import cern.jet.math.Functions;
import cern.jet.math.Mult;
import com.joptimizer.optimizers.NewtonLEConstrainedISP;
import com.joptimizer.optimizers.OptimizationRequestHandler;
import com.joptimizer.optimizers.OptimizationResponse;
import com.joptimizer.solvers.BasicKKTSolver;
import com.joptimizer.solvers.KKTSolver;
import com.joptimizer.util.Utils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NewtonLEConstrainedFSP
extends OptimizationRequestHandler {
    private Algebra ALG = Algebra.DEFAULT;
    private DoubleFactory1D F1 = DoubleFactory1D.dense;
    private DoubleFactory2D F2 = DoubleFactory2D.dense;
    private KKTSolver kktSolver;
    private Log log = LogFactory.getLog((String)this.getClass().getName());

    public NewtonLEConstrainedFSP(boolean activateChain) {
        if (activateChain) {
            this.successor = new NewtonLEConstrainedISP(true);
        }
    }

    public NewtonLEConstrainedFSP() {
        this(false);
    }

    @Override
    public int optimize() throws Exception {
        double rPriX0Norm;
        this.log.debug((Object)"optimize");
        OptimizationResponse response = new OptimizationResponse();
        if (this.getFi() != null) {
            return this.forwardOptimizationRequest();
        }
        long tStart = System.currentTimeMillis();
        DoubleMatrix1D X0 = this.getInitialPoint();
        double d = rPriX0Norm = X0 != null ? Math.sqrt(this.ALG.norm2(this.rPri(X0))) : 0.0;
        if (X0 == null || rPriX0Norm > this.getTolerance()) {
            return this.forwardOptimizationRequest();
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("X0:  " + ArrayUtils.toString((Object)X0.toArray())));
        }
        DoubleMatrix1D X = X0;
        double previousLambda = Double.NaN;
        int iteration = 0;
        while (true) {
            DoubleMatrix1D w;
            ++iteration;
            double F0X = this.getF0(X);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("iteration " + iteration));
                this.log.debug((Object)("X=" + ArrayUtils.toString((Object)X.toArray())));
                this.log.debug((Object)("f(X)=" + F0X));
            }
            if (this.checkCustomExitConditions(X)) {
                response.setReturnCode(0);
                break;
            }
            DoubleMatrix1D gradX = this.getGradF0(X);
            DoubleMatrix2D hessX = this.getHessF0(X);
            double gradXNorm = Math.sqrt(this.ALG.norm2(gradX));
            if (gradXNorm < Utils.getDoubleMachineEpsilon()) {
                response.setReturnCode(0);
                break;
            }
            if (this.kktSolver == null) {
                this.kktSolver = new BasicKKTSolver();
            }
            if (this.isCheckKKTSolutionAccuracy()) {
                this.kktSolver.setCheckKKTSolutionAccuracy(this.isCheckKKTSolutionAccuracy());
                this.kktSolver.setToleranceKKT(this.getToleranceKKT());
            }
            this.kktSolver.setHMatrix(hessX.toArray());
            this.kktSolver.setGVector(gradX.toArray());
            if (this.getA() != null) {
                this.kktSolver.setAMatrix(this.getA().toArray());
                this.kktSolver.setATMatrix(this.getAT().toArray());
            }
            double[][] sol = this.kktSolver.solve();
            DoubleMatrix1D step = this.F1.make(sol[0]);
            DoubleMatrix1D doubleMatrix1D = w = sol[1] != null ? this.F1.make(sol[1]) : this.F1.make(0);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("stepX: " + ArrayUtils.toString((Object)step.toArray())));
                this.log.debug((Object)("w    : " + ArrayUtils.toString((Object)w.toArray())));
            }
            double lambda = Math.sqrt(this.ALG.mult(step, this.ALG.mult(hessX, step)));
            this.log.debug((Object)("lambda: " + lambda));
            if (lambda / 2.0 <= this.getTolerance()) {
                response.setReturnCode(0);
                break;
            }
            if (iteration == this.getMaxIteration()) {
                response.setReturnCode(1);
                this.log.warn((Object)"Max iterations limit reached");
                break;
            }
            if (this.isCheckProgressConditions() && !Double.isNaN(previousLambda) && previousLambda <= lambda) {
                this.log.warn((Object)"No progress achieved, exit iterations loop without desired accuracy");
                response.setReturnCode(1);
                break;
            }
            previousLambda = lambda;
            double s = 1.0;
            DoubleMatrix1D X1 = null;
            for (int cnt = 0; cnt < 250; ++cnt) {
                double condDX;
                double condSX;
                X1 = X.copy().assign(step.copy().assign(Mult.mult(s)), Functions.plus);
                if (this.isInDomainF0(X1) && (condSX = this.getF0(X1)) <= (condDX = F0X + this.getAlpha() * s * this.ALG.mult(gradX, step))) break;
                s = this.getBeta() * s;
            }
            this.log.debug((Object)("s: " + s));
            X = X1;
        }
        long tStop = System.currentTimeMillis();
        this.log.debug((Object)("time: " + (tStop - tStart)));
        response.setSolution(X.toArray());
        this.setOptimizationResponse(response);
        return response.getReturnCode();
    }

    public void setKKTSolver(KKTSolver kktSolver) {
        this.kktSolver = kktSolver;
    }
}

