/*
 * Decompiled with CFR 0.152.
 */
package com.cureos.numerics;

import com.cureos.numerics.Calcfc;
import com.cureos.numerics.CobylaExitStatus;

public class Cobyla {
    private static double[] x;

    public static CobylaExitStatus FindMinimum(final Calcfc calcfc, int n, int m, double[] xin, double rhobeg, double rhoend, int iprint, int maxfun) {
        x = xin;
        int mpp = m + 2;
        double[] iox = new double[n + 1];
        System.arraycopy(x, 0, iox, 1, n);
        Calcfc fcalcfc = new Calcfc(){

            @Override
            public double Compute(int n, int m, double[] x, double[] con) {
                double[] ix = new double[n];
                System.arraycopy(x, 1, ix, 0, n);
                double[] ocon = new double[m];
                double f = calcfc.Compute(n, m, ix, ocon);
                System.arraycopy(ocon, 0, con, 1, m);
                return f;
            }
        };
        CobylaExitStatus status = Cobyla.cobylb(fcalcfc, n, m, mpp, iox, rhobeg, rhoend, iprint, maxfun);
        System.arraycopy(iox, 1, x, 0, n);
        return status;
    }

    /*
     * Unable to fully structure code
     */
    private static CobylaExitStatus cobylb(Calcfc calcfc, int n, int m, int mpp, double[] x, double rhobeg, double rhoend, int iprint, int maxfun) {
        alpha = 0.25;
        beta = 2.1;
        gamma = 0.5;
        delta = 1.1;
        f = 0.0;
        resmax = 0.0;
        np = n + 1;
        mp = m + 1;
        rho = rhobeg;
        parmu = 0.0;
        iflag = false;
        ifull = false;
        parsig = 0.0;
        prerec = 0.0;
        prerem = 0.0;
        con = new double[1 + mpp];
        sim = new double[1 + n][1 + np];
        simi = new double[1 + n][1 + n];
        datmat = new double[1 + mpp][1 + np];
        a = new double[1 + n][1 + mp];
        vsig = new double[1 + n];
        veta = new double[1 + n];
        sigbar = new double[1 + n];
        dx = new double[1 + n];
        w = new double[1 + n];
        if (iprint >= 2) {
            System.out.format("%nThe initial value of RHO is %13.6f and PARMU is set to zero.%n", new Object[]{rho});
        }
        nfvals = 0;
        temp = 1.0 / rho;
        for (i = 1; i <= n; ++i) {
            sim[i][np] = x[i];
            sim[i][i] = rho;
            simi[i][i] = temp;
        }
        jdrop = np;
        ibrnch = false;
        block6: while (true) {
            if (nfvals >= maxfun && nfvals > 0) {
                status = CobylaExitStatus.MaxIterationsReached;
                break;
            }
            ++nfvals;
            f = calcfc.Compute(n, m, x, con);
            resmax = 0.0;
            for (k = 1; k <= m; ++k) {
                resmax = Math.max(resmax, -con[k]);
            }
            if (nfvals == iprint - 1 || iprint == 3) {
                Cobyla.PrintIterationResult(nfvals, f, resmax, x, n);
            }
            con[mp] = f;
            con[mpp] = resmax;
            skipVertexIdent = true;
            if (!ibrnch) {
                skipVertexIdent = false;
                for (i = 1; i <= mpp; ++i) {
                    datmat[i][jdrop] = con[i];
                }
                if (nfvals <= np) {
                    if (jdrop <= n) {
                        if (datmat[mp][np] <= f) {
                            x[jdrop] = sim[jdrop][np];
                        } else {
                            sim[jdrop][np] = x[jdrop];
                            for (k = 1; k <= mpp; ++k) {
                                datmat[k][jdrop] = datmat[k][np];
                                datmat[k][np] = con[k];
                            }
                            for (k = 1; k <= jdrop; ++k) {
                                sim[jdrop][k] = -rho;
                                temp = 0.0;
                                for (i = k; i <= jdrop; ++i) {
                                    temp -= simi[i][k];
                                }
                                simi[jdrop][k] = temp;
                            }
                        }
                    }
                    if (nfvals <= n) {
                        v0 = jdrop = nfvals;
                        x[v0] = x[v0] + rho;
                        continue;
                    }
                }
                ibrnch = true;
            }
            block12: while (true) {
                if (skipVertexIdent) ** GOTO lbl240
                phimin = datmat[mp][np] + parmu * datmat[mpp][np];
                nbest = np;
                for (j = 1; j <= n; ++j) {
                    temp = datmat[mp][j] + parmu * datmat[mpp][j];
                    if (temp < phimin) {
                        nbest = j;
                        phimin = temp;
                        continue;
                    }
                    if (temp != phimin || parmu != 0.0 || !(datmat[mpp][j] < datmat[mpp][nbest])) continue;
                    nbest = j;
                }
                if (nbest <= n) {
                    for (i = 1; i <= mpp; ++i) {
                        temp = datmat[i][np];
                        datmat[i][np] = datmat[i][nbest];
                        datmat[i][nbest] = temp;
                    }
                    for (i = 1; i <= n; ++i) {
                        temp = sim[i][nbest];
                        sim[i][nbest] = 0.0;
                        v1 = sim[i];
                        v2 = np;
                        v1[v2] = v1[v2] + temp;
                        tempa = 0.0;
                        for (k = 1; k <= n; ++k) {
                            v3 = sim[i];
                            v4 = k;
                            v3[v4] = v3[v4] - temp;
                            tempa -= simi[k][i];
                        }
                        simi[nbest][i] = tempa;
                    }
                }
                error = 0.0;
                for (i = 1; i <= n; ++i) {
                    for (j = 1; j <= n; ++j) {
                        temp = Cobyla.DOT_PRODUCT(Cobyla.PART(Cobyla.ROW(simi, i), 1, n), Cobyla.PART(Cobyla.COL(sim, j), 1, n)) - (i == j ? 1.0 : 0.0);
                        error = Math.max(error, Math.abs(temp));
                    }
                }
                if (error > 0.1) {
                    status = CobylaExitStatus.DivergingRoundingErrors;
                    break block6;
                }
                for (k = 1; k <= mp; ++k) {
                    con[k] = -datmat[k][np];
                    for (j = 1; j <= n; ++j) {
                        w[j] = datmat[k][j] + con[k];
                    }
                    for (i = 1; i <= n; ++i) {
                        a[i][k] = (k == mp ? -1.0 : 1.0) * Cobyla.DOT_PRODUCT(Cobyla.PART(w, 1, n), Cobyla.PART(Cobyla.COL(simi, i), 1, n));
                    }
                }
                iflag = true;
                parsig = alpha * rho;
                pareta = beta * rho;
                for (j = 1; j <= n; ++j) {
                    wsig = 0.0;
                    for (k = 1; k <= n; ++k) {
                        wsig += simi[j][k] * simi[j][k];
                    }
                    weta = 0.0;
                    for (k = 1; k <= n; ++k) {
                        weta += sim[k][j] * sim[k][j];
                    }
                    vsig[j] = 1.0 / Math.sqrt(wsig);
                    veta[j] = Math.sqrt(weta);
                    if (!(vsig[j] < parsig) && !(veta[j] > pareta)) continue;
                    iflag = false;
                }
                if (!ibrnch && !iflag) {
                    jdrop = 0;
                    temp = pareta;
                    for (j = 1; j <= n; ++j) {
                        if (!(veta[j] > temp)) continue;
                        jdrop = j;
                        temp = veta[j];
                    }
                    if (jdrop == 0) {
                        for (j = 1; j <= n; ++j) {
                            if (!(vsig[j] < temp)) continue;
                            jdrop = j;
                            temp = vsig[j];
                        }
                    }
                    temp = gamma * rho * vsig[jdrop];
                    for (k = 1; k <= n; ++k) {
                        dx[k] = temp * simi[jdrop][k];
                    }
                    cvmaxp = 0.0;
                    cvmaxm = 0.0;
                    total = 0.0;
                    for (k = 1; k <= mp; ++k) {
                        total = Cobyla.DOT_PRODUCT(Cobyla.PART(Cobyla.COL(a, k), 1, n), Cobyla.PART(dx, 1, n));
                        if (k >= mp) continue;
                        temp = datmat[k][np];
                        cvmaxp = Math.max(cvmaxp, -total - temp);
                        cvmaxm = Math.max(cvmaxm, total - temp);
                    }
                    dxsign = parmu * (cvmaxp - cvmaxm) > 2.0 * total ? -1.0 : 1.0;
                    temp = 0.0;
                    for (i = 1; i <= n; ++i) {
                        dx[i] = dxsign * dx[i];
                        sim[i][jdrop] = dx[i];
                        temp += simi[jdrop][i] * dx[i];
                    }
                    k = 1;
                    while (k <= n) {
                        v5 = simi[jdrop];
                        v6 = k++;
                        v5[v6] = v5[v6] / temp;
                    }
                    j = 1;
                    while (true) {
                        if (j > n) continue block6;
                        if (j != jdrop) {
                            temp = Cobyla.DOT_PRODUCT(Cobyla.PART(Cobyla.ROW(simi, j), 1, n), Cobyla.PART(dx, 1, n));
                            for (k = 1; k <= n; ++k) {
                                v7 = simi[j];
                                v8 = k;
                                v7[v8] = v7[v8] - temp * simi[jdrop][k];
                            }
                        }
                        x[j] = sim[j][np] + dx[j];
                        ++j;
                    }
                }
                ifull = Cobyla.trstlp(n, m, a, con, rho, dx);
                if (ifull) ** GOTO lbl-1000
                temp = 0.0;
                for (k = 1; k <= n; ++k) {
                    temp += dx[k] * dx[k];
                }
                if (temp < 0.25 * rho * rho) {
                    ibrnch = true;
                } else lbl-1000:
                // 2 sources

                {
                    total = 0.0;
                    resnew = 0.0;
                    con[mp] = 0.0;
                    for (k = 1; k <= mp; ++k) {
                        total = con[k] - Cobyla.DOT_PRODUCT(Cobyla.PART(Cobyla.COL(a, k), 1, n), Cobyla.PART(dx, 1, n));
                        if (k >= mp) continue;
                        resnew = Math.max(resnew, total);
                    }
                    prerec = datmat[mpp][np] - resnew;
                    v9 = barmu = prerec > 0.0 ? total / prerec : 0.0;
                    if (parmu < 1.5 * barmu) {
                        parmu = 2.0 * barmu;
                        if (iprint >= 2) {
                            System.out.format("%nIncrease in PARMU to %13.6f%n", new Object[]{parmu});
                        }
                        phi = datmat[mp][np] + parmu * datmat[mpp][np];
                        for (j = 1; j <= n; ++j) {
                            temp = datmat[mp][j] + parmu * datmat[mpp][j];
                            if (temp < phi || temp == phi && parmu == 0.0 && datmat[mpp][j] < datmat[mpp][np]) continue block12;
                        }
                    }
                    prerem = parmu * prerec - total;
                    for (k = 1; k <= n; ++k) {
                        x[k] = sim[k][np] + dx[k];
                    }
                    ibrnch = true;
                    continue block6;
lbl240:
                    // 1 sources

                    skipVertexIdent = false;
                    vmold = datmat[mp][np] + parmu * datmat[mpp][np];
                    vmnew = f + parmu * resmax;
                    trured = vmold - vmnew;
                    if (parmu == 0.0 && f == datmat[mp][np]) {
                        prerem = prerec;
                        trured = datmat[mpp][np] - resmax;
                    }
                    ratio = trured <= 0.0 ? 1.0 : 0.0;
                    jdrop = 0;
                    for (j = 1; j <= n; ++j) {
                        temp = Math.abs(Cobyla.DOT_PRODUCT(Cobyla.PART(Cobyla.ROW(simi, j), 1, n), Cobyla.PART(dx, 1, n)));
                        if (temp > ratio) {
                            jdrop = j;
                            ratio = temp;
                        }
                        sigbar[j] = temp * vsig[j];
                    }
                    edgmax = delta * rho;
                    l = 0;
                    for (j = 1; j <= n; ++j) {
                        if (!(sigbar[j] >= parsig) && !(sigbar[j] >= vsig[j])) continue;
                        temp = veta[j];
                        if (trured > 0.0) {
                            temp = 0.0;
                            for (k = 1; k <= n; ++k) {
                                temp += Math.pow(dx[k] - sim[k][j], 2.0);
                            }
                            temp = Math.sqrt(temp);
                        }
                        if (!(temp > edgmax)) continue;
                        l = j;
                        edgmax = temp;
                    }
                    if (l > 0) {
                        jdrop = l;
                    }
                    if (jdrop != 0) {
                        temp = 0.0;
                        for (i = 1; i <= n; ++i) {
                            sim[i][jdrop] = dx[i];
                            temp += simi[jdrop][i] * dx[i];
                        }
                        k = 1;
                        while (k <= n) {
                            v10 = simi[jdrop];
                            v11 = k++;
                            v10[v11] = v10[v11] / temp;
                        }
                        for (j = 1; j <= n; ++j) {
                            if (j == jdrop) continue;
                            temp = Cobyla.DOT_PRODUCT(Cobyla.PART(Cobyla.ROW(simi, j), 1, n), Cobyla.PART(dx, 1, n));
                            for (k = 1; k <= n; ++k) {
                                v12 = simi[j];
                                v13 = k;
                                v12[v13] = v12[v13] - temp * simi[jdrop][k];
                            }
                        }
                        for (k = 1; k <= mpp; ++k) {
                            datmat[k][jdrop] = con[k];
                        }
                        if (trured > 0.0 && trured >= 0.1 * prerem) continue;
                    }
                }
                if (!iflag) {
                    ibrnch = false;
                    continue;
                }
                if (rho <= rhoend) {
                    status = CobylaExitStatus.Normal;
                    break block6;
                }
                cmin = 0.0;
                cmax = 0.0;
                if ((rho *= 0.5) <= 1.5 * rhoend) {
                    rho = rhoend;
                }
                if (parmu > 0.0) {
                    denom = 0.0;
                    for (k = 1; k <= mp; ++k) {
                        cmax = cmin = datmat[k][np];
                        for (i = 1; i <= n; ++i) {
                            cmin = Math.min(cmin, datmat[k][i]);
                            cmax = Math.max(cmax, datmat[k][i]);
                        }
                        if (k > m || !(cmin < 0.5 * cmax)) continue;
                        temp = Math.max(cmax, 0.0) - cmin;
                        denom = denom <= 0.0 ? temp : Math.min(denom, temp);
                    }
                    if (denom == 0.0) {
                        parmu = 0.0;
                    } else if (cmax - cmin < parmu * denom) {
                        parmu = (cmax - cmin) / denom;
                    }
                }
                if (iprint >= 2) {
                    System.out.format("%nReduction in RHO to %1$13.6f  and PARMU = %2$13.6f%n", new Object[]{rho, parmu});
                }
                if (iprint != 2) continue;
                Cobyla.PrintIterationResult(nfvals, datmat[mp][np], datmat[mpp][np], Cobyla.COL(sim, np), n);
            }
            break;
        }
        switch (2.$SwitchMap$com$cureos$numerics$CobylaExitStatus[status.ordinal()]) {
            case 1: {
                if (iprint >= 1) {
                    System.out.format("%nNormal return from subroutine COBYLA%n", new Object[0]);
                }
                if (!ifull) break;
                if (iprint >= 1) {
                    Cobyla.PrintIterationResult(nfvals, f, resmax, x, n);
                }
                return status;
            }
            case 2: {
                if (iprint < 1) break;
                System.out.format("%nReturn from subroutine COBYLA because the MAXFUN limit has been reached.%n", new Object[0]);
                break;
            }
            case 3: {
                if (iprint < 1) break;
                System.out.format("%nReturn from subroutine COBYLA because rounding errors are becoming damaging.%n", new Object[0]);
            }
        }
        for (k = 1; k <= n; ++k) {
            x[k] = sim[k][np];
        }
        f = datmat[mp][np];
        resmax = datmat[mpp][np];
        if (iprint >= 1) {
            Cobyla.PrintIterationResult(nfvals, f, resmax, x, n);
        }
        return status;
    }

    public double[] getOutput() {
        return x;
    }

    private static boolean trstlp(int n, int m, double[][] a, double[] b, double rho, double[] dx) {
        int nactx = 0;
        double resold = 0.0;
        double[][] z = new double[1 + n][1 + n];
        double[] zdota = new double[2 + m];
        double[] vmultc = new double[2 + m];
        double[] sdirn = new double[1 + n];
        double[] dxnew = new double[1 + n];
        double[] vmultd = new double[2 + m];
        int[] iact = new int[2 + m];
        int mcon = m;
        int nact = 0;
        for (int i = 1; i <= n; ++i) {
            z[i][i] = 1.0;
            dx[i] = 0.0;
        }
        int icon = 0;
        double resmax = 0.0;
        if (m >= 1) {
            int k;
            for (k = 1; k <= m; ++k) {
                if (!(b[k] > resmax)) continue;
                resmax = b[k];
                icon = k;
            }
            for (k = 1; k <= m; ++k) {
                iact[k] = k;
                vmultc[k] = resmax - b[k];
            }
        }
        boolean first = true;
        while (true) {
            block65: {
                double step;
                double stpful;
                if (!first || first && resmax == 0.0) {
                    icon = mcon = m + 1;
                    iact[mcon] = mcon;
                    vmultc[mcon] = 0.0;
                }
                first = false;
                double optold = 0.0;
                int icount = 0;
                do {
                    int k;
                    double ratio;
                    double temp;
                    int k2;
                    double optnew;
                    double d = optnew = mcon == m ? resmax : -Cobyla.DOT_PRODUCT(Cobyla.PART(dx, 1, n), Cobyla.PART(Cobyla.COL(a, mcon), 1, n));
                    if (icount == 0 || optnew < optold) {
                        optold = optnew;
                        nactx = nact;
                        icount = 3;
                    } else if (nact > nactx) {
                        nactx = nact;
                        icount = 3;
                    } else {
                        --icount;
                    }
                    if (icount == 0) break block65;
                    if (icon <= nact) {
                        int k3;
                        if (icon < nact) {
                            int kp;
                            int isave = iact[icon];
                            double vsave = vmultc[icon];
                            k2 = icon;
                            do {
                                kp = k2 + 1;
                                int kk = iact[kp];
                                double sp = Cobyla.DOT_PRODUCT(Cobyla.PART(Cobyla.COL(z, k2), 1, n), Cobyla.PART(Cobyla.COL(a, kk), 1, n));
                                temp = Math.sqrt(sp * sp + zdota[kp] * zdota[kp]);
                                double alpha = zdota[kp] / temp;
                                double beta = sp / temp;
                                zdota[kp] = alpha * zdota[k2];
                                zdota[k2] = temp;
                                for (int i = 1; i <= n; ++i) {
                                    temp = alpha * z[i][kp] + beta * z[i][k2];
                                    z[i][kp] = alpha * z[i][k2] - beta * z[i][kp];
                                    z[i][k2] = temp;
                                }
                                iact[k2] = kk;
                                vmultc[k2] = vmultc[kp];
                            } while ((k2 = kp) < nact);
                            iact[k2] = isave;
                            vmultc[k2] = vsave;
                        }
                        --nact;
                        if (mcon > m) {
                            temp = 1.0 / zdota[nact];
                            for (k3 = 1; k3 <= n; ++k3) {
                                sdirn[k3] = temp * z[k3][nact];
                            }
                        } else {
                            temp = Cobyla.DOT_PRODUCT(Cobyla.PART(sdirn, 1, n), Cobyla.PART(Cobyla.COL(z, nact + 1), 1, n));
                            for (k3 = 1; k3 <= n; ++k3) {
                                int n2 = k3;
                                sdirn[n2] = sdirn[n2] - temp * z[k3][nact + 1];
                            }
                        }
                    } else {
                        double accb;
                        double sp;
                        int kk = iact[icon];
                        for (int k4 = 1; k4 <= n; ++k4) {
                            dxnew[k4] = a[k4][kk];
                        }
                        double tot = 0.0;
                        for (k2 = n; k2 > nact; --k2) {
                            sp = 0.0;
                            double spabs = 0.0;
                            for (int i = 1; i <= n; ++i) {
                                temp = z[i][k2] * dxnew[i];
                                sp += temp;
                                spabs += Math.abs(temp);
                            }
                            double acca = spabs + 0.1 * Math.abs(sp);
                            accb = spabs + 0.2 * Math.abs(sp);
                            if (spabs >= acca || acca >= accb) {
                                sp = 0.0;
                            }
                            if (tot == 0.0) {
                                tot = sp;
                                continue;
                            }
                            int kp = k2 + 1;
                            temp = Math.sqrt(sp * sp + tot * tot);
                            double alpha = sp / temp;
                            double beta = tot / temp;
                            tot = temp;
                            for (int i = 1; i <= n; ++i) {
                                temp = alpha * z[i][k2] + beta * z[i][kp];
                                z[i][kp] = alpha * z[i][kp] - beta * z[i][k2];
                                z[i][k2] = temp;
                            }
                        }
                        if (tot == 0.0) {
                            ratio = -1.0;
                            k2 = nact;
                            do {
                                double zdotv = 0.0;
                                double zdvabs = 0.0;
                                for (int i = 1; i <= n; ++i) {
                                    temp = z[i][k2] * dxnew[i];
                                    zdotv += temp;
                                    zdvabs += Math.abs(temp);
                                }
                                double acca = zdvabs + 0.1 * Math.abs(zdotv);
                                accb = zdvabs + 0.2 * Math.abs(zdotv);
                                if (zdvabs < acca && acca < accb) {
                                    temp = zdotv / zdota[k2];
                                    if (temp > 0.0 && iact[k2] <= m) {
                                        double tempa = vmultc[k2] / temp;
                                        if (ratio < 0.0 || tempa < ratio) {
                                            ratio = tempa;
                                        }
                                    }
                                    if (k2 >= 2) {
                                        int kw = iact[k2];
                                        for (int i = 1; i <= n; ++i) {
                                            int n3 = i;
                                            dxnew[n3] = dxnew[n3] - temp * a[i][kw];
                                        }
                                    }
                                    vmultd[k2] = temp;
                                    continue;
                                }
                                vmultd[k2] = 0.0;
                            } while (--k2 > 0);
                            if (ratio < 0.0) break block65;
                            for (k2 = 1; k2 <= nact; ++k2) {
                                vmultc[k2] = Math.max(0.0, vmultc[k2] - ratio * vmultd[k2]);
                            }
                            if (icon < nact) {
                                int kp;
                                int isave = iact[icon];
                                double vsave = vmultc[icon];
                                int k5 = icon;
                                do {
                                    kp = k5 + 1;
                                    int kw = iact[kp];
                                    double sp2 = Cobyla.DOT_PRODUCT(Cobyla.PART(Cobyla.COL(z, k5), 1, n), Cobyla.PART(Cobyla.COL(a, kw), 1, n));
                                    temp = Math.sqrt(sp2 * sp2 + zdota[kp] * zdota[kp]);
                                    double alpha = zdota[kp] / temp;
                                    double beta = sp2 / temp;
                                    zdota[kp] = alpha * zdota[k5];
                                    zdota[k5] = temp;
                                    for (int i = 1; i <= n; ++i) {
                                        temp = alpha * z[i][kp] + beta * z[i][k5];
                                        z[i][kp] = alpha * z[i][k5] - beta * z[i][kp];
                                        z[i][k5] = temp;
                                    }
                                    iact[k5] = kw;
                                    vmultc[k5] = vmultc[kp];
                                } while ((k5 = kp) < nact);
                                iact[k5] = isave;
                                vmultc[k5] = vsave;
                            }
                            if ((temp = Cobyla.DOT_PRODUCT(Cobyla.PART(Cobyla.COL(z, nact), 1, n), Cobyla.PART(Cobyla.COL(a, kk), 1, n))) == 0.0) break block65;
                            zdota[nact] = temp;
                            vmultc[icon] = 0.0;
                            vmultc[nact] = ratio;
                        } else {
                            zdota[++nact] = tot;
                            vmultc[icon] = vmultc[nact];
                            vmultc[nact] = 0.0;
                        }
                        iact[icon] = iact[nact];
                        iact[nact] = kk;
                        if (mcon > m && kk != mcon) {
                            k2 = nact - 1;
                            sp = Cobyla.DOT_PRODUCT(Cobyla.PART(Cobyla.COL(z, k2), 1, n), Cobyla.PART(Cobyla.COL(a, kk), 1, n));
                            temp = Math.sqrt(sp * sp + zdota[nact] * zdota[nact]);
                            double alpha = zdota[nact] / temp;
                            double beta = sp / temp;
                            zdota[nact] = alpha * zdota[k2];
                            zdota[k2] = temp;
                            for (int i = 1; i <= n; ++i) {
                                temp = alpha * z[i][nact] + beta * z[i][k2];
                                z[i][nact] = alpha * z[i][k2] - beta * z[i][nact];
                                z[i][k2] = temp;
                            }
                            iact[nact] = iact[k2];
                            iact[k2] = kk;
                            temp = vmultc[k2];
                            vmultc[k2] = vmultc[nact];
                            vmultc[nact] = temp;
                        }
                        if (mcon > m) {
                            temp = 1.0 / zdota[nact];
                            for (k2 = 1; k2 <= n; ++k2) {
                                sdirn[k2] = temp * z[k2][nact];
                            }
                        } else {
                            kk = iact[nact];
                            temp = (Cobyla.DOT_PRODUCT(Cobyla.PART(sdirn, 1, n), Cobyla.PART(Cobyla.COL(a, kk), 1, n)) - 1.0) / zdota[nact];
                            for (k2 = 1; k2 <= n; ++k2) {
                                int n4 = k2;
                                sdirn[n4] = sdirn[n4] - temp * z[k2][nact];
                            }
                        }
                    }
                    double dd = rho * rho;
                    double sd = 0.0;
                    double ss = 0.0;
                    for (int i = 1; i <= n; ++i) {
                        if (Math.abs(dx[i]) >= 1.0E-6 * rho) {
                            dd -= dx[i] * dx[i];
                        }
                        sd += dx[i] * sdirn[i];
                        ss += sdirn[i] * sdirn[i];
                    }
                    if (dd <= 0.0) break block65;
                    temp = Math.sqrt(ss * dd);
                    if (Math.abs(sd) >= 1.0E-6 * temp) {
                        temp = Math.sqrt(ss * dd + sd * sd);
                    }
                    step = stpful = dd / (temp + sd);
                    if (mcon == m) {
                        double acca = step + 0.1 * resmax;
                        double accb = step + 0.2 * resmax;
                        if (step >= acca || acca >= accb) break;
                        step = Math.min(step, resmax);
                    }
                    for (k = 1; k <= n; ++k) {
                        dxnew[k] = dx[k] + step * sdirn[k];
                    }
                    if (mcon == m) {
                        resold = resmax;
                        resmax = 0.0;
                        for (k = 1; k <= nact; ++k) {
                            int kk = iact[k];
                            temp = b[kk] - Cobyla.DOT_PRODUCT(Cobyla.PART(Cobyla.COL(a, kk), 1, n), Cobyla.PART(dxnew, 1, n));
                            resmax = Math.max(resmax, temp);
                        }
                    }
                    k = nact;
                    do {
                        double zdotw = 0.0;
                        double zdwabs = 0.0;
                        for (int i = 1; i <= n; ++i) {
                            temp = z[i][k] * dxnew[i];
                            zdotw += temp;
                            zdwabs += Math.abs(temp);
                        }
                        double acca = zdwabs + 0.1 * Math.abs(zdotw);
                        double accb = zdwabs + 0.2 * Math.abs(zdotw);
                        if (zdwabs >= acca || acca >= accb) {
                            zdotw = 0.0;
                        }
                        vmultd[k] = zdotw / zdota[k];
                        if (k < 2) continue;
                        int kk = iact[k];
                        for (int i = 1; i <= n; ++i) {
                            int n5 = i;
                            dxnew[n5] = dxnew[n5] - vmultd[k] * a[i][kk];
                        }
                    } while (k-- >= 2);
                    if (mcon > m) {
                        vmultd[nact] = Math.max(0.0, vmultd[nact]);
                    }
                    for (k = 1; k <= n; ++k) {
                        dxnew[k] = dx[k] + step * sdirn[k];
                    }
                    if (mcon > nact) {
                        int kl;
                        for (int k6 = kl = nact + 1; k6 <= mcon; ++k6) {
                            int kk = iact[k6];
                            double total = resmax - b[kk];
                            double sumabs = resmax + Math.abs(b[kk]);
                            for (int i = 1; i <= n; ++i) {
                                temp = a[i][kk] * dxnew[i];
                                total += temp;
                                sumabs += Math.abs(temp);
                            }
                            double acca = sumabs + 0.1 * Math.abs(total);
                            double accb = sumabs + 0.2 * Math.abs(total);
                            if (sumabs >= acca || acca >= accb) {
                                total = 0.0;
                            }
                            vmultd[k6] = total;
                        }
                    }
                    ratio = 1.0;
                    icon = 0;
                    for (k = 1; k <= mcon; ++k) {
                        if (!(vmultd[k] < 0.0) || !((temp = vmultc[k] / (vmultc[k] - vmultd[k])) < ratio)) continue;
                        ratio = temp;
                        icon = k;
                    }
                    temp = 1.0 - ratio;
                    for (k = 1; k <= n; ++k) {
                        dx[k] = temp * dx[k] + ratio * dxnew[k];
                    }
                    for (k = 1; k <= mcon; ++k) {
                        vmultc[k] = Math.max(0.0, temp * vmultc[k] + ratio * vmultd[k]);
                    }
                    if (mcon != m) continue;
                    resmax = resold + ratio * (resmax - resold);
                } while (icon > 0);
                if (step != stpful) continue;
                return true;
            }
            if (mcon != m) break;
        }
        return false;
    }

    private static void PrintIterationResult(int nfvals, double f, double resmax, double[] x, int n) {
        System.out.format("%nNFVALS = %1$5d   F = %2$13.6f    MAXCV = %3$13.6e%n", nfvals, f, resmax);
        System.out.format("X = %s%n", Cobyla.FORMAT(Cobyla.PART(x, 1, n)));
    }

    private static double[] ROW(double[][] src, int rowidx) {
        int cols = src[0].length;
        double[] dest = new double[cols];
        for (int col = 0; col < cols; ++col) {
            dest[col] = src[rowidx][col];
        }
        return dest;
    }

    private static double[] COL(double[][] src, int colidx) {
        int rows = src.length;
        double[] dest = new double[rows];
        for (int row = 0; row < rows; ++row) {
            dest[row] = src[row][colidx];
        }
        return dest;
    }

    private static double[] PART(double[] src, int from, int to) {
        double[] dest = new double[to - from + 1];
        int destidx = 0;
        int srcidx = from;
        while (srcidx <= to) {
            dest[destidx] = src[srcidx];
            ++srcidx;
            ++destidx;
        }
        return dest;
    }

    private static String FORMAT(double[] x) {
        String fmt = "";
        for (int i = 0; i < x.length; ++i) {
            fmt = fmt + String.format("%13.6f", x[i]);
        }
        return fmt;
    }

    private static double DOT_PRODUCT(double[] lhs, double[] rhs) {
        double sum = 0.0;
        for (int i = 0; i < lhs.length; ++i) {
            sum += lhs[i] * rhs[i];
        }
        return sum;
    }
}

