/*
 * Decompiled with CFR 0.152.
 */
package com.mhuss.AstroLib;

import com.mhuss.AstroLib.DateOps;
import com.mhuss.AstroLib.Latitude;
import com.mhuss.AstroLib.Longitude;
import com.mhuss.AstroLib.LunarCalc;
import com.mhuss.AstroLib.NoInitException;
import com.mhuss.AstroLib.ObsInfo;
import com.mhuss.AstroLib.PlanetData;

public class AstroTest {
    public static void main(String[] args) {
        AstroTest.LunarRS();
    }

    public static void LunarRS() {
        ObsInfo oi = new ObsInfo(new Latitude(40.0), new Longitude(-75.8));
        System.out.println(LunarCalc.summary(oi));
        System.out.println(LunarCalc.summaryPHL());
    }

    public static void Punit() {
        double jd = DateOps.dmyToDay(11, 4, 1979);
        ObsInfo oi = new ObsInfo(new Latitude(27.2), new Longitude(77.02));
        PlanetData pde = new PlanetData(0, jd, oi);
        try {
            System.out.println("Sun Lon = " + Math.toDegrees(pde.getEclipticLon()));
        }
        catch (NoInitException e) {
            System.out.println("Error calculating Sun: " + e);
        }
        PlanetData pdm = new PlanetData(4, jd, oi);
        try {
            System.out.println("Mars Lon = " + Math.toDegrees(pdm.getEclipticLon()));
        }
        catch (NoInitException e) {
            System.out.println("Error calculating Mars: " + e);
        }
    }
}

