/*
 * Decompiled with CFR 0.152.
 */
package javolution.xml.stream;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import javax.realtime.MemoryArea;
import javolution.context.LogContext;
import javolution.context.ObjectFactory;
import javolution.io.UTF8StreamReader;
import javolution.lang.Reusable;
import javolution.text.CharArray;
import javolution.xml.sax.Attributes;
import javolution.xml.stream.AttributesImpl;
import javolution.xml.stream.EntitiesImpl;
import javolution.xml.stream.Location;
import javolution.xml.stream.NamespaceContext;
import javolution.xml.stream.NamespacesImpl;
import javolution.xml.stream.XMLStreamException;
import javolution.xml.stream.XMLStreamReader;

public final class XMLStreamReaderImpl
implements XMLStreamReader,
Reusable {
    static final String[] NAMES_OF_EVENTS = new String[]{"UNDEFINED", "START_ELEMENT", "END_ELEMENT", "PROCESSING_INSTRUCTIONS", "CHARACTERS", "COMMENT", "SPACE", "START_DOCUMENT", "END_DOCUMENT", "ENTITY_REFERENCE", "ATTRIBUTE", "DTD", "CDATA", "NAMESPACE", "NOTATION_DECLARATION", "ENTITY_DECLARATION"};
    static final int READER_BUFFER_CAPACITY = 4096;
    CharArray _prolog;
    ObjectFactory _objectFactory;
    private int _readIndex;
    private int _readCount;
    private char[] _data = new char[8192];
    private int _index;
    private int _depth;
    private CharArray _qName;
    private int _prefixSep;
    private CharArray _attrQName;
    private int _attrPrefixSep;
    private CharArray _attrValue;
    private int _eventType = 7;
    private boolean _isEmpty;
    boolean _charactersPending = false;
    private int _start;
    private int _state = 1;
    private CharArray _text;
    private Reader _reader;
    private final char[] _readBuffer = new char[4096];
    private int _startOffset;
    private final LocationImpl _location = new LocationImpl();
    private final NamespacesImpl _namespaces = new NamespacesImpl();
    private final AttributesImpl _attributes = new AttributesImpl(this._namespaces);
    private CharArray[] _elemStack = new CharArray[16];
    private String _encoding;
    private final EntitiesImpl _entities = new EntitiesImpl();
    private final UTF8StreamReader _utf8StreamReader = new UTF8StreamReader();
    private static final int STATE_CHARACTERS = 1;
    private static final int STATE_MARKUP = 2;
    private static final int STATE_COMMENT = 3;
    private static final int STATE_PI = 4;
    private static final int STATE_CDATA = 5;
    private static final int STATE_OPEN_TAGxREAD_ELEM_NAME = 6;
    private static final int STATE_OPEN_TAGxELEM_NAME_READ = 7;
    private static final int STATE_OPEN_TAGxREAD_ATTR_NAME = 8;
    private static final int STATE_OPEN_TAGxATTR_NAME_READ = 9;
    private static final int STATE_OPEN_TAGxEQUAL_READ = 10;
    private static final int STATE_OPEN_TAGxREAD_ATTR_VALUE_SIMPLE_QUOTE = 11;
    private static final int STATE_OPEN_TAGxREAD_ATTR_VALUE_DOUBLE_QUOTE = 12;
    private static final int STATE_OPEN_TAGxEMPTY_TAG = 13;
    private static final int STATE_CLOSE_TAGxREAD_ELEM_NAME = 14;
    private static final int STATE_CLOSE_TAGxELEM_NAME_READ = 15;
    private static final int STATE_DTD = 16;
    private static final int STATE_DTD_INTERNAL = 17;
    private final Runnable _createSeqLogic = new Runnable(){

        public void run() {
            CharArray[] charArrayArray;
            if (XMLStreamReaderImpl.this._seqsCapacity >= XMLStreamReaderImpl.this._seqs.length) {
                charArrayArray = new CharArray[XMLStreamReaderImpl.this._seqs.length * 2];
                System.arraycopy(XMLStreamReaderImpl.this._seqs, 0, charArrayArray, 0, XMLStreamReaderImpl.this._seqs.length);
                XMLStreamReaderImpl.access$202(XMLStreamReaderImpl.this, charArrayArray);
            }
            ((XMLStreamReaderImpl)XMLStreamReaderImpl.this)._seqs[((XMLStreamReaderImpl)XMLStreamReaderImpl.this)._seqsCapacity++] = charArrayArray = new CharArray();
        }
    };
    private CharArray[] _seqs = new CharArray[256];
    private int _seqsIndex;
    private int _seqsCapacity;
    private static final CharArray ENCODING = new CharArray("encoding");
    private static final CharArray VERSION = new CharArray("version");
    private static final CharArray STANDALONE = new CharArray("standalone");

    public void setInput(InputStream inputStream) throws XMLStreamException {
        this.setInput(inputStream, this.detectEncoding(inputStream));
        CharArray charArray = this.getCharacterEncodingScheme();
        if (!(charArray == null || charArray.equals(this._encoding) || XMLStreamReaderImpl.isUTF8(charArray) && XMLStreamReaderImpl.isUTF8(this._encoding))) {
            int n = this._readCount;
            this.reset();
            this._startOffset = n;
            this.setInput(inputStream, charArray.toString());
        }
    }

    private static boolean isUTF8(Object object) {
        return object.equals("utf-8") || object.equals("UTF-8") || object.equals("ASCII") || object.equals("utf8") || object.equals("UTF8");
    }

    public void setInput(InputStream inputStream, String string) throws XMLStreamException {
        this._encoding = string;
        if (XMLStreamReaderImpl.isUTF8(string)) {
            this.setInput(this._utf8StreamReader.setInput(inputStream));
        } else {
            try {
                this.setInput(new InputStreamReader(inputStream, string));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new XMLStreamException(unsupportedEncodingException);
            }
        }
    }

    public void setInput(Reader reader) throws XMLStreamException {
        if (this._reader != null) {
            throw new IllegalStateException("Reader not closed or reset");
        }
        this._reader = reader;
        try {
            int n = reader.read(this._readBuffer, this._startOffset, this._readBuffer.length - this._startOffset);
            int n2 = this._readCount = n >= 0 ? n + this._startOffset : this._startOffset;
            if (this._readCount >= 5 && this._readBuffer[0] == '<' && this._readBuffer[1] == '?' && this._readBuffer[2] == 'x' && this._readBuffer[3] == 'm' && this._readBuffer[4] == 'l' && this._readBuffer[5] == ' ') {
                this.next();
                this._prolog = this.getPIData();
                this._start = this._index = this._prolog.offset() + this._prolog.length();
                this._eventType = 7;
            }
        }
        catch (IOException iOException) {
            throw new XMLStreamException(iOException);
        }
    }

    public int getDepth() {
        return this._depth;
    }

    public CharArray getQName() {
        if (this._eventType != 1 && this._eventType != 2) {
            throw new IllegalStateException("Not a start element or an end element");
        }
        return this._qName;
    }

    public Attributes getAttributes() {
        if (this._eventType != 1) {
            throw new IllegalStateException("Not a start element");
        }
        return this._attributes;
    }

    public void setEntities(Map map) {
        this._entities.setEntitiesMapping(map);
    }

    public String toString() {
        return "XMLStreamReader - State: " + NAMES_OF_EVENTS[this._eventType] + ", Location: " + this._location.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int next() throws XMLStreamException {
        if (this._eventType == 1) {
            this._attributes.reset();
            if (this._isEmpty) {
                this._isEmpty = false;
                this._eventType = 2;
                return 2;
            }
        } else if (this._eventType == 2) {
            this._namespaces.pop();
            CharArray charArray = this._elemStack[this._depth--];
            this._start = this._index = charArray.offset();
            while (this._seqs[--this._seqsIndex] != charArray) {
            }
        }
        block20: while (true) {
            char c;
            if (this._readIndex >= this._readCount && this.isEndOfStream()) {
                return this._eventType;
            }
            if ((c = this._readBuffer[this._readIndex++]) <= '&') {
                c = c == '&' ? this.replaceEntity() : (c < ' ' ? this.handleEndOfLine(c) : c);
            }
            this._data[this._index++] = c;
            switch (this._state) {
                case 1: {
                    int n;
                    while (true) {
                        if (c == '<') {
                            n = this._index - this._start - 1;
                            if (n > 0) {
                                if (this._charactersPending) {
                                    this._text.setArray(this._data, this._text.offset(), this._text.length() + n);
                                } else {
                                    this._text = this.newSeq(this._start, n);
                                    this._charactersPending = true;
                                }
                                this._start = this._index - 1;
                            }
                            this._state = 2;
                            continue block20;
                        }
                        if (this._readIndex >= this._readCount && this.isEndOfStream()) {
                            return this._eventType;
                        }
                        if ((c = this._readBuffer[this._readIndex++]) <= '&') {
                            c = c == '&' ? this.replaceEntity() : (c < ' ' ? this.handleEndOfLine(c) : c);
                        }
                        this._data[this._index++] = c;
                    }
                }
                case 5: {
                    int n;
                    while (true) {
                        if (c == '>' && this._index - this._start >= 3 && this._data[this._index - 2] == ']' && this._data[this._index - 3] == ']') {
                            this._index -= 3;
                            n = this._index - this._start;
                            if (n > 0) {
                                if (this._charactersPending) {
                                    this._text.setArray(this._data, this._text.offset(), this._text.length() + n);
                                } else {
                                    this._text = this.newSeq(this._start, n);
                                    this._charactersPending = true;
                                }
                            }
                            this._start = this._index;
                            this._state = 1;
                            continue block20;
                        }
                        if (this._readIndex >= this._readCount) {
                            this.reloadBuffer();
                        }
                        if ((c = this._readBuffer[this._readIndex++]) < ' ') {
                            c = this.handleEndOfLine(c);
                        }
                        this._data[this._index++] = c;
                    }
                }
                case 16: {
                    if (c == '>') {
                        this._text = this.newSeq(this._start, this._index - this._start);
                        this._index = this._start;
                        this._state = 1;
                        this._eventType = 11;
                        return 11;
                    }
                    if (c != '[') continue block20;
                    this._state = 17;
                    continue block20;
                }
                case 17: {
                    if (c != ']') continue block20;
                    this._state = 16;
                    continue block20;
                }
                case 2: {
                    if (this._index - this._start == 2) {
                        if (c == '/') {
                            this._start = this._index -= 2;
                            this._state = 14;
                            this._prefixSep = -1;
                            if (!this._charactersPending) continue block20;
                            this._charactersPending = false;
                            this._eventType = 4;
                            return 4;
                        }
                        if (c == '?') {
                            this._start = this._index -= 2;
                            this._state = 4;
                            if (!this._charactersPending) continue block20;
                            this._charactersPending = false;
                            this._eventType = 4;
                            return 4;
                        }
                        if (c == '!') continue block20;
                        this._data[this._start] = c;
                        this._index = this._start + 1;
                        this._state = 6;
                        this._prefixSep = -1;
                        if (!this._charactersPending) continue block20;
                        this._charactersPending = false;
                        this._eventType = 4;
                        return 4;
                    }
                    if (this._index - this._start == 4 && this._data[this._start + 1] == '!' && this._data[this._start + 2] == '-' && this._data[this._start + 3] == '-') {
                        this._start = this._index -= 4;
                        this._state = 3;
                        if (!this._charactersPending) continue block20;
                        this._charactersPending = false;
                        this._eventType = 4;
                        return 4;
                    }
                    if (this._index - this._start == 9 && this._data[this._start + 1] == '!' && this._data[this._start + 2] == '[' && this._data[this._start + 3] == 'C' && this._data[this._start + 4] == 'D' && this._data[this._start + 5] == 'A' && this._data[this._start + 6] == 'T' && this._data[this._start + 7] == 'A' && this._data[this._start + 8] == '[') {
                        this._start = this._index -= 9;
                        this._state = 5;
                        continue block20;
                    }
                    if (this._index - this._start != 9 || this._data[this._start + 1] != '!' || this._data[this._start + 2] != 'D' || this._data[this._start + 3] != 'O' || this._data[this._start + 4] != 'C' || this._data[this._start + 5] != 'T' || this._data[this._start + 6] != 'Y' || this._data[this._start + 7] != 'P' || this._data[this._start + 8] != 'E') continue block20;
                    this._state = 16;
                    continue block20;
                }
                case 3: {
                    while (true) {
                        if (c == '>' && this._index - this._start >= 3 && this._data[this._index - 2] == '-' && this._data[this._index - 3] == '-') {
                            this._index -= 3;
                            this._text = this.newSeq(this._start, this._index - this._start);
                            this._state = 1;
                            this._index = this._start;
                            this._eventType = 5;
                            return 5;
                        }
                        if (this._readIndex >= this._readCount) {
                            this.reloadBuffer();
                        }
                        if ((c = this._readBuffer[this._readIndex++]) < ' ') {
                            c = this.handleEndOfLine(c);
                        }
                        this._data[this._index++] = c;
                    }
                }
                case 4: {
                    if (c != '>' || this._index - this._start < 2 || this._data[this._index - 2] != '?') continue block20;
                    this._index -= 2;
                    this._text = this.newSeq(this._start, this._index - this._start);
                    this._state = 1;
                    this._index = this._start;
                    this._eventType = 3;
                    return 3;
                }
                case 6: {
                    while (true) {
                        if (c < '@') {
                            if (c == '>') {
                                this._qName = this.newSeq(this._start, --this._index - this._start);
                                this._start = this._index;
                                this._state = 1;
                                this.processStartTag();
                                this._isEmpty = false;
                                this._eventType = 1;
                                return 1;
                            }
                            if (c == '/') {
                                this._qName = this.newSeq(this._start, --this._index - this._start);
                                this._start = this._index;
                                this._state = 13;
                                continue block20;
                            }
                            if (c == ':') {
                                this._prefixSep = this._index - 1;
                            } else if (c <= ' ') {
                                this._qName = this.newSeq(this._start, --this._index - this._start);
                                this._state = 7;
                                continue block20;
                            }
                        }
                        if (this._readIndex >= this._readCount) {
                            this.reloadBuffer();
                        }
                        char c2 = this._readBuffer[this._readIndex++];
                        this._data[this._index++] = c2;
                        c = c2;
                    }
                }
                case 7: {
                    if (c == '>') {
                        this._start = --this._index;
                        this._state = 1;
                        this.processStartTag();
                        this._isEmpty = false;
                        this._eventType = 1;
                        return 1;
                    }
                    if (c == '/') {
                        this._state = 13;
                        continue block20;
                    }
                    if (c <= ' ') continue block20;
                    this._start = this._index - 1;
                    this._attrPrefixSep = -1;
                    this._state = 8;
                    continue block20;
                }
                case 8: {
                    while (true) {
                        if (c < '@') {
                            if (c <= ' ') {
                                this._attrQName = this.newSeq(this._start, --this._index - this._start);
                                this._state = 9;
                                continue block20;
                            }
                            if (c == '=') {
                                this._attrQName = this.newSeq(this._start, --this._index - this._start);
                                this._state = 10;
                                continue block20;
                            }
                            if (c == ':') {
                                this._attrPrefixSep = this._index - 1;
                            }
                        }
                        if (this._readIndex >= this._readCount) {
                            this.reloadBuffer();
                        }
                        this._data[this._index++] = c = this._readBuffer[this._readIndex++];
                    }
                }
                case 9: {
                    if (c == '=') {
                        --this._index;
                        this._state = 10;
                        continue block20;
                    }
                    if (c <= ' ') continue block20;
                    throw new XMLStreamException("'=' expected", this._location);
                }
                case 10: {
                    if (c == '\'') {
                        this._start = --this._index;
                        this._state = 11;
                        continue block20;
                    }
                    if (c == '\"') {
                        this._start = --this._index;
                        this._state = 12;
                        continue block20;
                    }
                    if (c <= ' ') continue block20;
                    throw new XMLStreamException("Quotes expected", this._location);
                }
                case 11: {
                    while (true) {
                        if (c == '\'') {
                            this._attrValue = this.newSeq(this._start, --this._index - this._start);
                            this.processAttribute();
                            this._state = 7;
                            continue block20;
                        }
                        if (this._readIndex >= this._readCount) {
                            this.reloadBuffer();
                        }
                        if ((c = this._readBuffer[this._readIndex++]) == '&') {
                            c = this.replaceEntity();
                        }
                        this._data[this._index++] = c;
                    }
                }
                case 12: {
                    while (true) {
                        if (c == '\"') {
                            this._attrValue = this.newSeq(this._start, --this._index - this._start);
                            this.processAttribute();
                            this._state = 7;
                            continue block20;
                        }
                        if (this._readIndex >= this._readCount) {
                            this.reloadBuffer();
                        }
                        if ((c = this._readBuffer[this._readIndex++]) == '&') {
                            c = this.replaceEntity();
                        }
                        this._data[this._index++] = c;
                    }
                }
                case 13: {
                    if (c != '>') throw new XMLStreamException("'>' expected", this._location);
                    this._start = --this._index;
                    this._state = 1;
                    this.processStartTag();
                    this._isEmpty = true;
                    this._eventType = 1;
                    return 1;
                }
                case 14: {
                    while (true) {
                        if (c < '@') {
                            if (c == '>') {
                                this._qName = this.newSeq(this._start, --this._index - this._start);
                                this._start = this._index;
                                this._state = 1;
                                this.processEndTag();
                                this._eventType = 2;
                                return 2;
                            }
                            if (c == ':') {
                                this._prefixSep = this._index - 1;
                            } else if (c <= ' ') {
                                this._qName = this.newSeq(this._start, --this._index - this._start);
                                this._state = 15;
                                continue block20;
                            }
                        }
                        if (this._readIndex >= this._readCount) {
                            this.reloadBuffer();
                        }
                        char c3 = this._readBuffer[this._readIndex++];
                        this._data[this._index++] = c3;
                        c = c3;
                    }
                }
                case 15: {
                    if (c == '>') {
                        this._start = --this._index;
                        this._state = 1;
                        this.processEndTag();
                        this._eventType = 2;
                        return 2;
                    }
                    if (c > ' ') throw new XMLStreamException("'>' expected", this._location);
                    continue block20;
                }
            }
            break;
        }
        throw new XMLStreamException("State unknown: " + this._state, this._location);
    }

    private void reloadBuffer() throws XMLStreamException {
        this._location._column += this._readIndex;
        this._location._charactersRead += this._readIndex;
        this._readIndex = 0;
        try {
            this._readCount = this._reader.read(this._readBuffer, 0, this._readBuffer.length);
            if (this._readCount <= 0 && (this._depth != 0 || this._state != 1)) {
                throw new XMLStreamException("Unexpected end of document", this._location);
            }
        }
        catch (IOException iOException) {
            throw new XMLStreamException(iOException);
        }
        while (this._index + this._readCount >= this._data.length) {
            this.increaseDataBuffer();
        }
    }

    private boolean isEndOfStream() throws XMLStreamException {
        if (this._readIndex >= this._readCount) {
            this.reloadBuffer();
        }
        if (this._readCount <= 0) {
            if (this._eventType == 8) {
                throw new XMLStreamException("End document has already been reached");
            }
            int n = this._index - this._start;
            if (n > 0) {
                if (this._charactersPending) {
                    this._text.setArray(this._data, this._text.offset(), this._text.length() + n);
                } else {
                    this._text = this.newSeq(this._start, n);
                }
                this._start = this._index;
                this._eventType = 4;
            } else {
                this._eventType = 8;
            }
            return true;
        }
        return false;
    }

    private char handleEndOfLine(char c) throws XMLStreamException {
        if (c == '\r') {
            if (this._readIndex >= this._readCount) {
                this.reloadBuffer();
            }
            if (this._readIndex < this._readCount && this._readBuffer[this._readIndex] == '\n') {
                ++this._readIndex;
            }
            c = (char)10;
        }
        if (c == '\n') {
            ++this._location._line;
            this._location._column = -this._readIndex;
        } else if (c == '\u0000') {
            throw new XMLStreamException("Illegal XML character U+0000", this._location);
        }
        return c;
    }

    private char replaceEntity() throws XMLStreamException {
        char c;
        int n;
        int n2;
        block5: {
            if (this._state == 3 || this._state == 4 || this._state == 5) {
                return '&';
            }
            n2 = this._index;
            this._data[this._index++] = 38;
            do {
                if (this._readIndex >= this._readCount) {
                    this.reloadBuffer();
                }
                if ((n = (this._data[this._index++] = this._readBuffer[this._readIndex++])) == 59) break block5;
            } while (n > 32);
            throw new XMLStreamException("';' expected", this._location);
        }
        while (n2 + this._entities.getMaxLength() >= this._data.length) {
            this.increaseDataBuffer();
        }
        n = this._entities.replaceEntity(this._data, n2, this._index - n2);
        this._index = n2 + n;
        if (this._readIndex >= this._readCount) {
            this.reloadBuffer();
        }
        return (c = this._readBuffer[this._readIndex++]) == '&' ? (c = this.replaceEntity()) : c;
    }

    private void processAttribute() throws XMLStreamException {
        if (this._attrPrefixSep < 0) {
            if (XMLStreamReaderImpl.isXMLNS(this._attrQName)) {
                this._namespaces.setPrefix(this._namespaces._defaultNsPrefix, this._attrValue);
            } else {
                this._attributes.addAttribute(this._attrQName, null, this._attrQName, this._attrValue);
            }
        } else {
            int n = this._attrQName.offset();
            int n2 = this._attrQName.length();
            CharArray charArray = this.newSeq(n, this._attrPrefixSep - n);
            CharArray charArray2 = this.newSeq(this._attrPrefixSep + 1, n + n2 - this._attrPrefixSep - 1);
            if (XMLStreamReaderImpl.isXMLNS(charArray)) {
                this._namespaces.setPrefix(charArray2, this._attrValue);
            } else {
                this._attributes.addAttribute(charArray2, charArray, this._attrQName, this._attrValue);
            }
        }
    }

    private static boolean isXMLNS(CharArray charArray) {
        return charArray.length() == 5 && charArray.charAt(0) == 'x' && charArray.charAt(1) == 'm' && charArray.charAt(2) == 'l' && charArray.charAt(3) == 'n' && charArray.charAt(4) == 's';
    }

    private void processEndTag() throws XMLStreamException {
        if (!this._qName.equals(this._elemStack[this._depth])) {
            throw new XMLStreamException("Unexpected end tag for " + this._qName, this._location);
        }
    }

    private void processStartTag() throws XMLStreamException {
        if (++this._depth >= this._elemStack.length) {
            this.increaseStack();
        }
        this._elemStack[this._depth] = this._qName;
        this._namespaces.push();
    }

    public void reset() {
        this._attributes.reset();
        this._attrPrefixSep = 0;
        this._attrQName = null;
        this._attrValue = null;
        this._attrQName = null;
        this._charactersPending = false;
        this._encoding = null;
        this._entities.reset();
        this._eventType = 7;
        this._index = 0;
        this._isEmpty = false;
        this._location.reset();
        this._namespaces.reset();
        this._objectFactory = null;
        this._prolog = null;
        this._readCount = 0;
        this._reader = null;
        this._depth = 0;
        this._readIndex = 0;
        this._seqsIndex = 0;
        this._start = 0;
        this._startOffset = 0;
        this._state = 1;
        this._utf8StreamReader.reset();
    }

    private CharArray newSeq(int n, int n2) {
        CharArray charArray = this._seqsIndex < this._seqsCapacity ? this._seqs[this._seqsIndex++] : this.newSeq2();
        return charArray.setArray(this._data, n, n2);
    }

    private CharArray newSeq2() {
        MemoryArea.getMemoryArea(this).executeInArea(this._createSeqLogic);
        return this._seqs[this._seqsIndex++];
    }

    private void increaseDataBuffer() {
        MemoryArea.getMemoryArea(this).executeInArea(new Runnable(){

            public void run() {
                char[] cArray = new char[XMLStreamReaderImpl.this._data.length * 2];
                LogContext.info(new CharArray("XMLStreamReaderImpl: Data buffer increased to " + cArray.length));
                System.arraycopy(XMLStreamReaderImpl.this._data, 0, cArray, 0, XMLStreamReaderImpl.this._data.length);
                XMLStreamReaderImpl.access$302(XMLStreamReaderImpl.this, cArray);
            }
        });
    }

    private void increaseStack() {
        MemoryArea.getMemoryArea(this).executeInArea(new Runnable(){

            public void run() {
                CharArray[] charArrayArray = new CharArray[XMLStreamReaderImpl.this._elemStack.length * 2];
                LogContext.info(new CharArray("XMLStreamReaderImpl: CharArray stack increased to " + charArrayArray.length));
                System.arraycopy(XMLStreamReaderImpl.this._elemStack, 0, charArrayArray, 0, XMLStreamReaderImpl.this._elemStack.length);
                XMLStreamReaderImpl.access$402(XMLStreamReaderImpl.this, charArrayArray);
            }
        });
    }

    public void require(int n, CharSequence charSequence, CharSequence charSequence2) throws XMLStreamException {
        if (this._eventType != n) {
            throw new XMLStreamException("Expected event: " + NAMES_OF_EVENTS[n] + ", found event: " + NAMES_OF_EVENTS[this._eventType]);
        }
        if (charSequence != null && !this.getNamespaceURI().equals((Object)charSequence)) {
            throw new XMLStreamException("Expected namespace URI: " + charSequence + ", found: " + this.getNamespaceURI());
        }
        if (charSequence2 != null && !this.getLocalName().equals((Object)charSequence2)) {
            throw new XMLStreamException("Expected local name: " + charSequence2 + ", found: " + this.getLocalName());
        }
    }

    public CharArray getElementText() throws XMLStreamException {
        if (this.getEventType() != 1) {
            throw new XMLStreamException("Parser must be on START_ELEMENT to read next text", this.getLocation());
        }
        CharArray charArray = null;
        int n = this.next();
        while (n != 2) {
            if (n == 4) {
                if (charArray == null) {
                    charArray = this.getText();
                } else {
                    charArray.setArray(this._data, charArray.offset(), charArray.length() + this.getText().length());
                }
            } else if (n != 3 && n != 5) {
                if (n == 8) {
                    throw new XMLStreamException("Unexpected end of document when reading element text content", this.getLocation());
                }
                if (n == 1) {
                    throw new XMLStreamException("Element text content may not contain START_ELEMENT", this.getLocation());
                }
                throw new XMLStreamException("Unexpected event type " + NAMES_OF_EVENTS[n], this.getLocation());
            }
            n = this.next();
        }
        return charArray != null ? charArray : this.newSeq(0, 0);
    }

    public Object getProperty(String string) throws IllegalArgumentException {
        if (string.equals("javolution.xml.stream.isCoalescing")) {
            return new Boolean(true);
        }
        if (string.equals("javolution.xml.stream.entities")) {
            return this._entities.getEntitiesMapping();
        }
        throw new IllegalArgumentException("Property: " + string + " not supported");
    }

    public void close() throws XMLStreamException {
        if (this._objectFactory != null) {
            this._objectFactory.recycle(this);
        } else {
            this.reset();
        }
    }

    public int getAttributeCount() {
        if (this._eventType != 1) {
            throw this.illegalState("Not a start element");
        }
        return this._attributes.getLength();
    }

    public CharArray getAttributeLocalName(int n) {
        if (this._eventType != 1) {
            throw this.illegalState("Not a start element");
        }
        return this._attributes.getLocalName(n);
    }

    public CharArray getAttributeNamespace(int n) {
        if (this._eventType != 1) {
            throw this.illegalState("Not a start element");
        }
        CharArray charArray = this._attributes.getPrefix(n);
        return this._namespaces.getNamespaceURINullAllowed(charArray);
    }

    public CharArray getAttributePrefix(int n) {
        if (this._eventType != 1) {
            throw this.illegalState("Not a start element");
        }
        return this._attributes.getPrefix(n);
    }

    public CharArray getAttributeType(int n) {
        if (this._eventType != 1) {
            throw this.illegalState("Not a start element");
        }
        return this._attributes.getType(n);
    }

    public CharArray getAttributeValue(CharSequence charSequence, CharSequence charSequence2) {
        if (this._eventType != 1) {
            throw this.illegalState("Not a start element");
        }
        return charSequence == null ? this._attributes.getValue(charSequence2) : this._attributes.getValue(charSequence, charSequence2);
    }

    public CharArray getAttributeValue(int n) {
        if (this._eventType != 1) {
            throw this.illegalState("Not a start element");
        }
        return this._attributes.getValue(n);
    }

    public CharArray getCharacterEncodingScheme() {
        return this.readPrologAttribute(ENCODING);
    }

    public String getEncoding() {
        return this._encoding;
    }

    public int getEventType() {
        return this._eventType;
    }

    public CharArray getLocalName() {
        if (this._eventType != 1 && this._eventType != 2) {
            throw this.illegalState("Not a start or end element");
        }
        if (this._prefixSep < 0) {
            return this._qName;
        }
        CharArray charArray = this.newSeq(this._prefixSep + 1, this._qName.offset() + this._qName.length() - this._prefixSep - 1);
        return charArray;
    }

    public Location getLocation() {
        return this._location;
    }

    public int getNamespaceCount() {
        if (this._eventType != 1 && this._eventType != 2) {
            throw this.illegalState("Not a start or end element");
        }
        return this._namespaces._namespacesCount[this._depth];
    }

    public CharArray getNamespacePrefix(int n) {
        if (this._eventType != 1 && this._eventType != 2) {
            throw this.illegalState("Not a start or end element");
        }
        return this._namespaces._prefixes[n];
    }

    public CharArray getNamespaceURI(CharSequence charSequence) {
        if (this._eventType != 1 && this._eventType != 2) {
            throw this.illegalState("Not a start or end element");
        }
        return this._namespaces.getNamespaceURI(charSequence);
    }

    public CharArray getNamespaceURI(int n) {
        if (this._eventType != 1 && this._eventType != 2) {
            throw this.illegalState("Not a start or end element");
        }
        return this._namespaces._namespaces[n];
    }

    public NamespaceContext getNamespaceContext() {
        return this._namespaces;
    }

    public CharArray getNamespaceURI() {
        return this._namespaces.getNamespaceURINullAllowed(this.getPrefix());
    }

    public CharArray getPrefix() {
        if (this._eventType != 1 && this._eventType != 2) {
            throw this.illegalState("Not a start or end element");
        }
        if (this._prefixSep < 0) {
            return null;
        }
        int n = this._qName.offset();
        CharArray charArray = this.newSeq(n, this._prefixSep - n);
        return charArray;
    }

    public CharArray getPIData() {
        if (this._eventType != 3) {
            throw this.illegalState("Not a processing instruction");
        }
        int n = this._text.offsetOf(' ') + 1;
        CharArray charArray = this.newSeq(n, this._text.length() - n);
        return charArray;
    }

    public CharArray getPITarget() {
        if (this._eventType != 3) {
            throw this.illegalState("Not a processing instruction");
        }
        CharArray charArray = this.newSeq(this._text.offset(), this._text.offsetOf(' '));
        return charArray;
    }

    public CharArray getText() {
        if (this._eventType != 4 && this._eventType != 5 && this._eventType != 11) {
            throw this.illegalState("Not a text event");
        }
        return this._text;
    }

    public char[] getTextCharacters() {
        return this.getText().array();
    }

    public int getTextCharacters(int n, char[] cArray, int n2, int n3) throws XMLStreamException {
        CharArray charArray = this.getText();
        int n4 = Math.min(n3, charArray.length());
        System.arraycopy(charArray.array(), n + charArray.offset(), cArray, n2, n4);
        return n4;
    }

    public int getTextLength() {
        return this.getText().length();
    }

    public int getTextStart() {
        return this.getText().offset();
    }

    public CharArray getVersion() {
        return this.readPrologAttribute(VERSION);
    }

    public boolean isStandalone() {
        CharArray charArray = this.readPrologAttribute(STANDALONE);
        return charArray != null ? charArray.equals("no") : true;
    }

    public boolean standaloneSet() {
        return this.readPrologAttribute(STANDALONE) != null;
    }

    public boolean hasName() {
        return this._eventType == 1 || this._eventType == 2;
    }

    public boolean hasNext() throws XMLStreamException {
        return this._eventType != 8;
    }

    public boolean hasText() {
        return (this._eventType == 4 || this._eventType == 5 || this._eventType == 11) && this._text.length() > 0;
    }

    public boolean isAttributeSpecified(int n) {
        if (this._eventType != 1) {
            throw new IllegalStateException("Not a start element");
        }
        return this._attributes.getValue(n) != null;
    }

    public boolean isCharacters() {
        return this._eventType == 4;
    }

    public boolean isEndElement() {
        return this._eventType == 2;
    }

    public boolean isStartElement() {
        return this._eventType == 1;
    }

    public boolean isWhiteSpace() {
        if (this.isCharacters()) {
            char[] cArray = this._text.array();
            int n = this._text.offset();
            int n2 = this._text.offset() + this._text.length();
            while (n < n2) {
                if (XMLStreamReaderImpl.isWhiteSpace(cArray[n++])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static boolean isWhiteSpace(char c) {
        return c == ' ' || c == '\t' || c == '\r' || c == '\n';
    }

    public int nextTag() throws XMLStreamException {
        int n = this.next();
        while (n == 5 || n == 3 || n == 11 || n == 4 && this.isWhiteSpace()) {
            n = this.next();
        }
        if (n != 1 && n != 2) {
            throw new XMLStreamException("Tag expected (but found " + NAMES_OF_EVENTS[this._eventType] + ")");
        }
        return n;
    }

    private IllegalStateException illegalState(String string) {
        return new IllegalStateException(string + " (" + NAMES_OF_EVENTS[this._eventType] + ")");
    }

    private String detectEncoding(InputStream inputStream) throws XMLStreamException {
        int n;
        int n2;
        try {
            n2 = inputStream.read();
        }
        catch (IOException iOException) {
            throw new XMLStreamException(iOException);
        }
        if (n2 == -1) {
            throw new XMLStreamException("Premature End-Of-File");
        }
        if (n2 == 60) {
            this._readBuffer[this._startOffset++] = 60;
            return "UTF-8";
        }
        try {
            n = inputStream.read();
        }
        catch (IOException iOException) {
            throw new XMLStreamException(iOException);
        }
        if (n == -1) {
            throw new XMLStreamException("Premature End-Of-File");
        }
        if (n2 == 0 && n == 60) {
            this._readBuffer[this._startOffset++] = 60;
            return "UTF-16BE";
        }
        if (n2 == 60 && n == 0) {
            this._readBuffer[this._startOffset++] = 60;
            return "UTF-16LE";
        }
        if (n2 == 255 && n == 254) {
            return "UTF-16";
        }
        if (n2 == 254 && n == 255) {
            return "UTF-16";
        }
        this._readBuffer[this._startOffset++] = (char)n2;
        this._readBuffer[this._startOffset++] = (char)n;
        return "UTF-8";
    }

    private final CharArray readPrologAttribute(CharSequence charSequence) {
        if (this._prolog == null) {
            return null;
        }
        int n = this._prolog.offsetOf(charSequence);
        if (n >= 0) {
            int n2 = this._prolog.offset() + this._prolog.length();
            n += charSequence.length();
            int n3 = 0;
            int n4 = 0;
            while (n < n2) {
                char c = this._prolog.array()[n++];
                switch (n3) {
                    case 0: {
                        if (c != '=') break;
                        n3 = 1;
                        break;
                    }
                    case 1: {
                        if (c == '\"') {
                            n3 = 3;
                            n4 = n;
                            break;
                        }
                        if (c != '\'') break;
                        n3 = 2;
                        n4 = n;
                        break;
                    }
                    case 2: {
                        if (c != '\'') break;
                        return this.newSeq(n4, n - n4 - 1);
                    }
                    case 3: {
                        if (c != '\"') break;
                        return this.newSeq(n4, n - n4 - 1);
                    }
                }
            }
        }
        return null;
    }

    static /* synthetic */ CharArray[] access$202(XMLStreamReaderImpl xMLStreamReaderImpl, CharArray[] charArrayArray) {
        xMLStreamReaderImpl._seqs = charArrayArray;
        return charArrayArray;
    }

    static /* synthetic */ char[] access$302(XMLStreamReaderImpl xMLStreamReaderImpl, char[] cArray) {
        xMLStreamReaderImpl._data = cArray;
        return cArray;
    }

    static /* synthetic */ CharArray[] access$402(XMLStreamReaderImpl xMLStreamReaderImpl, CharArray[] charArrayArray) {
        xMLStreamReaderImpl._elemStack = charArrayArray;
        return charArrayArray;
    }

    private final class LocationImpl
    implements Location,
    Reusable {
        int _column;
        int _line;
        int _charactersRead;

        private LocationImpl() {
        }

        public int getLineNumber() {
            return this._line + 1;
        }

        public int getColumnNumber() {
            return this._column + XMLStreamReaderImpl.this._readIndex;
        }

        public int getCharacterOffset() {
            return this._charactersRead + XMLStreamReaderImpl.this._readIndex;
        }

        public String getPublicId() {
            return null;
        }

        public String getSystemId() {
            return null;
        }

        public String toString() {
            return "Line " + this.getLineNumber() + ", Column " + this.getColumnNumber();
        }

        public void reset() {
            this._line = 0;
            this._column = 0;
            this._charactersRead = 0;
        }
    }
}

