/*
 * Decompiled with CFR 0.152.
 */
package javolution.context;

import javolution.context.Allocator;
import javolution.context.AllocatorContext;
import javolution.util.FastMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ObjectFactory<T> {
    private boolean _doCleanup = true;
    private Allocator<T> _allocator = NULL_ALLOCATOR;
    private static final Allocator NULL_ALLOCATOR = new Allocator(){

        protected Object allocate() {
            return null;
        }

        protected void recycle(Object object) {
        }
    };
    private ThreadLocal _localAllocator = new ThreadLocal(){

        protected Object initialValue() {
            return NULL_ALLOCATOR;
        }
    };

    protected ObjectFactory() {
    }

    public static <T> ObjectFactory<T> getInstance(Class<T> clazz) {
        ObjectFactory<T> objectFactory = (ObjectFactory<T>)Generic.CLASS_TO_FACTORY.get(clazz);
        return objectFactory != null ? objectFactory : Generic.newInstance(clazz);
    }

    public static <T> void setInstance(ObjectFactory<T> objectFactory, Class<T> clazz) {
        Generic.CLASS_TO_FACTORY.put(clazz, objectFactory);
    }

    public final T object() {
        Allocator<T> allocator = this._allocator;
        return allocator.user == Thread.currentThread() ? allocator.next() : this.currentAllocator().next();
    }

    public final void recycle(T t) {
        this.currentAllocator().recycle(t);
    }

    public final Allocator<T> currentAllocator() {
        Allocator allocator = (Allocator)this._localAllocator.get();
        if (allocator.user != null) {
            this._allocator = allocator;
            return this._allocator;
        }
        allocator = AllocatorContext.getCurrent().getAllocator(this);
        this._localAllocator.set(allocator);
        this._allocator = allocator;
        return allocator;
    }

    protected abstract T create();

    protected void cleanup(T t) {
        this._doCleanup = false;
    }

    protected final boolean doCleanup() {
        return this._doCleanup;
    }

    private static class Generic
    extends ObjectFactory {
        private static final FastMap CLASS_TO_FACTORY = new FastMap().setShared(true);
        private final Class _class;

        private Generic(Class clazz) {
            this._class = clazz;
        }

        private static Generic newInstance(Class clazz) {
            Generic generic = new Generic(clazz);
            CLASS_TO_FACTORY.put(clazz, generic);
            return generic;
        }

        protected Object create() {
            try {
                return this._class.newInstance();
            }
            catch (InstantiationException instantiationException) {
                throw new Error("Cannot instantiate no-arg constructor for " + this._class.getName() + ", the factory should be set explicitly using ObjectFactory.setInstance");
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new Error("Cannot access no-arg constructor for " + this._class.getName() + ", the factory should be set explicitly using ObjectFactory.setInstance");
            }
        }
    }
}

