/*
 * Decompiled with CFR 0.152.
 */
package com.datumbox.framework.core.statistics.sampling;

import com.datumbox.framework.common.dataobjects.FlatDataCollection;
import com.datumbox.framework.common.dataobjects.FlatDataList;
import com.datumbox.framework.core.common.utilities.PHPMethods;
import com.datumbox.framework.core.statistics.sampling.SimpleRandomSampling;
import java.util.Iterator;

public class SystematicSampling {
    public static FlatDataCollection randomSampling(FlatDataList idList, int n, boolean randomizeRecords) {
        int randomSystematic;
        int k;
        FlatDataList sampledIds = new FlatDataList();
        int populationN = idList.size();
        Object[] keys = idList.toArray();
        if (randomizeRecords) {
            PHPMethods.shuffle(keys);
        }
        if ((k = populationN / n) < 2) {
            throw new IllegalArgumentException("The number of systematics is too small.");
        }
        for (int i = randomSystematic = PHPMethods.mt_rand(0, k - 1); i < keys.length; i += k) {
            Object pointID = keys[i];
            sampledIds.add(pointID);
        }
        return sampledIds.toFlatDataCollection();
    }

    public static double mean(FlatDataCollection flatDataCollection) {
        return SimpleRandomSampling.mean(flatDataCollection);
    }

    public static double xbarVariance(FlatDataCollection flatDataCollection) {
        double n = flatDataCollection.size();
        if (n <= 1.0) {
            throw new IllegalArgumentException("The provided collection must have more than 1 elements.");
        }
        Double previousValue = null;
        double xbarVariance = 0.0;
        Iterator<Double> it = flatDataCollection.iteratorDouble();
        while (it.hasNext()) {
            Double yi = it.next();
            if (previousValue != null) {
                double delta = yi - previousValue;
                xbarVariance += delta * delta;
            }
            previousValue = yi;
        }
        return xbarVariance /= 2.0 * n * (n - 1.0);
    }

    public static double xbarStd(FlatDataCollection flatDataCollection) {
        return Math.sqrt(SystematicSampling.xbarVariance(flatDataCollection));
    }
}

