/*
 * Decompiled with CFR 0.152.
 */
package com.datumbox.framework.core.statistics.sampling;

import com.datumbox.framework.common.dataobjects.AssociativeArray;
import com.datumbox.framework.common.dataobjects.FlatDataCollection;
import com.datumbox.framework.common.dataobjects.FlatDataList;
import com.datumbox.framework.common.dataobjects.TypeInference;
import com.datumbox.framework.core.common.utilities.PHPMethods;
import com.datumbox.framework.core.statistics.descriptivestatistics.Descriptives;
import com.datumbox.framework.core.statistics.distributions.ContinuousDistributions;
import java.util.Map;

public class SimpleRandomSampling {
    public static FlatDataCollection weightedSampling(AssociativeArray weightedTable, int n, boolean withReplacement) {
        FlatDataList sampledIds = new FlatDataList();
        double sumOfFrequencies = Descriptives.sum(weightedTable.toFlatDataCollection());
        int populationN = weightedTable.size();
        block0: for (int i = 0; i < n && (withReplacement || populationN > n); ++i) {
            double randomFrequency = PHPMethods.mt_rand(0.0, sumOfFrequencies);
            double cumulativeFrequency = 0.0;
            for (Map.Entry<Object, Object> entry : weightedTable.entrySet()) {
                Object pointID = entry.getKey();
                if (!((cumulativeFrequency += TypeInference.toDouble(entry.getValue()).doubleValue()) >= randomFrequency) || !withReplacement && sampledIds.contains(pointID)) continue;
                sampledIds.add(pointID);
                continue block0;
            }
        }
        return sampledIds.toFlatDataCollection();
    }

    public static FlatDataCollection randomSampling(FlatDataList idList, int n, boolean withReplacement) {
        FlatDataList sampledIds = new FlatDataList();
        int populationN = idList.size();
        int i = 0;
        while (i < n && (withReplacement || populationN > n)) {
            int randomPosition = PHPMethods.mt_rand(0, populationN - 1);
            Object pointID = idList.get(randomPosition);
            if (!withReplacement && sampledIds.contains(pointID)) continue;
            sampledIds.add(pointID);
            ++i;
        }
        return sampledIds.toFlatDataCollection();
    }

    public static double mean(FlatDataCollection flatDataCollection) {
        return Descriptives.mean(flatDataCollection);
    }

    public static double variance(FlatDataCollection flatDataCollection) {
        return Descriptives.variance(flatDataCollection, true);
    }

    public static double std(FlatDataCollection flatDataCollection) {
        return Math.sqrt(SimpleRandomSampling.variance(flatDataCollection));
    }

    public static double xbarVariance(double variance, int sampleN) {
        return SimpleRandomSampling.xbarVariance(variance, sampleN, Integer.MAX_VALUE);
    }

    public static double xbarVariance(double variance, int sampleN, int populationN) {
        if (populationN <= 0 || sampleN <= 0 || sampleN > populationN) {
            throw new IllegalArgumentException("All the parameters must be positive and sampleN smaller than populationN.");
        }
        double xbarVariance = (1.0 - (double)sampleN / (double)populationN) * variance / (double)sampleN;
        return xbarVariance;
    }

    public static double xbarStd(double std, int sampleN) {
        return Math.sqrt(SimpleRandomSampling.xbarVariance(std * std, sampleN, Integer.MAX_VALUE));
    }

    public static double xbarStd(double std, int sampleN, int populationN) {
        return Math.sqrt(SimpleRandomSampling.xbarVariance(std * std, sampleN, populationN));
    }

    public static double pbarVariance(double pbar, int sampleN) {
        return SimpleRandomSampling.pbarVariance(pbar, sampleN, Integer.MAX_VALUE);
    }

    public static double pbarVariance(double pbar, int sampleN, int populationN) {
        if (populationN <= 0 || sampleN <= 0 || sampleN > populationN) {
            throw new IllegalArgumentException("All the parameters must be positive and sampleN smaller than populationN.");
        }
        double f = (double)sampleN / (double)populationN;
        double pbarVariance = (1.0 - f) * pbar * (1.0 - pbar) / ((double)sampleN - 1.0);
        return pbarVariance;
    }

    public static double pbarStd(double pbar, int sampleN) {
        return Math.sqrt(SimpleRandomSampling.pbarVariance(pbar, sampleN, Integer.MAX_VALUE));
    }

    public static double pbarStd(double pbar, int sampleN, int populationN) {
        return Math.sqrt(SimpleRandomSampling.pbarVariance(pbar, sampleN, populationN));
    }

    public static int minimumSampleSizeForMaximumXbarStd(double maximumXbarStd, double populationStd) {
        return SimpleRandomSampling.minimumSampleSizeForMaximumXbarStd(maximumXbarStd, populationStd, Integer.MAX_VALUE);
    }

    public static int minimumSampleSizeForMaximumXbarStd(double maximumXbarStd, double populationStd, int populationN) {
        if (populationN <= 0) {
            throw new IllegalArgumentException("The populationN parameter must be positive.");
        }
        double minimumSampleN = 1.0 / (Math.pow(maximumXbarStd / populationStd, 2.0) + 1.0 / (double)populationN);
        return (int)Math.ceil(minimumSampleN);
    }

    public static int minimumSampleSizeForGivenDandMaximumRisk(double d, double aLevel, double populationStd) {
        return SimpleRandomSampling.minimumSampleSizeForGivenDandMaximumRisk(d, aLevel, populationStd, Integer.MAX_VALUE);
    }

    public static int minimumSampleSizeForGivenDandMaximumRisk(double d, double aLevel, double populationStd, int populationN) {
        if (populationN <= 0 || aLevel <= 0.0 || d <= 0.0) {
            throw new IllegalArgumentException("All the parameters must be positive.");
        }
        double a = 1.0 - aLevel / 2.0;
        double Za = ContinuousDistributions.gaussInverseCdf(a);
        double V = Math.pow(d / Za, 2.0);
        double Ssquare = populationStd * populationStd;
        double minimumSampleN = Ssquare / V * (1.0 / (1.0 + Ssquare / ((double)populationN * V)));
        return (int)Math.ceil(minimumSampleN);
    }
}

