/*
 * Decompiled with CFR 0.152.
 */
package com.datumbox.framework.core.statistics.parametrics.onesample;

import com.datumbox.framework.common.dataobjects.FlatDataList;
import com.datumbox.framework.core.statistics.distributions.ContinuousDistributions;

public class DurbinWatson {
    public static boolean test(FlatDataList errorList, int k, boolean is_twoTailed, double aLevel) {
        int n = errorList.size();
        if (n <= 0) {
            throw new IllegalArgumentException("The provided collection can't be empty.");
        }
        double DW = DurbinWatson.calculateScore(errorList);
        boolean rejectH0 = DurbinWatson.checkCriticalValue(DW, n, k, is_twoTailed, aLevel);
        return rejectH0;
    }

    public static double calculateScore(FlatDataList errorList) {
        double DWdeltasquare = 0.0;
        double DWetsquare = 0.0;
        int n = errorList.size();
        for (int i = 0; i < n; ++i) {
            Double errorPrevious;
            Double error = errorList.getDouble(i);
            if (i >= 1 && (errorPrevious = errorList.getDouble(i - 1)) != null) {
                DWdeltasquare += Math.pow(error - errorPrevious, 2.0);
            }
            DWetsquare += error * error;
        }
        double DW = DWdeltasquare / DWetsquare;
        return DW;
    }

    public static boolean checkCriticalValue(double score, int n, int k, boolean is_twoTailed, double aLevel) {
        double z = (score - 2.0) / Math.sqrt(4.0 / (double)n);
        double probability = ContinuousDistributions.gaussCdf(z);
        boolean rejectH0 = false;
        double a = aLevel;
        if (is_twoTailed) {
            a = aLevel / 2.0;
        }
        if (probability <= a || probability >= 1.0 - a) {
            rejectH0 = true;
        }
        return rejectH0;
    }
}

