/*
 * Decompiled with CFR 0.152.
 */
package com.datumbox.framework.core.statistics.parametrics.independentsamples;

import com.datumbox.framework.core.statistics.distributions.ContinuousDistributions;

public class FIndependentSamples {
    public static boolean testVariances(double stdbarx, double stdbary, int n, int m, boolean is_twoTailed, double aLevel) {
        if (n <= 1 || stdbarx <= 0.0 || m <= 1 || stdbary <= 0.0) {
            throw new IllegalArgumentException("The values of the provided parameters are not within the permitted range.");
        }
        double F = stdbarx * stdbarx / (stdbary * stdbary);
        boolean rejectH0 = FIndependentSamples.checkCriticalValue(F, n, m, is_twoTailed, aLevel);
        return rejectH0;
    }

    private static boolean checkCriticalValue(double score, int n, int m, boolean is_twoTailed, double aLevel) {
        double probability = ContinuousDistributions.fCdf(score, n - 1, m - 1);
        boolean rejectH0 = false;
        double a = aLevel;
        if (is_twoTailed) {
            a = aLevel / 2.0;
        }
        if (probability <= a || probability >= 1.0 - a) {
            rejectH0 = true;
        }
        return rejectH0;
    }
}

