/*
 * Decompiled with CFR 0.152.
 */
package com.datumbox.framework.core.statistics.nonparametrics.relatedsamples;

import com.datumbox.framework.core.statistics.distributions.ContinuousDistributions;

public class McNemar {
    public static double getPvalue(int n11, int n12, int n21, int n22) {
        double Chisquare2 = Math.pow((double)Math.abs(n12 - n21) - 0.5, 2.0) / (double)(n12 + n21);
        double pvalue = McNemar.scoreToPvalue(Chisquare2);
        return pvalue;
    }

    public static boolean test(int n11, int n12, int n21, int n22, boolean is_twoTailed, double aLevel) {
        double pvalue = McNemar.getPvalue(n11, n12, n21, n22);
        boolean rejectH0 = false;
        double a = aLevel;
        if (is_twoTailed) {
            a = aLevel / 2.0;
        }
        if (pvalue <= a || pvalue >= 1.0 - a) {
            rejectH0 = true;
        }
        return rejectH0;
    }

    private static double scoreToPvalue(double score) {
        return 1.0 - ContinuousDistributions.chisquareCdf(score, 1);
    }
}

