/*
 * Decompiled with CFR 0.152.
 */
package com.datumbox.framework.core.statistics.nonparametrics.independentsamples;

import com.datumbox.framework.core.mathematics.discrete.Arithmetics;
import java.util.HashSet;

public class Fisher {
    public static double getPvalue(int n11, int ndot1, int ndot2, int n1dot, int n2dot) {
        int originalN11 = n11;
        int n = ndot1 + ndot2;
        int min = Math.max(0, n1dot + ndot1 - n);
        int max = Math.min(n1dot, ndot1);
        HashSet<Integer> combinations = new HashSet<Integer>();
        combinations.add(originalN11);
        for (int r = min; r <= max; ++r) {
            combinations.add(r);
        }
        double standardPart = Arithmetics.factorial(n1dot) * Arithmetics.factorial(n2dot) * Arithmetics.factorial(ndot1) * Arithmetics.factorial(ndot2) / Arithmetics.factorial(n);
        double originalPvalue = 0.0;
        double Psum = 0.0;
        for (Integer r : combinations) {
            n11 = r;
            int n21 = ndot1 - n11;
            int n12 = n1dot - n11;
            int n22 = n2dot - n21;
            double pvalue = standardPart / (Arithmetics.factorial(n11) * Arithmetics.factorial(n12) * Arithmetics.factorial(n21) * Arithmetics.factorial(n22));
            if (r == originalN11) {
                originalPvalue = pvalue;
            }
            if (!(pvalue <= originalPvalue)) continue;
            Psum += pvalue;
        }
        return Psum;
    }

    public static boolean test(int n11, int n12, int n21, int n22, double aLevel) {
        int ndot1 = n11 + n21;
        int ndot2 = n12 + n22;
        int n1dot = n11 + n12;
        int n2dot = n21 + n22;
        double pvalue = Fisher.getPvalue(n11, ndot1, ndot2, n1dot, n2dot);
        boolean rejectH0 = false;
        if (pvalue <= aLevel) {
            rejectH0 = true;
        }
        return rejectH0;
    }
}

