/*
 * Decompiled with CFR 0.152.
 */
package com.datumbox.framework.core.statistics.descriptivestatistics;

import com.datumbox.framework.common.dataobjects.AssociativeArray;
import com.datumbox.framework.common.dataobjects.FlatDataList;
import com.datumbox.framework.common.dataobjects.TypeInference;
import com.datumbox.framework.core.common.utilities.MapMethods;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class Ranks {
    public static AssociativeArray getRanksFromValues(FlatDataList flatDataCollection) {
        AssociativeArray tiesCounter = new AssociativeArray();
        LinkedHashMap<Object, Double> key2AvgRank = new LinkedHashMap<Object, Double>();
        Ranks._buildRankArrays(flatDataCollection, tiesCounter, key2AvgRank);
        int i = 0;
        for (Object value : flatDataCollection) {
            flatDataCollection.set(i++, key2AvgRank.get(value));
        }
        return tiesCounter;
    }

    public static AssociativeArray getRanksFromValues(AssociativeArray associativeArray) {
        AssociativeArray tiesCounter = new AssociativeArray();
        LinkedHashMap<Object, Double> key2AvgRank = new LinkedHashMap<Object, Double>();
        Ranks._buildRankArrays(associativeArray.toFlatDataList(), tiesCounter, key2AvgRank);
        for (Map.Entry<Object, Object> entry : associativeArray.entrySet()) {
            associativeArray.put(entry.getKey(), key2AvgRank.get(entry.getValue()));
        }
        return tiesCounter;
    }

    private static void _buildRankArrays(FlatDataList flatDataCollection, AssociativeArray tiesCounter, Map<Object, Double> key2AvgRank) {
        for (Object value : flatDataCollection) {
            Object count = tiesCounter.get(value);
            if (count == null) {
                count = 0;
            }
            tiesCounter.put(value, ((Number)count).intValue() + 1);
        }
        tiesCounter.overwrite(MapMethods.sortNumberMapByKeyAscending(tiesCounter.entrySet()));
        int itemCounter = 0;
        Iterator<Map.Entry<Object, Object>> it = tiesCounter.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Object, Object> entry = it.next();
            Object key = entry.getKey();
            double count = TypeInference.toDouble(entry.getValue());
            if (count <= 1.0) {
                it.remove();
            }
            double avgRank = ((double)(itemCounter + 1) + ((double)itemCounter + count)) / 2.0;
            key2AvgRank.put(key, avgRank);
            itemCounter = (int)((double)itemCounter + count);
        }
    }
}

