/*
 * Decompiled with CFR 0.152.
 */
package com.datumbox.framework.core.statistics.descriptivestatistics;

import com.datumbox.framework.common.dataobjects.DataTable2D;
import com.datumbox.framework.common.dataobjects.TransposeDataList;
import com.datumbox.framework.common.dataobjects.TypeInference;
import com.datumbox.framework.core.common.dataobjects.Dataframe;
import com.datumbox.framework.core.statistics.descriptivestatistics.Descriptives;
import com.datumbox.framework.core.statistics.nonparametrics.relatedsamples.KendallTauCorrelation;
import com.datumbox.framework.core.statistics.nonparametrics.relatedsamples.SpearmanCorrelation;
import com.datumbox.framework.core.statistics.parametrics.relatedsamples.PearsonCorrelation;
import java.util.Map;

public class Bivariate {
    private static DataTable2D bivariateMatrix(Dataframe dataSet, BivariateType type) {
        DataTable2D bivariateMatrix = new DataTable2D();
        Map<Object, TypeInference.DataType> columnTypes = dataSet.getXDataTypes();
        Object[] allVariables = columnTypes.keySet().toArray();
        int numberOfVariables = allVariables.length;
        for (int i = 0; i < numberOfVariables; ++i) {
            Object variable0 = allVariables[i];
            if (columnTypes.get(variable0) == TypeInference.DataType.CATEGORICAL) continue;
            TransposeDataList transposeDataList = new TransposeDataList();
            transposeDataList.put(0, dataSet.getXColumn(variable0));
            for (int j = i; j < numberOfVariables; ++j) {
                Object variable1 = allVariables[j];
                if (columnTypes.get(variable1) == TypeInference.DataType.CATEGORICAL) continue;
                transposeDataList.put(1, dataSet.getXColumn(variable1));
                double value = 0.0;
                if (type == BivariateType.COVARIANCE) {
                    value = Descriptives.covariance(transposeDataList, true);
                } else if (type == BivariateType.PEARSONCORRELATION) {
                    value = variable0.equals(variable1) ? 1.0 : PearsonCorrelation.calculateCorrelation(transposeDataList);
                } else if (type == BivariateType.SPEARMANCORRELATION) {
                    value = variable0.equals(variable1) ? 1.0 : SpearmanCorrelation.calculateCorrelation(transposeDataList);
                } else if (type == BivariateType.KENDALLTAUCORRELATION) {
                    value = variable0.equals(variable1) ? 1.0 : KendallTauCorrelation.calculateCorrelation(transposeDataList);
                }
                bivariateMatrix.put2d(variable0, variable1, value);
                if (variable0.equals(variable1)) continue;
                bivariateMatrix.put2d(variable1, variable0, value);
            }
        }
        return bivariateMatrix;
    }

    public static DataTable2D covarianceMatrix(Dataframe dataSet) {
        return Bivariate.bivariateMatrix(dataSet, BivariateType.COVARIANCE);
    }

    public static DataTable2D pearsonMatrix(Dataframe dataSet) {
        return Bivariate.bivariateMatrix(dataSet, BivariateType.PEARSONCORRELATION);
    }

    public static DataTable2D spearmanMatrix(Dataframe dataSet) {
        return Bivariate.bivariateMatrix(dataSet, BivariateType.SPEARMANCORRELATION);
    }

    public static DataTable2D kendalltauMatrix(Dataframe dataSet) {
        return Bivariate.bivariateMatrix(dataSet, BivariateType.KENDALLTAUCORRELATION);
    }

    private static enum BivariateType {
        COVARIANCE,
        PEARSONCORRELATION,
        SPEARMANCORRELATION,
        KENDALLTAUCORRELATION;

    }
}

