/*
 * Decompiled with CFR 0.152.
 */
package com.datumbox.framework.core.statistics.decisiontheory;

import com.datumbox.framework.common.dataobjects.AssociativeArray;
import com.datumbox.framework.common.dataobjects.DataTable2D;
import com.datumbox.framework.common.dataobjects.TypeInference;
import com.datumbox.framework.core.common.utilities.MapMethods;
import com.datumbox.framework.core.statistics.descriptivestatistics.Descriptives;
import java.util.AbstractMap;
import java.util.Map;

public class DecisionCriteria {
    public static Map.Entry<Object, Object> maxMin(DataTable2D payoffMatrix) {
        if (!payoffMatrix.isValid()) {
            throw new IllegalArgumentException("The payoff matrix does not have a rectangular format.");
        }
        AssociativeArray minPayoffs = new AssociativeArray();
        for (Map.Entry<Object, AssociativeArray> entry : payoffMatrix.entrySet()) {
            AssociativeArray optionList = entry.getValue();
            for (Map.Entry<Object, Object> entry2 : optionList.entrySet()) {
                Object option = entry2.getKey();
                Double payoff = TypeInference.toDouble(entry2.getValue());
                Double currentMinPayoffOption = minPayoffs.getDouble(option);
                if (currentMinPayoffOption != null && !(payoff < currentMinPayoffOption)) continue;
                minPayoffs.put(option, payoff);
            }
        }
        Map.Entry<Object, Object> entry = MapMethods.selectMaxKeyValue(minPayoffs);
        return entry;
    }

    public static Map.Entry<Object, Object> maxMax(DataTable2D payoffMatrix) {
        if (!payoffMatrix.isValid()) {
            throw new IllegalArgumentException("The payoff matrix does not have a rectangular format.");
        }
        Double maxMaxPayoff = Double.NEGATIVE_INFINITY;
        Object maxMaxPayoffOption = null;
        for (Map.Entry<Object, AssociativeArray> entry : payoffMatrix.entrySet()) {
            AssociativeArray optionList = entry.getValue();
            for (Map.Entry<Object, Object> entry2 : optionList.entrySet()) {
                Double payoff = TypeInference.toDouble(entry2.getValue());
                if (!(payoff > maxMaxPayoff)) continue;
                maxMaxPayoff = payoff;
                maxMaxPayoffOption = entry2.getKey();
            }
        }
        return new AbstractMap.SimpleEntry<Object, Double>(maxMaxPayoffOption, maxMaxPayoff);
    }

    public static Map.Entry<Object, Object> savage(DataTable2D payoffMatrix) {
        if (!payoffMatrix.isValid()) {
            throw new IllegalArgumentException("The payoff matrix does not have a rectangular format.");
        }
        DataTable2D regretMatrix = new DataTable2D();
        for (Map.Entry<Object, AssociativeArray> entry : payoffMatrix.entrySet()) {
            Object event = entry.getKey();
            AssociativeArray optionList = entry.getValue();
            double maxI = Descriptives.max(optionList.toFlatDataCollection());
            for (Map.Entry<Object, Object> entry2 : optionList.entrySet()) {
                Object option = entry2.getKey();
                Double payoff = TypeInference.toDouble(entry2.getValue());
                regretMatrix.put2d(event, option, payoff - maxI);
            }
        }
        return DecisionCriteria.maxMin(regretMatrix);
    }

    public static Map.Entry<Object, Object> laplace(DataTable2D payoffMatrix) {
        if (!payoffMatrix.isValid()) {
            throw new IllegalArgumentException("The payoff matrix does not have a rectangular format.");
        }
        AssociativeArray optionAverages = new AssociativeArray();
        int numberOfEvents = payoffMatrix.size();
        for (Map.Entry<Object, AssociativeArray> entry : payoffMatrix.entrySet()) {
            AssociativeArray optionList = entry.getValue();
            for (Map.Entry<Object, Object> entry2 : optionList.entrySet()) {
                Object option = entry2.getKey();
                Double payoff = TypeInference.toDouble(entry2.getValue());
                Double value = optionAverages.getDouble(option);
                if (value == null) {
                    value = 0.0;
                }
                optionAverages.put(option, value + payoff / (double)numberOfEvents);
            }
        }
        Map.Entry<Object, Object> entry = MapMethods.selectMaxKeyValue(optionAverages);
        return entry;
    }

    public static Map.Entry<Object, Object> hurwiczAlpha(DataTable2D payoffMatrix, double alpha) {
        if (!payoffMatrix.isValid()) {
            throw new IllegalArgumentException("The payoff matrix does not have a rectangular format.");
        }
        AssociativeArray minPayoffs = new AssociativeArray();
        AssociativeArray maxPayoffs = new AssociativeArray();
        for (Map.Entry<Object, AssociativeArray> entry : payoffMatrix.entrySet()) {
            AssociativeArray associativeArray = entry.getValue();
            for (Map.Entry<Object, Object> entry22 : associativeArray.entrySet()) {
                Double currentMaxPayoffOption;
                Object option = entry22.getKey();
                Double payoff = TypeInference.toDouble(entry22.getValue());
                Double currentMinPayoffOption = minPayoffs.getDouble(option);
                if (currentMinPayoffOption == null || payoff < currentMinPayoffOption) {
                    minPayoffs.put(option, payoff);
                }
                if ((currentMaxPayoffOption = maxPayoffs.getDouble(option)) != null && !(payoff > currentMaxPayoffOption)) continue;
                maxPayoffs.put(option, payoff);
            }
        }
        AssociativeArray combinedPayoffs = new AssociativeArray();
        for (Map.Entry<Object, Object> entry : maxPayoffs.entrySet()) {
            Object option = entry.getKey();
            combinedPayoffs.put(option, TypeInference.toDouble(entry.getValue()) * alpha + minPayoffs.getDouble(option) * (1.0 - alpha));
        }
        Map.Entry<Object, Object> entry = MapMethods.selectMaxKeyValue(combinedPayoffs);
        return entry;
    }

    public static Map.Entry<Object, Object> maximumLikelihood(DataTable2D payoffMatrix, AssociativeArray eventProbabilities) {
        if (!payoffMatrix.isValid()) {
            throw new IllegalArgumentException("The payoff matrix does not have a rectangular format.");
        }
        Map.Entry<Object, Object> eventEntry = MapMethods.selectMaxKeyValue(eventProbabilities);
        Object mostProbableEvent = eventEntry.getKey();
        return MapMethods.selectMaxKeyValue(payoffMatrix.get(mostProbableEvent));
    }

    public static Map.Entry<Object, Object> bayes(DataTable2D payoffMatrix, AssociativeArray eventProbabilities) {
        if (!payoffMatrix.isValid()) {
            throw new IllegalArgumentException("The payoff matrix does not have a rectangular format.");
        }
        AssociativeArray expectedPayoffs = new AssociativeArray();
        for (Map.Entry<Object, AssociativeArray> entry : payoffMatrix.entrySet()) {
            Object event = entry.getKey();
            AssociativeArray optionList = entry.getValue();
            for (Map.Entry<Object, Object> entry2 : optionList.entrySet()) {
                Object option = entry2.getKey();
                Double payoff = TypeInference.toDouble(entry2.getValue());
                Double value = expectedPayoffs.getDouble(option);
                if (value == null) {
                    value = 0.0;
                }
                expectedPayoffs.put(option, value + payoff * eventProbabilities.getDouble(event));
            }
        }
        Map.Entry<Object, Object> entry = MapMethods.selectMaxKeyValue(expectedPayoffs);
        return entry;
    }
}

