/*
 * Decompiled with CFR 0.152.
 */
package com.datumbox.framework.core.mathematics.linearprogramming;

import com.datumbox.framework.core.common.utilities.PHPMethods;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math3.optim.OptimizationData;
import org.apache.commons.math3.optim.PointValuePair;
import org.apache.commons.math3.optim.linear.LinearConstraint;
import org.apache.commons.math3.optim.linear.LinearConstraintSet;
import org.apache.commons.math3.optim.linear.LinearObjectiveFunction;
import org.apache.commons.math3.optim.linear.NonNegativeConstraint;
import org.apache.commons.math3.optim.linear.PivotSelectionRule;
import org.apache.commons.math3.optim.linear.Relationship;
import org.apache.commons.math3.optim.linear.SimplexSolver;
import org.apache.commons.math3.optim.nonlinear.scalar.GoalType;

public class LPSolver {
    public static String GEQ = ">=";
    public static String LEQ = "<=";
    public static String EQ = "=";

    public static LPResult solve(double[] linearObjectiveFunction, List<LPConstraint> linearConstraintsList, boolean nonNegative, boolean maximize) {
        int m = linearConstraintsList.size();
        ArrayList<LinearConstraint> constraints = new ArrayList<LinearConstraint>(m);
        for (LPConstraint constraint : linearConstraintsList) {
            String sign = constraint.getSign();
            Relationship relationship = null;
            if (GEQ.equals(sign)) {
                relationship = Relationship.GEQ;
            } else if (LEQ.equals(sign)) {
                relationship = Relationship.LEQ;
            } else if (EQ.equals(sign)) {
                relationship = Relationship.EQ;
            }
            constraints.add(new LinearConstraint(constraint.getContraintBody(), relationship, constraint.getValue()));
        }
        SimplexSolver solver = new SimplexSolver();
        PointValuePair solution = solver.optimize(new OptimizationData[]{new LinearObjectiveFunction(linearObjectiveFunction, 0.0), new LinearConstraintSet(constraints), maximize ? GoalType.MAXIMIZE : GoalType.MINIMIZE, new NonNegativeConstraint(nonNegative), PivotSelectionRule.BLAND});
        LPResult result = new LPResult();
        result.setObjectiveValue((Double)solution.getValue());
        result.setVariableValues(solution.getPoint());
        return result;
    }

    public static class LPConstraint {
        private final double[] contraintBody;
        private final String sign;
        private final double value;

        public LPConstraint(double[] constraintBody, String sign, double value) {
            this.contraintBody = PHPMethods.array_clone(constraintBody);
            this.sign = sign;
            this.value = value;
        }

        public double[] getContraintBody() {
            return PHPMethods.array_clone(this.contraintBody);
        }

        public String getSign() {
            return this.sign;
        }

        public double getValue() {
            return this.value;
        }
    }

    public static class LPResult {
        private Double objectiveValue;
        private double[] variableValues;

        public Double getObjectiveValue() {
            return this.objectiveValue;
        }

        protected void setObjectiveValue(Double objectiveValue) {
            this.objectiveValue = objectiveValue;
        }

        public double[] getVariableValues() {
            return PHPMethods.array_clone(this.variableValues);
        }

        protected void setVariableValues(double[] variableValues) {
            this.variableValues = PHPMethods.array_clone(variableValues);
        }
    }
}

