/*
 * Decompiled with CFR 0.152.
 */
package com.datumbox.framework.core.mathematics.linearprogramming;

import com.datumbox.framework.common.dataobjects.AssociativeArray;
import com.datumbox.framework.common.dataobjects.FlatDataList;
import com.datumbox.framework.core.common.utilities.PHPMethods;
import com.datumbox.framework.core.mathematics.linearprogramming.LPSolver;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;

public class DataEnvelopmentAnalysis {
    public AssociativeArray estimateEfficiency(Map<Object, DeaRecord> id2DeaRecordMapInput, Map<Object, DeaRecord> id2DeaRecordMapOutput) {
        int i;
        double[] conInput;
        double[] conOutput;
        AssociativeArray evaluatedResults = new AssociativeArray();
        ArrayList<LPSolver.LPConstraint> constraints = new ArrayList<LPSolver.LPConstraint>();
        Integer totalColumns = null;
        boolean hasInput = false;
        for (Map.Entry<Object, DeaRecord> entry : id2DeaRecordMapInput.entrySet()) {
            DeaRecord currentRecord = entry.getValue();
            int currentColumns = currentRecord.getInput().length;
            boolean currentHasInput = currentColumns > 0;
            currentColumns += currentRecord.getOutput().length;
            if (totalColumns == null) {
                totalColumns = currentColumns;
                hasInput = currentHasInput;
            } else {
                if (totalColumns != currentColumns) {
                    throw new IllegalArgumentException("The input and output columns do not match in all records.");
                }
                if (hasInput != currentHasInput) {
                    throw new IllegalArgumentException("The input should be used in all records or in none.");
                }
            }
            if (!hasInput) {
                constraints.add(new LPSolver.LPConstraint(currentRecord.getOutput(), LPSolver.LEQ, 1.0));
                continue;
            }
            double[] currentConstraintBody = new double[totalColumns.intValue()];
            conOutput = currentRecord.getOutput();
            for (int i2 = 0; i2 < conOutput.length; ++i2) {
                currentConstraintBody[i2] = conOutput[i2];
            }
            conInput = currentRecord.getInput();
            for (i = 0; i < conInput.length; ++i) {
                currentConstraintBody[conOutput.length + i] = -conInput[i];
            }
            constraints.add(new LPSolver.LPConstraint(currentConstraintBody, LPSolver.LEQ, 0.0));
        }
        for (Map.Entry<Object, DeaRecord> entry : id2DeaRecordMapOutput.entrySet()) {
            double[] objectiveFunction;
            Object currentRecordId = entry.getKey();
            DeaRecord currentRecord = entry.getValue();
            if (!hasInput) {
                objectiveFunction = currentRecord.getOutput();
            } else {
                objectiveFunction = new double[totalColumns.intValue()];
                double[] denominatorConstraintBody = new double[totalColumns.intValue()];
                conOutput = currentRecord.getOutput();
                for (int i3 = 0; i3 < conOutput.length; ++i3) {
                    objectiveFunction[i3] = conOutput[i3];
                    denominatorConstraintBody[i3] = 0.0;
                }
                conInput = currentRecord.getInput();
                for (i = 0; i < conInput.length; ++i) {
                    objectiveFunction[conOutput.length + i] = 0.0;
                    denominatorConstraintBody[conOutput.length + i] = conInput[i];
                }
                constraints.add(new LPSolver.LPConstraint(denominatorConstraintBody, LPSolver.EQ, 1.0));
            }
            LPSolver.LPResult result = LPSolver.solve(objectiveFunction, constraints, true, true);
            Double objectiveValue = result.getObjectiveValue();
            if (hasInput) {
                constraints.remove(constraints.size() - 1);
            }
            evaluatedResults.put(currentRecordId, objectiveValue);
        }
        return evaluatedResults;
    }

    public static class DeaRecord {
        private final double[] input;
        private final double[] output;

        public DeaRecord(FlatDataList output) {
            this.output = new double[output.size()];
            int column = 0;
            Iterator<Double> it = output.iteratorDouble();
            while (it.hasNext()) {
                this.output[column] = it.next();
                ++column;
            }
            this.input = new double[0];
        }

        public DeaRecord(FlatDataList output, FlatDataList input) {
            this.output = new double[output.size()];
            int column = 0;
            Iterator<Double> it = output.iteratorDouble();
            while (it.hasNext()) {
                this.output[column] = it.next();
                ++column;
            }
            this.input = new double[input.size()];
            column = 0;
            it = input.iteratorDouble();
            while (it.hasNext()) {
                this.input[column] = it.next();
                ++column;
            }
        }

        public double[] getInput() {
            return PHPMethods.array_clone(this.input);
        }

        public double[] getOutput() {
            return PHPMethods.array_clone(this.output);
        }
    }
}

