/*
 * Decompiled with CFR 0.152.
 */
package com.datumbox.framework.core.machinelearning.preprocessing;

import com.datumbox.framework.common.Configuration;
import com.datumbox.framework.common.concurrency.StreamMethods;
import com.datumbox.framework.common.dataobjects.AssociativeArray;
import com.datumbox.framework.common.dataobjects.FlatDataCollection;
import com.datumbox.framework.common.dataobjects.TypeInference;
import com.datumbox.framework.common.storage.interfaces.BigMap;
import com.datumbox.framework.common.storage.interfaces.StorageEngine;
import com.datumbox.framework.core.common.dataobjects.Dataframe;
import com.datumbox.framework.core.common.dataobjects.Record;
import com.datumbox.framework.core.machinelearning.common.abstracts.transformers.AbstractScaler;
import com.datumbox.framework.core.statistics.descriptivestatistics.Descriptives;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;

public class MinMaxScaler
extends AbstractScaler<ModelParameters, TrainingParameters> {
    protected MinMaxScaler(TrainingParameters trainingParameters, Configuration configuration) {
        super(trainingParameters, configuration);
    }

    protected MinMaxScaler(String storageName, Configuration configuration) {
        super(storageName, configuration);
    }

    @Override
    protected void _fit(Dataframe trainingData) {
        ModelParameters modelParameters = (ModelParameters)this.knowledgeBase.getModelParameters();
        Map<Object, Double> minColumnValues = modelParameters.getMinColumnValues();
        Map<Object, Double> maxColumnValues = modelParameters.getMaxColumnValues();
        boolean scaleResponse = ((TrainingParameters)this.knowledgeBase.getTrainingParameters()).getScaleResponse();
        Set<TypeInference.DataType> supportedXDataTypes = this.getSupportedXDataTypes();
        Stream<Object> transformedColumns = trainingData.getXDataTypes().entrySet().stream().filter(e -> supportedXDataTypes.contains(e.getValue())).map(e -> e.getKey());
        this.streamExecutor.forEach(StreamMethods.stream(transformedColumns, this.isParallelized()), column -> {
            FlatDataCollection columnValues = trainingData.getXColumn(column).toFlatDataCollection();
            minColumnValues.put(column, Descriptives.min(columnValues));
            maxColumnValues.put(column, Descriptives.max(columnValues));
        });
        if (scaleResponse && trainingData.getYDataType() == TypeInference.DataType.NUMERICAL) {
            FlatDataCollection columnValues = trainingData.getYColumn().toFlatDataCollection();
            minColumnValues.put("~Y", Descriptives.min(columnValues));
            maxColumnValues.put("~Y", Descriptives.max(columnValues));
        }
    }

    @Override
    protected void _transform(Dataframe newData) {
        ModelParameters modelParameters = (ModelParameters)this.knowledgeBase.getModelParameters();
        Map<Object, Double> minColumnValues = modelParameters.getMinColumnValues();
        Map<Object, Double> maxColumnValues = modelParameters.getMaxColumnValues();
        boolean scaleResponse = ((TrainingParameters)this.knowledgeBase.getTrainingParameters()).getScaleResponse() && minColumnValues.containsKey("~Y");
        this.streamExecutor.forEach(StreamMethods.stream(newData.entries(), this.isParallelized()), e -> {
            Record r = (Record)e.getValue();
            AssociativeArray xData = r.getX().copy();
            Object yData = r.getY();
            boolean modified = false;
            for (Object column : r.getX().keySet()) {
                Double min = (Double)minColumnValues.get(column);
                if (min == null) continue;
                Object value = xData.remove(column);
                if (value != null) {
                    Double max = (Double)maxColumnValues.get(column);
                    xData.put(column, this.scale(TypeInference.toDouble(value), min, max));
                }
                modified = true;
            }
            if (scaleResponse && yData != null) {
                Double value = TypeInference.toDouble(yData);
                Double min = (Double)minColumnValues.get("~Y");
                Double max = (Double)maxColumnValues.get("~Y");
                yData = this.scale(value, min, max);
                modified = true;
            }
            if (modified) {
                Integer rId = (Integer)e.getKey();
                Record newR = new Record(xData, yData, r.getYPredicted(), r.getYPredictedProbabilities());
                newData._unsafe_set(rId, newR);
            }
        });
    }

    private Double scale(Double value, Double min, Double max) {
        if (min.equals(max)) {
            if (value > max) {
                return 1.0;
            }
            if (value == max && value != 0.0) {
                return 1.0;
            }
            return 0.0;
        }
        return (value - min) / (max - min);
    }

    public static class TrainingParameters
    extends AbstractScaler.AbstractTrainingParameters {
        private static final long serialVersionUID = 1L;
    }

    public static class ModelParameters
    extends AbstractScaler.AbstractModelParameters {
        private static final long serialVersionUID = 1L;
        @BigMap(keyClass=Object.class, valueClass=Double.class, mapType=StorageEngine.MapType.HASHMAP, storageHint=StorageEngine.StorageHint.IN_MEMORY, concurrent=true)
        private Map<Object, Double> minColumnValues;
        @BigMap(keyClass=Object.class, valueClass=Double.class, mapType=StorageEngine.MapType.HASHMAP, storageHint=StorageEngine.StorageHint.IN_MEMORY, concurrent=true)
        private Map<Object, Double> maxColumnValues;

        protected ModelParameters(StorageEngine storageEngine) {
            super(storageEngine);
        }

        public Map<Object, Double> getMinColumnValues() {
            return this.minColumnValues;
        }

        protected void setMinColumnValues(Map<Object, Double> minColumnValues) {
            this.minColumnValues = minColumnValues;
        }

        public Map<Object, Double> getMaxColumnValues() {
            return this.maxColumnValues;
        }

        protected void setMaxColumnValues(Map<Object, Double> maxColumnValues) {
            this.maxColumnValues = maxColumnValues;
        }
    }
}

