/*
 * Decompiled with CFR 0.152.
 */
package com.datumbox.framework.core.machinelearning.preprocessing;

import com.datumbox.framework.common.Configuration;
import com.datumbox.framework.common.concurrency.StreamMethods;
import com.datumbox.framework.common.dataobjects.AssociativeArray;
import com.datumbox.framework.common.dataobjects.FlatDataCollection;
import com.datumbox.framework.common.dataobjects.TypeInference;
import com.datumbox.framework.common.storage.interfaces.BigMap;
import com.datumbox.framework.common.storage.interfaces.StorageEngine;
import com.datumbox.framework.core.common.dataobjects.Dataframe;
import com.datumbox.framework.core.common.dataobjects.Record;
import com.datumbox.framework.core.machinelearning.common.abstracts.transformers.AbstractScaler;
import com.datumbox.framework.core.statistics.descriptivestatistics.Descriptives;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;

public class MaxAbsScaler
extends AbstractScaler<ModelParameters, TrainingParameters> {
    protected MaxAbsScaler(TrainingParameters trainingParameters, Configuration configuration) {
        super(trainingParameters, configuration);
    }

    protected MaxAbsScaler(String storageName, Configuration configuration) {
        super(storageName, configuration);
    }

    @Override
    protected void _fit(Dataframe trainingData) {
        ModelParameters modelParameters = (ModelParameters)this.knowledgeBase.getModelParameters();
        Map<Object, Double> maxAbsoluteColumnValues = modelParameters.getMaxAbsoluteColumnValues();
        boolean scaleResponse = ((TrainingParameters)this.knowledgeBase.getTrainingParameters()).getScaleResponse();
        Set<TypeInference.DataType> supportedXDataTypes = this.getSupportedXDataTypes();
        Stream<Object> transformedColumns = trainingData.getXDataTypes().entrySet().stream().filter(e -> supportedXDataTypes.contains(e.getValue())).map(e -> e.getKey());
        this.streamExecutor.forEach(StreamMethods.stream(transformedColumns, this.isParallelized()), column -> {
            FlatDataCollection columnValues = trainingData.getXColumn(column).toFlatDataCollection();
            maxAbsoluteColumnValues.put(column, Descriptives.maxAbsolute(columnValues));
        });
        if (scaleResponse && trainingData.getYDataType() == TypeInference.DataType.NUMERICAL) {
            FlatDataCollection columnValues = trainingData.getYColumn().toFlatDataCollection();
            maxAbsoluteColumnValues.put("~Y", Descriptives.maxAbsolute(columnValues));
        }
    }

    @Override
    protected void _transform(Dataframe newData) {
        ModelParameters modelParameters = (ModelParameters)this.knowledgeBase.getModelParameters();
        Map<Object, Double> maxAbsoluteColumnValues = modelParameters.getMaxAbsoluteColumnValues();
        boolean scaleResponse = ((TrainingParameters)this.knowledgeBase.getTrainingParameters()).getScaleResponse() && maxAbsoluteColumnValues.containsKey("~Y");
        this.streamExecutor.forEach(StreamMethods.stream(newData.entries(), this.isParallelized()), e -> {
            Record r = (Record)e.getValue();
            AssociativeArray xData = r.getX().copy();
            Object yData = r.getY();
            boolean modified = false;
            for (Object column : r.getX().keySet()) {
                Double maxAbsolute = (Double)maxAbsoluteColumnValues.get(column);
                if (maxAbsolute == null) continue;
                Object value = xData.remove(column);
                if (value != null) {
                    xData.put(column, this.scale(TypeInference.toDouble(value), maxAbsolute));
                }
                modified = true;
            }
            if (scaleResponse && yData != null) {
                Double value = TypeInference.toDouble(yData);
                Double maxAbsolute = (Double)maxAbsoluteColumnValues.get("~Y");
                yData = this.scale(value, maxAbsolute);
                modified = true;
            }
            if (modified) {
                Integer rId = (Integer)e.getKey();
                Record newR = new Record(xData, yData, r.getYPredicted(), r.getYPredictedProbabilities());
                newData._unsafe_set(rId, newR);
            }
        });
    }

    private Double scale(Double value, Double maxAbsolute) {
        if (maxAbsolute.equals(0.0)) {
            return Math.signum(value);
        }
        return value / maxAbsolute;
    }

    public static class TrainingParameters
    extends AbstractScaler.AbstractTrainingParameters {
        private static final long serialVersionUID = 1L;
    }

    public static class ModelParameters
    extends AbstractScaler.AbstractModelParameters {
        private static final long serialVersionUID = 1L;
        @BigMap(keyClass=Object.class, valueClass=Double.class, mapType=StorageEngine.MapType.HASHMAP, storageHint=StorageEngine.StorageHint.IN_MEMORY, concurrent=true)
        private Map<Object, Double> maxAbsoluteColumnValues;

        protected ModelParameters(StorageEngine storageEngine) {
            super(storageEngine);
        }

        public Map<Object, Double> getMaxAbsoluteColumnValues() {
            return this.maxAbsoluteColumnValues;
        }

        protected void setMaxAbsoluteColumnValues(Map<Object, Double> maxAbsoluteColumnValues) {
            this.maxAbsoluteColumnValues = maxAbsoluteColumnValues;
        }
    }
}

