/*
 * Decompiled with CFR 0.152.
 */
package com.datumbox.framework.core.machinelearning.featureselection;

import com.datumbox.framework.common.Configuration;
import com.datumbox.framework.common.concurrency.StreamMethods;
import com.datumbox.framework.common.dataobjects.AssociativeArray;
import com.datumbox.framework.common.dataobjects.DataTable2D;
import com.datumbox.framework.common.storage.interfaces.StorageEngine;
import com.datumbox.framework.core.machinelearning.common.abstracts.featureselectors.AbstractCountBasedFeatureSelector;
import com.datumbox.framework.core.machinelearning.common.abstracts.featureselectors.AbstractScoreBasedFeatureSelector;
import com.datumbox.framework.core.statistics.distributions.ContinuousDistributions;
import com.datumbox.framework.core.statistics.nonparametrics.independentsamples.Chisquare;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class ChisquareSelect
extends AbstractCountBasedFeatureSelector<ModelParameters, TrainingParameters> {
    protected ChisquareSelect(TrainingParameters trainingParameters, Configuration configuration) {
        super(trainingParameters, configuration);
    }

    protected ChisquareSelect(String storageName, Configuration configuration) {
        super(storageName, configuration);
    }

    @Override
    protected void estimateFeatureScores(Map<Object, Double> featureScores, int N, Map<Object, Integer> classCounts, Map<List<Object>, Integer> featureClassCounts, Map<Object, Double> featureCounts) {
        this.logger.debug("estimateFeatureScores()");
        double criticalValue = ContinuousDistributions.chisquareInverseCdf(((TrainingParameters)this.knowledgeBase.getTrainingParameters()).getALevel(), 1);
        this.streamExecutor.forEach(StreamMethods.stream(featureCounts.entrySet().stream(), this.isParallelized()), featureCount -> {
            Object feature = featureCount.getKey();
            double N1_ = (Double)featureCount.getValue();
            double N0_ = (double)N - N1_;
            double bestScore = Double.NEGATIVE_INFINITY;
            DataTable2D contingencyTable = new DataTable2D();
            contingencyTable.put(0, new AssociativeArray());
            contingencyTable.put(1, new AssociativeArray());
            for (Map.Entry classCount : classCounts.entrySet()) {
                Object theClass = classCount.getKey();
                Integer featureClassC = (Integer)featureClassCounts.get(Arrays.asList(feature, theClass));
                double N11 = featureClassC != null ? featureClassC.doubleValue() : 0.0;
                double N01 = (double)((Integer)classCount.getValue()).intValue() - N11;
                double N00 = N0_ - N01;
                double N10 = N1_ - N11;
                contingencyTable.put2d(0, 0, N00);
                contingencyTable.put2d(0, 1, N01);
                contingencyTable.put2d(1, 0, N10);
                contingencyTable.put2d(1, 1, N11);
                double scorevalue = Chisquare.getScoreValue(contingencyTable);
                if (!(scorevalue > bestScore)) continue;
                bestScore = scorevalue;
            }
            if (bestScore >= criticalValue) {
                featureScores.put(feature, bestScore);
            }
        });
    }

    public static class TrainingParameters
    extends AbstractScoreBasedFeatureSelector.AbstractTrainingParameters {
        private static final long serialVersionUID = 1L;
        private double aLevel = 0.05;

        public double getALevel() {
            return this.aLevel;
        }

        public void setALevel(double aLevel) {
            if (aLevel > 1.0 || aLevel < 0.0) {
                throw new IllegalArgumentException("Invalid value for the level of statistical significance.");
            }
            this.aLevel = aLevel;
        }
    }

    public static class ModelParameters
    extends AbstractScoreBasedFeatureSelector.AbstractModelParameters {
        private static final long serialVersionUID = 1L;

        protected ModelParameters(StorageEngine storageEngine) {
            super(storageEngine);
        }
    }
}

