/*
 * Decompiled with CFR 0.152.
 */
package com.datumbox.framework.core.machinelearning.common.dataobjects;

import com.datumbox.framework.common.Configuration;
import com.datumbox.framework.common.storage.interfaces.StorageEngine;
import com.datumbox.framework.core.common.interfaces.Savable;
import com.datumbox.framework.core.machinelearning.common.interfaces.ModelParameters;
import com.datumbox.framework.core.machinelearning.common.interfaces.TrainingParameters;

public class KnowledgeBase<MP extends ModelParameters, TP extends TrainingParameters>
implements Savable {
    private final Configuration configuration;
    private final StorageEngine storageEngine;
    private MP modelParameters;
    private final TP trainingParameters;

    public KnowledgeBase(String storageName, Configuration configuration, TP trainingParameters) {
        this.configuration = configuration;
        this.storageEngine = this.configuration.getStorageConfiguration().createStorageEngine(storageName);
        this.trainingParameters = trainingParameters;
        this.modelParameters = ModelParameters.newInstance(trainingParameters.getMPClass(), this.storageEngine);
    }

    public KnowledgeBase(String storageName, Configuration configuration) {
        this.configuration = configuration;
        this.storageEngine = this.configuration.getStorageConfiguration().createStorageEngine(storageName);
        this.trainingParameters = this.storageEngine.loadObject("trainingParameters", TrainingParameters.class);
        this.modelParameters = this.storageEngine.loadObject("modelParameters", ModelParameters.class);
    }

    public StorageEngine getStorageEngine() {
        return this.storageEngine;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public TP getTrainingParameters() {
        return this.trainingParameters;
    }

    public MP getModelParameters() {
        return this.modelParameters;
    }

    @Override
    public void save(String storageName) {
        this.storageEngine.saveObject("modelParameters", this.modelParameters);
        this.storageEngine.saveObject("trainingParameters", this.trainingParameters);
        this.storageEngine.rename(storageName);
        this.modelParameters = this.storageEngine.loadObject("modelParameters", ModelParameters.class);
    }

    @Override
    public void delete() {
        this.storageEngine.clear();
        this.close();
    }

    @Override
    public void close() {
        try {
            this.storageEngine.close();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public void clear() {
        this.storageEngine.clear();
        this.modelParameters = ModelParameters.newInstance(this.trainingParameters.getMPClass(), this.storageEngine);
    }
}

