/*
 * Decompiled with CFR 0.152.
 */
package com.datumbox.framework.core.common.utilities;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;

public class SelectKth {
    public static Double largest(final Iterator<Double> elements, int k) {
        Iterator<Double> oppositeElements = new Iterator<Double>(){

            @Override
            public boolean hasNext() {
                return elements.hasNext();
            }

            @Override
            public Double next() {
                return -((Double)elements.next()).doubleValue();
            }
        };
        return -SelectKth.smallest(oppositeElements, k).doubleValue();
    }

    public static Double smallest(Iterator<Double> elements, int k) {
        Double e;
        if (k <= 0 || !elements.hasNext()) {
            return null;
        }
        if (k >= 0x3FFFFFFF) {
            ArrayList<Double> list = new ArrayList<Double>();
            while (elements.hasNext()) {
                list.add(elements.next());
            }
            Collections.sort(list);
            return (Double)list.get(k - 1);
        }
        int bufferCap = k * 2;
        Object[] buffer = new Double[bufferCap];
        Object threshold = elements.next();
        buffer[0] = threshold;
        int bufferSize = 1;
        while (bufferSize < k && elements.hasNext()) {
            e = elements.next();
            buffer[bufferSize++] = e;
            threshold = Math.max((Double)threshold, e);
        }
        while (elements.hasNext()) {
            e = elements.next();
            if (e >= (Double)threshold) continue;
            buffer[bufferSize++] = e;
            if (bufferSize != bufferCap) continue;
            int left = 0;
            int right = bufferCap - 1;
            int minThresholdPosition = 0;
            while (left < right) {
                int pivotIndex = left + right + 1 >>> 1;
                Object pivotValue = buffer[pivotIndex];
                buffer[pivotIndex] = buffer[right];
                buffer[right] = pivotValue;
                int pivotNewIndex = left;
                for (int l = left; l < right; ++l) {
                    if (!((Double)buffer[l] < (Double)pivotValue)) continue;
                    Object temp = buffer[pivotNewIndex];
                    buffer[pivotNewIndex] = buffer[l];
                    buffer[l] = temp;
                    ++pivotNewIndex;
                }
                Object temp = buffer[right];
                buffer[right] = buffer[pivotNewIndex];
                buffer[pivotNewIndex] = temp;
                if (pivotNewIndex > k) {
                    right = pivotNewIndex - 1;
                    continue;
                }
                if (pivotNewIndex >= k) break;
                left = Math.max(pivotNewIndex, left + 1);
                minThresholdPosition = pivotNewIndex;
            }
            bufferSize = k;
            threshold = buffer[minThresholdPosition];
            for (int i = minThresholdPosition + 1; i < bufferSize; ++i) {
                threshold = Math.max((Double)threshold, (Double)buffer[i]);
            }
        }
        Arrays.sort(buffer, 0, bufferSize);
        k = Math.min(bufferSize, k);
        return buffer[k - 1];
    }
}

