/*
 * Decompiled with CFR 0.152.
 */
package com.datumbox.framework.common.utilities;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;

public class ReflectionMethods {
    public static List<Field> getAllFields(List<Field> fields, Class<?> type) {
        fields.addAll(Arrays.asList(type.getDeclaredFields()));
        if (type.getSuperclass() != null) {
            fields = ReflectionMethods.getAllFields(fields, type.getSuperclass());
        }
        return fields;
    }

    public static Method findMethod(Object obj, String methodName, Object ... params) {
        Class[] classArray = new Class[params.length];
        for (int i = 0; i < params.length; ++i) {
            classArray[i] = params[i].getClass();
        }
        try {
            for (Class<?> klass = obj.getClass(); klass != null; klass = klass.getSuperclass()) {
                for (Method method : klass.getDeclaredMethods()) {
                    if (!method.getName().equals(methodName) || method.getParameterCount() != classArray.length) continue;
                    Class<?>[] paramClasses = method.getParameterTypes();
                    boolean parametersMatch = true;
                    for (int i = 0; i < params.length; ++i) {
                        if (paramClasses[i].isAssignableFrom(classArray[i])) continue;
                        parametersMatch = false;
                        break;
                    }
                    if (!parametersMatch) continue;
                    return method;
                }
            }
            throw new NoSuchMethodException();
        }
        catch (NoSuchMethodException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static Object invokeMethod(Object obj, Method method, Object ... params) {
        try {
            method.setAccessible(true);
            return method.invoke(obj, params);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static Object invokeMethod(Object obj, String methodName, Object ... params) {
        Method method = ReflectionMethods.findMethod(obj, methodName, params);
        return ReflectionMethods.invokeMethod(obj, method, params);
    }
}

