/*
 * Decompiled with CFR 0.152.
 */
package com.datumbox.framework.common.concurrency;

import java.util.AbstractMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Spliterator;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class StreamMethods {
    public static <T> Stream<T> stream(Spliterator<T> spliterator, boolean parallel) {
        return StreamSupport.stream(spliterator, parallel);
    }

    public static <T> Stream<T> stream(Iterable<T> iterable, boolean parallel) {
        return StreamSupport.stream(iterable.spliterator(), parallel);
    }

    public static <T> Stream<T> stream(Stream<T> stream, boolean parallel) {
        if (parallel) {
            return (Stream)stream.parallel();
        }
        return (Stream)stream.sequential();
    }

    public static <T> Stream<T> stream(Iterator<T> iterator, boolean parallel) {
        Iterable iterable = () -> iterator;
        return StreamSupport.stream(iterable.spliterator(), parallel);
    }

    public static <T> Stream<Map.Entry<Integer, T>> enumerate(final Stream<T> stream) {
        Iterator iterator = new Iterator<Map.Entry<Integer, T>>(){
            private int counter = 0;
            private final Iterator<T> internalIterator = stream.iterator();

            @Override
            public boolean hasNext() {
                return this.internalIterator.hasNext();
            }

            @Override
            public Map.Entry<Integer, T> next() {
                return new AbstractMap.SimpleImmutableEntry(this.counter++, this.internalIterator.next());
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("This is a read-only iterator, remove operation is not supported.");
            }
        };
        return StreamMethods.stream(iterator, stream.isParallel());
    }
}

