/*
 * Decompiled with CFR 0.152.
 */
package org.jscience.physics.amount;

import javax.measure.quantity.Acceleration;
import javax.measure.quantity.Dimensionless;
import javax.measure.quantity.Duration;
import javax.measure.quantity.ElectricCharge;
import javax.measure.quantity.ElectricConductance;
import javax.measure.quantity.ElectricResistance;
import javax.measure.quantity.Length;
import javax.measure.quantity.MagneticFlux;
import javax.measure.quantity.Mass;
import javax.measure.quantity.Velocity;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import org.jscience.physics.amount.Amount;

public final class Constants {
    public static final Amount<Acceleration> g = Amount.valueOf(980665L, SI.METRES_PER_SQUARE_SECOND).divide(100000L);
    public static final Amount<Mass> me = Amount.valueOf(9.1093826E-31, 1.6E-37, SI.KILOGRAM);
    public static final Amount<Mass> mp = Amount.valueOf(1.67262171E-27, 2.9E-34, SI.KILOGRAM);
    public static final Amount<Mass> mn = Amount.valueOf(1.67492728E-27, 2.9E-34, SI.KILOGRAM);
    public static final Amount<Mass> md = Amount.valueOf(3.34358335E-27, 5.7E-34, SI.KILOGRAM);
    public static final Amount<Mass> m\u03bc = Amount.valueOf(1.8835314E-28, 3.3E-35, SI.KILOGRAM);
    public static final Amount<Dimensionless> \u03c0 = Amount.valueOf(Math.PI, Unit.ONE);
    public static final Amount<Dimensionless> half_\u03c0 = Amount.valueOf(1.5707963267948966, Unit.ONE);
    public static final Amount<Dimensionless> two_\u03c0 = Amount.valueOf(Math.PI * 2, Unit.ONE);
    public static final Amount<Dimensionless> four_\u03c0 = Amount.valueOf(Math.PI * 4, Unit.ONE);
    public static final Amount<Dimensionless> \u03c0_square = Amount.valueOf(Math.PI * Math.PI, Unit.ONE);
    public static final Amount<Velocity> c = Amount.valueOf(299792458L, SI.METRES_PER_SECOND);
    public static final Amount<?> c_square = Amount.valueOf(89875517873681764L, SI.METRES_PER_SECOND.pow(2));
    public static final Amount<?> k = Amount.valueOf(1.3806505E-23, 2.4E-29, SI.JOULE.divide(SI.KELVIN));
    public static final Amount<?> \u210e = Amount.valueOf(6.6260693E-34, 1.1E-40, SI.JOULE.times(SI.SECOND));
    public static final Amount<?> \u210f = \u210e.divide(two_\u03c0);
    public static final Amount<ElectricCharge> e = Amount.valueOf(1.60217653E-19, 1.4E-26, SI.COULOMB);
    public static final Amount<?> \u00b50 = Amount.valueOf(1.2566370614359173E-6, SI.NEWTON.divide(SI.AMPERE.pow(2)));
    public static final Amount<?> \u03b50 = \u00b50.times(c.pow(2)).inverse();
    public static final Amount<ElectricResistance> Z0 = \u00b50.times(c).to(SI.OHM);
    public static final Amount<Dimensionless> \u03b1 = e.pow(2).divide(\u03b50.times(c).times(\u210e).times(2L)).to(Unit.ONE);
    public static final Amount<?> G = Amount.valueOf(6.6742E-11, 1.0E-14, SI.METRE.pow(3).divide(SI.KILOGRAM).divide(SI.SECOND.pow(2)));
    public static final Amount<?> N = Amount.valueOf(6.0221415E23, 1.0E17, Unit.ONE.divide(SI.MOLE));
    public static final Amount<?> R = N.times(k);
    public static final Amount<?> F = N.times(e);
    public static final Amount<?> \u03c3 = \u03c0_square.divide(60L).times(k.pow(4)).divide(\u210f.pow(3).times(c.pow(2)));
    public static final Amount<Mass> amu = Amount.valueOf(0.001, SI.KILOGRAM.divide(SI.MOLE)).divide(N).to(SI.KILOGRAM);
    public static final Amount<?> Rinf = Amount.valueOf(1.0973731568525E7, 7.3E-5, SI.METRE.inverse());
    public static final Amount<Length> a0 = \u03b1.divide(\u03c0.times(Rinf).times(4L)).to(SI.METRE);
    public static final Amount<?> Eh = Rinf.times(\u210e).times(c).times(2L);
    public static final Amount<MagneticFlux> \u03a60 = \u210e.divide(e).divide(2L).to(SI.WEBER);
    public static final Amount<ElectricConductance> G0 = e.pow(2).divide(\u210e).times(2L).to(ElectricConductance.UNIT);
    public static final Amount<?> \u00b5B = e.times(\u210f).divide(me).divide(2L);
    public static final Amount<?> \u00b5N = e.times(\u210f).divide(mp).divide(2L);
    public static final Amount<Mass> mP = \u210f.times(c).divide(G).root(2).to(SI.KILOGRAM);
    public static final Amount<Length> lP = \u210f.divide(mP.times(c)).to(SI.METRE);
    public static final Amount<Duration> tP = lP.divide(c).to(SI.SECOND);

    private Constants() {
    }
}

